/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel;

import jmce.intel.DmaChannel;
import jmce.intel.DmaController;
import jmce.intel.DmaRequest;
import jmce.intel.DmaRequestMaster;
import jmce.intel.DmaRequestRead;
import jmce.intel.DmaRequestWrite;
import jmce.sim.AbstractPeripheral;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.util.Timer;
import jmce.util.TimerListener;

public class I8237
extends AbstractPeripheral
implements DmaController {
    private static Logger log = Logger.getLogger(I8237.class);
    public static final int MODE_DMA_MASK = 192;
    public static final int MODE_DMA_DEMAND = 0;
    public static final int MODE_DMA_SINGLE = 64;
    public static final int MODE_DMA_BLOCK = 128;
    public static final int MODE_DMA_CASCADE = 192;
    public static final int MODE_DECREMENT = 32;
    public static final int MODE_AUTO = 16;
    public static final int MODE_TRANSFER_MASK = 12;
    public static final int MODE_TRANSFER_VERIFY = 0;
    public static final int MODE_TRANSFER_READ = 8;
    public static final int MODE_TRANSFER_WRITE = 4;
    I8237Channel[] channels;
    private int lastByte;
    private int port;

    I8237() {
        this(0);
    }

    I8237(int port) {
        this("i8237", port);
    }

    I8237(String name, int port) {
        this.setName(name);
        this.setPort(port);
        this.channels = new I8237Channel[4];
        for (int i = 0; i < 4; ++i) {
            this.channels[i] = new I8237Channel(i);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int readMemory(Memory m, int a, int v) throws SIMException {
        switch (a - this.port) {
            case 0: {
                v = this.channels[0].readBase();
                break;
            }
            case 1: {
                v = this.channels[0].readCount();
                break;
            }
            case 2: {
                v = this.channels[1].readBase();
                break;
            }
            case 3: {
                v = this.channels[1].readCount();
                break;
            }
            case 4: {
                v = this.channels[2].readBase();
                break;
            }
            case 5: {
                v = this.channels[2].readCount();
                break;
            }
            case 6: {
                v = this.channels[3].readBase();
                break;
            }
            case 7: {
                v = this.channels[3].readCount();
                break;
            }
            case 8: {
                v = 0;
                for (int i = 0; i < 4; ++i) {
                    if (this.channels[i].getTc()) {
                        v |= 1 << i;
                    }
                    if (!this.channels[i].request()) continue;
                    v |= 16 << i;
                }
                break;
            }
            case 13: {
                v = this.lastByte;
            }
        }
        return v;
    }

    public void writeMemory(Memory m, int a, int v, int oldValue) throws SIMException {
        switch (a - this.port) {
            case 0: {
                this.channels[0].writeBase(v);
                break;
            }
            case 1: {
                this.channels[0].writeCount(v);
                break;
            }
            case 2: {
                this.channels[1].writeBase(v);
                break;
            }
            case 3: {
                this.channels[1].writeCount(v);
                break;
            }
            case 4: {
                this.channels[2].writeBase(v);
                break;
            }
            case 5: {
                this.channels[2].writeCount(v);
                break;
            }
            case 6: {
                this.channels[3].writeBase(v);
                break;
            }
            case 7: {
                this.channels[3].writeCount(v);
                break;
            }
            case 8: {
                for (int i = 0; i < 4; ++i) {
                    this.channels[i].setEnabled((v & 4) == 0);
                }
                this.channels[0].setHold((v & 2) != 0);
                break;
            }
            case 15: {
                for (int i = 0; i < 4; ++i) {
                    if ((v & 1 << i) != 0) {
                        this.channels[i].setMask(true);
                        continue;
                    }
                    this.channels[i].setMask(false);
                }
                break;
            }
            case 9: {
                I8237Channel c = this.channels[v & 3];
                if ((v & 4) != 0) {
                    c.request(true);
                    break;
                }
                c.request(false);
                break;
            }
            case 10: {
                I8237Channel c = this.channels[v & 3];
                if ((v & 4) != 0) {
                    c.setMask(true);
                    break;
                }
                c.setMask(false);
                break;
            }
            case 11: {
                I8237Channel c = this.channels[v & 3];
                c.setMode(v);
                break;
            }
            case 12: {
                for (int i = 0; i < 4; ++i) {
                    if ((v & 1 << i) == 0) continue;
                    this.channels[i].clear();
                }
                break;
            }
            case 13: {
                for (int i = 0; i < 4; ++i) {
                    this.channels[i].reset();
                }
                this.lastByte = 0;
            }
        }
    }

    void transferToMemory(I8237Channel c, int address, int value) throws SIMException {
        this.lastByte = value;
        this.cpu.setByte(address, value);
    }

    int transferFromMemory(I8237Channel c, int address) throws SIMException {
        this.lastByte = this.cpu.getByte(address);
        return this.lastByte;
    }

    @Override
    public int getChannelCount() {
        return 4;
    }

    @Override
    public DmaChannel getChannelAt(int i) {
        return this.channels[i];
    }

    @Override
    public String toString() {
        return this.getName() + " AT " + Hex.formatWord(this.port);
    }

    public class I8237Channel
    implements DmaChannel {
        int ch;
        WordRegister base;
        WordRegister count;
        private int mode;
        private boolean tc;
        private boolean request;
        private boolean enabled;
        private boolean hold;
        private boolean mask;
        private Timer timerRead;
        private Timer timerWrite;
        private DmaRequestRead requestRead;
        private DmaRequestWrite requestWrite;

        I8237Channel(int ch) {
            this.base = new WordRegister();
            this.count = new WordRegister();
            this.requestRead = null;
            this.requestWrite = null;
            this.ch = ch;
            this.reset();
            this.timerRead = new Timer(10, false, new TimerListener(){

                @Override
                public void timerExpired() throws SIMException {
                    I8237Channel.this.ackRead();
                }
            });
            this.timerWrite = new Timer(10, false, new TimerListener(){

                @Override
                public void timerExpired() throws SIMException {
                    I8237Channel.this.ackWrite();
                }
            });
        }

        void setMode(int mode) {
            this.mode = mode;
        }

        void setEnabled(boolean b) {
            this.enabled = b;
        }

        void clear() {
            this.base.clear();
            this.count.clear();
        }

        void dump() {
            log.info("Ch # " + this.ch + " Mode=" + Hex.formatByte(this.mode) + " Base=" + Hex.formatWord(this.base.getValue()) + " Count=" + Hex.formatWord(this.count.getValue()));
            log.info("Ch # " + this.ch + " Hold=" + this.hold + " Request=" + this.request + " TC=" + this.tc + " Enabled=" + this.enabled + " Mask=" + this.mask);
        }

        void setHold(boolean b) {
            this.hold = b;
        }

        boolean getTc() {
            return this.tc;
        }

        void request(boolean b) {
            this.request = b;
        }

        boolean request() {
            return this.request;
        }

        void reset() {
            this.setMask(true);
            this.clear();
            this.writeBase(0);
            this.writeBase(0);
            this.writeCount(0);
            this.writeCount(0);
            this.hold = false;
            this.request = false;
            this.tc = false;
            this.enabled = true;
            I8237.this.lastByte = 0;
            log.info("Ch #" + this.ch + " reset");
            this.dump();
        }

        void setMask(boolean mask) {
            this.mask = mask;
        }

        int readBase() {
            return this.base.read();
        }

        int readCount() {
            return this.count.read();
        }

        void writeBase(int v) {
            this.base.write(v);
        }

        void writeCount(int v) {
            this.count.write(v);
        }

        public boolean checkReady() {
            if (!this.enabled) {
                log.info("Ch#" + this.ch + " not enabled");
                return false;
            }
            if (this.mask) {
                log.info("Ch#" + this.ch + " maskered");
                return false;
            }
            return true;
        }

        @Override
        public void dmaRequest(DmaRequestMaster m) throws SIMException {
            if (!this.checkReady()) {
                return;
            }
            if ((this.mode & 0xC0) != 192) {
                throw new SIMException("Mode=" + Hex.formatByte(this.mode) + " is not cascade");
            }
            this.request = true;
            m.dmaMaster(I8237.this.cpu);
            this.request = false;
        }

        @Override
        public void dmaRequest(DmaRequestRead read) throws SIMException {
            if (!this.checkReady()) {
                return;
            }
            if ((this.mode & 0xC0) == 192) {
                throw new SIMException("Mode=" + Hex.formatByte(this.mode) + " can not be cascade");
            }
            if ((this.mode & 0xC) != 8 && (this.mode & 0xC) != 0) {
                throw new SIMException("Only READ and VERIFY transfer allowed");
            }
            this.requestRead = read;
            this.request = true;
            I8237.this.cpu.addTimerCycle(this.timerRead);
        }

        @Override
        public void dmaRequest(DmaRequestWrite write) throws SIMException {
            if (!this.checkReady()) {
                return;
            }
            if ((this.mode & 0xC0) == 192) {
                throw new SIMException("Mode=" + Hex.formatByte(this.mode) + " can not be cascade");
            }
            if ((this.mode & 0xC) != 4 && (this.mode & 0xC) != 0) {
                throw new SIMException("Only WRITE and VERIFY transfer allowed");
            }
            this.requestWrite = write;
            this.request = true;
            I8237.this.cpu.addTimerCycle(this.timerWrite);
        }

        private void ackRead() throws SIMException {
            do {
                if ((this.mode & 0xC) == 8) {
                    int v = I8237.this.transferFromMemory(this, this.base.getValue());
                    this.requestRead.setDmaValue(v);
                }
                if (!this.hold) {
                    if ((this.mode & 0x20) != 0) {
                        this.base.decrement();
                    } else {
                        this.base.increment();
                    }
                }
                if (!this.isTerminate(this.requestRead)) continue;
                this.terminateDma();
                return;
            } while ((this.mode & 0xC0) != 64 || this.requestRead.getDmaDREQ());
            this.request = false;
        }

        private void ackWrite() throws SIMException {
            do {
                if ((this.mode & 0xC) == 4) {
                    int v = this.requestWrite.getDmaValue();
                    I8237.this.transferToMemory(this, this.base.getValue(), v);
                }
                if (!this.hold) {
                    if ((this.mode & 0x20) != 0) {
                        this.base.decrement();
                    } else {
                        this.base.increment();
                    }
                }
                if (!this.isTerminate(this.requestWrite)) continue;
                this.terminateDma();
                return;
            } while ((this.mode & 0xC0) != 64 || this.requestRead.getDmaDREQ());
            this.request = false;
        }

        boolean isTerminate(DmaRequest req) {
            this.count.decrement();
            if (this.count.getValue() == 0) {
                return true;
            }
            if (req.getDmaEOP()) {
                return true;
            }
            switch (this.mode & 0xC0) {
                case 0: {
                    if (req.getDmaDREQ()) break;
                    return true;
                }
            }
            return false;
        }

        void terminateDma() {
            this.tc = true;
            this.request = false;
            if ((this.mode & 0x10) != 0) {
                this.tc = false;
                this.count.restore();
                this.base.restore();
            }
        }
    }

    public class WordRegister {
        private boolean ptr = false;
        int value = 0;
        int savedValue;

        WordRegister() {
        }

        void write(int v) {
            this.value = this.ptr ? this.value & 0xFF | (v & 0xFF) << 8 : this.value & 0xFF00 | v & 0xFF;
            this.ptr = !this.ptr;
            this.savedValue = this.value;
        }

        int read() {
            int v = this.ptr ? this.value >>> 8 : this.value & 0xFF;
            this.ptr = !this.ptr;
            return v;
        }

        void clear() {
            this.ptr = false;
        }

        int getValue() {
            return this.value;
        }

        void setValue(int v) {
            this.value = v;
        }

        void restore() {
            this.value = this.savedValue;
        }

        void decrement() {
            this.value = this.value - 1 & 0xFFFF;
        }

        void increment() {
            this.value = this.value + 1 & 0xFFFF;
        }
    }
}

