/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.i8086;

import jmce.intel.i8086.I8086Constants;
import jmce.intel.i8086.OpcodePrefix8086;
import jmce.intel.i8086.OpcodeRuntime8086;
import jmce.intel.i8086.Runtime8086;
import jmce.sim.CPU;
import jmce.sim.CPUException;
import jmce.sim.CpuRuntime;
import jmce.sim.Hardware;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.cpu.AbstractCPU;
import jmce.sim.cpu.AbstractDecoder;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.StandardRegister;
import jmce.sim.memory.PlainMemory;
import jmce.util.Hex;
import jmce.util.Logger;

public class I8086
extends AbstractCPU
implements I8086Constants {
    private static Logger log = Logger.getLogger(I8086.class);
    public int F;
    public int IP;
    public int SP;
    public int BP;
    public int SI;
    public int DI;
    public int AX;
    public int BX;
    public int CX;
    public int DX;
    public int CS;
    public int DS;
    public int SS;
    public int ES;
    static final String[] regs16 = new String[]{"AX", "CX", "DX", "BX", "SP", "BP", "SI", "DI"};
    static final String[] regs8 = new String[]{"AL", "CL", "DL", "BL", "AH", "CH", "DH", "BH"};
    static final String[] sregs = new String[]{"ES", "CS", "SS", "DS"};

    public I8086() {
        super("i8086");
        this.setEndian(0);
        this.setClock(8000000L);
        this.setClockPerCycle(1);
        this.setResetAddress(1048560);
    }

    @Override
    public final void setWord(int a, int v) throws SIMException {
        this.memory.setMemory(a + 0, v & 0xFF);
        this.memory.setMemory(a + 1, v >>> 8);
    }

    @Override
    public final int getWord(int a) throws SIMException {
        return this.memory.getMemory(a + 0) | this.memory.getMemory(a + 1) << 8;
    }

    protected void initPeripherals() throws SIMException {
    }

    protected void initMemories() {
        Memory m = this.getMemoryForName("MEMORY");
        if (m == null) {
            m = (Memory)this.addHardware(new PlainMemory("MEMORY", 0x100000));
        }
        this.setMemory(m);
        for (int i = 0; i < m.getSize(); ++i) {
            m.setMemoryName(i, Hex.formatWord((i & 0xFFFF0000) >>> 4) + ":" + Hex.formatWord(i & 0xFFFF));
        }
        m = this.getMemoryForName("IO");
        if (m == null) {
            m = (Memory)this.addHardware(new PlainMemory("IO", 65536));
        }
        this.setIO(m);
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.initMemories();
        this.initPeripherals();
        this.initRegisters();
        this.initOpcodes();
        this.initOpcodeDecoder();
        super.init(parent);
    }

    protected void initOpcodeALU(int base, int time, String desc, ALUOP op) {
        this.setOpcode(new AbstractALURuntime(base + 0, 0, time, desc + "\t%eb,%rb", op){

            @Override
            public int exec(Runtime8086 r) throws SIMException {
                I8086.this.decodeModRm(r);
                I8086.this.setValue_eb(r, this.op.alu8(I8086.this.getValue_eb(r), I8086.this.getValue_rb(r.reg)));
                return this.getTimes() + r.cycle;
            }
        });
        this.setOpcode(new AbstractALURuntime(base + 1, 0, time, desc + "\t%ew,%rw", op){

            @Override
            public int exec(Runtime8086 r) throws SIMException {
                I8086.this.decodeModRm(r);
                I8086.this.setValue_ew(r, this.op.alu16(I8086.this.getValue_ew(r), I8086.this.getValue_rw(r.reg)));
                return this.getTimes() + r.cycle;
            }
        });
        this.setOpcode(new AbstractALURuntime(base + 2, 0, time, desc + "\t%rb,%eb", op){

            @Override
            public int exec(Runtime8086 r) throws SIMException {
                I8086.this.decodeModRm(r);
                I8086.this.setValue_rb(r.reg, this.op.alu8(I8086.this.getValue_eb(r), I8086.this.getValue_rb(r.reg)));
                return this.getTimes() + r.cycle;
            }
        });
        this.setOpcode(new AbstractALURuntime(base + 3, 0, time, desc + "\t%rw,%ew", op){

            @Override
            public int exec(Runtime8086 r) throws SIMException {
                I8086.this.decodeModRm(r);
                I8086.this.setValue_rw(r.reg, this.op.alu16(I8086.this.getValue_ew(r), I8086.this.getValue_rw(r.reg)));
                return this.getTimes() + r.cycle;
            }
        });
        this.setOpcode(new AbstractALU(base + 4, 2, time, desc + "\tAL,%byte", op){

            @Override
            public int exec(int pc) throws SIMException {
                I8086.this.AX = I8086.this.AX & 0xFF00 | this.op.alu8(I8086.this.AX & 0xFF, I8086.this.getByte(pc + 1));
                return this.getTimes() + 1;
            }
        });
        this.setOpcode(new AbstractALU(base + 5, 3, time, desc + "\tAX,%word", op){

            @Override
            public int exec(int pc) throws SIMException {
                I8086.this.AX = this.op.alu16(I8086.this.AX, I8086.this.getWord(pc + 1));
                return this.getTimes() + 1;
            }
        });
    }

    private final void fixFlags16(int v) {
        this.F &= 0xFFFFFF7B;
        if ((v & 0x8000) != 0) {
            this.F |= 0x80;
        }
        if ((v & 0xFFFF) == 0) {
            this.F |= 0x40;
        }
        v ^= v >> 4;
        v ^= v >> 2;
        if (((v ^= v >> 1) & 1) == 0) {
            this.F |= 4;
        }
    }

    private final void fixFlagsAdd8(int x, int v, int y) {
        this.F &= 0xFFFFF72A;
        if ((y & 0x100) != 0) {
            this.F |= 1;
        }
        if (((x ^ y ^ v) & 0x10) != 0) {
            this.F |= 0x10;
        }
        if (((x ^ ~v) & (x ^ y) & 0x80) != 0) {
            this.F |= 0x800;
        }
        if ((y & 0x80) != 0) {
            this.F |= 0x80;
        }
        if ((y & 0xFF) == 0) {
            this.F |= 0x40;
        }
        y ^= y >> 4;
        y ^= y >> 2;
        if (((y ^= y >> 1) & 1) == 0) {
            this.F |= 4;
        }
    }

    private final void fixFlagsAdd16(int x, int v, int y) {
        this.F &= 0xFFFFF72A;
        if ((y & 0x10000) != 0) {
            this.F |= 1;
        }
        if (((x ^ y ^ v) & 0x10) != 0) {
            this.F |= 0x10;
        }
        if (((x ^ ~v) & (x ^ y) & 0x8000) != 0) {
            this.F |= 0x800;
        }
        if ((y & 0x8000) != 0) {
            this.F |= 0x80;
        }
        if ((y & 0xFFFF) == 0) {
            this.F |= 0x40;
        }
        y ^= y >> 4;
        y ^= y >> 2;
        if (((y ^= y >> 1) & 1) == 0) {
            this.F |= 4;
        }
    }

    private final void fixFlags8(int v) {
        this.F &= 0xFFFFFF7B;
        if ((v & 0x80) != 0) {
            this.F |= 0x80;
        }
        if ((v & 0xFF) == 0) {
            this.F |= 0x40;
        }
        v ^= v >> 4;
        v ^= v >> 2;
        if (((v ^= v >> 1) & 1) == 0) {
            this.F |= 4;
        }
    }

    protected final int add8(int a, int b) {
        int result = a + b;
        this.fixFlagsAdd8(a, b, result);
        return result & 0xFF;
    }

    protected final int add16(int a, int b) {
        int result = a + b;
        this.fixFlagsAdd16(a, b, result);
        return result & 0xFFFF;
    }

    protected final int sub8(int a, int b) {
        int result = a - b;
        this.fixFlagsAdd8(a, b ^ 0x80, result);
        return result & 0xFF;
    }

    protected final int sub16(int a, int b) {
        int result = a - b;
        this.fixFlagsAdd16(a, b ^ 0x8000, result);
        return result & 0xFFFF;
    }

    protected final int xor8(int a, int b) {
        int result = (a ^ b) & 0xFF;
        this.F &= 0xFFFFF7FE;
        this.fixFlags8(result);
        return result;
    }

    protected final int xor16(int a, int b) {
        int result = (a ^ b) & 0xFFFF;
        this.F &= 0xFFFFF7FE;
        this.fixFlags16(result);
        return result;
    }

    protected void initOpcodes() {
        this.initOpcodeALU(40, 2, "SUB", new ALUOP(){

            @Override
            public int alu8(int op1, int op2) {
                return I8086.this.sub8(op1, op2);
            }

            @Override
            public int alu16(int op1, int op2) {
                return I8086.this.sub16(op1, op2);
            }
        });
        this.initOpcodeALU(0, 2, "ADD", new ALUOP(){

            @Override
            public int alu8(int op1, int op2) {
                return I8086.this.add8(op1, op2);
            }

            @Override
            public int alu16(int op1, int op2) {
                return I8086.this.add16(op1, op2);
            }
        });
        this.initOpcodeALU(48, 2, "XOR", new ALUOP(){

            @Override
            public int alu8(int op1, int op2) {
                return I8086.this.xor8(op1, op2);
            }

            @Override
            public int alu16(int op1, int op2) {
                return I8086.this.xor16(op1, op2);
            }
        });
        this.setOpcode(new JR(118, "JBE\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 0x41) == 65) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new JR(119, "JA\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 0x41) == 0) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new JR(116, "JZ\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 0x40) != 0) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new JR(122, "JPE\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 4) != 0) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new JR(123, "JPO\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 4) == 0) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new JR(117, "JNZ\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 0x40) == 0) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new JR(120, "JS\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 0x80) != 0) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new JR(114, "JB\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 1) != 0) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new JR(112, "JO\t%ipoffset"){

            @Override
            public int exec(int pc) throws SIMException {
                if ((I8086.this.F & 0x800) != 0) {
                    return this.jr(pc);
                }
                return this.nojmp();
            }
        });
        this.setOpcode(new AbstractOpcode(244, 1, 2, "HLT"){

            @Override
            public int exec(int pc) throws SIMException {
                I8086.this.halt();
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(250, 1, 2, "CLI"){

            @Override
            public int exec(int pc) throws SIMException {
                I8086.this.F &= 0xFFFFFDFF;
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(251, 1, 2, "STI"){

            @Override
            public int exec(int pc) throws SIMException {
                I8086.this.F |= 0x200;
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(234, 5, 11, "JMP\t%cd"){

            @Override
            public int exec(int pc) throws SIMException {
                I8086.this.pc(I8086.this.get_cd(pc + 1));
                return 11;
            }
        });
        for (int i = 0; i < 8; ++i) {
            this.setOpcode(new AbstractOpcode(184 + i, 3, 2, "MOV\t" + regs16[i] + ",%word"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8086.this.setValue_rw(this.opcode, I8086.this.getWord(pc + 1));
                    return 2;
                }
            });
        }
        this.setOpcode(new OpcodeRuntime8086(199, 2, 3, "MOV\t%ew,%-1%word"){

            @Override
            public int exec(Runtime8086 r) throws SIMException {
                I8086.this.decodeModRm(r);
                I8086.this.setValue_ew(r, I8086.this.getWord(r.pc + r.length));
                return 3 + r.cycle;
            }
        });
        this.setOpcode(new OpcodeRuntime8086(142, 0, 2, "MOV\t%sw,%ew"){

            @Override
            public int exec(Runtime8086 r) throws SIMException {
                I8086.this.decodeModRm(r);
                I8086.this.setValue_sw(r, I8086.this.getValue_ew(r));
                return 2 + r.cycle;
            }
        });
    }

    protected void setValue_sw(Runtime8086 r, int value) {
        switch (r.reg & 3) {
            case 0: {
                this.ES = value;
                break;
            }
            case 1: {
                this.CS = value;
                break;
            }
            case 2: {
                this.SS = value;
                break;
            }
            case 3: {
                this.DS = value;
            }
        }
    }

    public int getSegBase(int s) throws SIMException {
        switch (s) {
            default: {
                throw new CPUException(this, "Invalid segment " + s);
            }
            case 3: {
                return this.DS * 16;
            }
            case 2: {
                return this.SS * 16;
            }
            case 0: {
                return this.ES * 16;
            }
            case 1: 
        }
        return this.CS * 16;
    }

    public void setByte(int s, int a, int v) throws SIMException {
        int base = this.getSegBase(s);
        this.setByte(base + a, v);
        log.info("SETB " + sregs[s] + ":" + Hex.formatWord(a) + "=" + Hex.formatByte(v));
    }

    public void setWord(int s, int a, int v) throws SIMException {
        int base = this.getSegBase(s);
        this.setWord(base + a, v);
        log.info("SETW " + sregs[s] + ":" + Hex.formatWord(a) + "=" + Hex.formatWord(v));
    }

    public int getWord(int s, int a) throws SIMException {
        int base = this.getSegBase(s);
        int v = this.getWord(base + a);
        log.info("GETW " + sregs[s] + ":" + Hex.formatWord(a) + "=" + Hex.formatWord(v));
        return v;
    }

    public int getByte(int s, int a) throws SIMException {
        int base = this.getSegBase(s);
        int v = this.getByte(base + a);
        log.info("GETB " + sregs[s] + ":" + Hex.formatWord(a) + "=" + Hex.formatByte(v));
        return v;
    }

    public String get_ew(Runtime8086 r) throws SIMException {
        int length = 2;
        String left = "";
        String right = "";
        String center = "";
        int mod = r.modrm & 0xC0;
        int rm = r.modrm & 7;
        switch (mod) {
            case 0: {
                break;
            }
            case 64: {
                right = "+" + Hex.formatByte(this.getByte(r.pc + length++));
                break;
            }
            case 128: {
                left = Hex.formatWord(this.getWord(r.pc + length));
                length += 2;
                break;
            }
            case 192: {
                return regs16[rm & 7];
            }
        }
        switch (rm) {
            case 0: {
                center = "BX+SI";
                break;
            }
            case 1: {
                center = "BX+DI";
                break;
            }
            case 2: {
                center = "BP+SI";
                break;
            }
            case 3: {
                center = "BP+DI";
                break;
            }
            case 4: {
                center = "SI";
                break;
            }
            case 5: {
                center = "DI";
                break;
            }
            case 6: {
                if (mod == 0) {
                    left = Hex.formatWord(this.getWord(r.pc + length));
                    length += 2;
                    break;
                }
                center = "BP";
                break;
            }
            case 7: {
                center = "BX";
            }
        }
        return "[" + left + center + right + "]";
    }

    protected void setValue_eb(Runtime8086 r, int value) throws SIMException {
        if (r.memory) {
            this.setByte(r.defSeg, r.addr, value);
        } else {
            this.setValue_rb(r.addr, value);
        }
    }

    protected void setValue_ew(Runtime8086 r, int value) throws SIMException {
        if (r.memory) {
            this.setWord(r.defSeg, r.addr, value);
        } else {
            this.setValue_rw(r.addr, value);
        }
    }

    protected int getValue_ew(Runtime8086 r) throws SIMException {
        if (r.memory) {
            return this.getWord(r.defSeg, r.addr);
        }
        return this.getValue_rw(r.addr);
    }

    protected int getValue_eb(Runtime8086 r) throws SIMException {
        if (r.memory) {
            return this.getByte(r.defSeg, r.addr);
        }
        return this.getValue_rb(r.addr);
    }

    protected void initOpcodeDecoder() {
        this.addDecoder(new AbstractDecoder("%ipoffset", 1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                int offset = I8086.this.getByte(currentPc + 1);
                String s = Hex.formatByte(offset);
                int pc = startPc + len;
                pc = I8086.this.addOffset(pc, offset);
                s = s + " [" + Hex.formatWord(pc) + "]";
                return s;
            }
        });
        this.addDecoder(new AbstractDecoder("%ew", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                this.size = r.length;
                return I8086.this.get_ew((Runtime8086)r);
            }
        });
        this.addDecoder(new AbstractDecoder("%sw", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime _r, int startPc, int len, int currentPc) throws SIMException {
                this.size = _r.length;
                Runtime8086 r = (Runtime8086)_r;
                return sregs[r.reg & 3];
            }
        });
        this.addDecoder(new AbstractDecoder("%rw", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime _r, int startPc, int len, int currentPc) throws SIMException {
                Runtime8086 r = (Runtime8086)_r;
                return regs16[r.reg & 7];
            }
        });
        this.addDecoder(new AbstractDecoder("%cd", 4){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return Hex.formatWord(I8086.this.getWord(currentPc + 3)) + ":" + Hex.formatWord(I8086.this.getWord(currentPc + 1));
            }
        });
    }

    protected void initRegisters() {
        this.addRegister(new StandardRegister("SP", 4, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.SP;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.SP = value;
            }
        });
        this.addRegister(new StandardRegister("BP", 4, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.BP;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.BP = value;
            }
        });
        this.addRegister(new StandardRegister("IP", 1, 16, 65520){

            @Override
            public int getRegister() {
                return I8086.this.IP;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.IP = value;
            }
        });
        this.addRegister(new StandardRegister("F", 6, 16, 0){

            public void add(StringBuffer s, int mask, String d) {
                if ((I8086.this.F & mask) != 0) {
                    s.append(d);
                } else {
                    s.append('-');
                }
            }

            @Override
            public String descValue() {
                StringBuffer s = new StringBuffer("[" + Hex.formatWord(I8086.this.F) + "]");
                s.append("----");
                this.add(s, 2048, "O");
                this.add(s, 1024, "D");
                this.add(s, 512, "I");
                this.add(s, 256, "T");
                this.add(s, 128, "S");
                this.add(s, 64, "Z");
                s.append("-");
                this.add(s, 16, "A");
                s.append("-");
                this.add(s, 4, "P");
                s.append("-");
                this.add(s, 1, "C");
                return s.toString();
            }

            @Override
            public int getRegister() {
                return I8086.this.F;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.F = value;
            }
        });
        this.addRegister(new StandardRegister("AX", 2, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.AX;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.AX = value;
            }
        });
        this.addRegister(new StandardRegister("BX", 10, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.BX;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.BX = value;
            }
        });
        this.addRegister(new StandardRegister("CX", 10, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.CX;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.CX = value;
            }
        });
        this.addRegister(new StandardRegister("DX", 10, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.DX;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.DX = value;
            }
        });
        this.addRegister(new StandardRegister("SI", 3, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.SI;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.SI = value;
            }
        });
        this.addRegister(new StandardRegister("DI", 3, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.DI;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.DI = value;
            }
        });
        this.addRegister(new StandardRegister("CS", 5, 16, 61440){

            @Override
            public int getRegister() {
                return I8086.this.CS;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.CS = value;
            }
        });
        this.addRegister(new StandardRegister("DS", 5, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.DS;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.DS = value;
            }
        });
        this.addRegister(new StandardRegister("ES", 5, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.ES;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.ES = value;
            }
        });
        this.addRegister(new StandardRegister("SS", 5, 16, 0){

            @Override
            public int getRegister() {
                return I8086.this.SS;
            }

            @Override
            public void setRegister(int value) {
                I8086.this.SS = value;
            }
        });
    }

    @Override
    public boolean isInterruptEnabled() {
        return (this.F & 0x200) != 0;
    }

    @Override
    public final void pc(int pc) {
        this.IP = pc & 0xFFFF;
        this.CS = (pc & 0xFFFF0000) >> 4;
    }

    @Override
    public int pc() {
        return this.CS << 4 | this.IP;
    }

    void decodeModRm(Runtime8086 r) throws SIMException {
        r.length = 2;
        r.modrm = this.getByte(r.pc + 1);
        r.memory = true;
        int mod = r.modrm & 0xC0;
        int rm = r.modrm & 7;
        r.reg = (r.modrm & 0x38) >> 3;
        switch (mod) {
            case 0: {
                r.addr = 0;
                break;
            }
            case 64: {
                r.addr = this.addOffset(0, this.getByte(r.pc + r.length++));
                r.cycle += 4;
                break;
            }
            case 128: {
                r.addr = this.getWord(r.pc + r.length);
                r.length += 2;
                r.cycle += 4;
                break;
            }
            case 192: {
                r.memory = false;
                r.addr = rm;
                return;
            }
        }
        r.defSeg = 3;
        switch (rm) {
            case 0: {
                r.addr += this.BX + this.SI;
                r.cycle += 7;
                break;
            }
            case 1: {
                r.addr += this.BX + this.DI;
                r.cycle += 8;
                break;
            }
            case 2: {
                r.addr += this.BP + this.SI;
                r.defSeg = 2;
                r.cycle += 8;
                break;
            }
            case 3: {
                r.addr += this.BP + this.DI;
                r.defSeg = 2;
                r.cycle += 7;
                break;
            }
            case 4: {
                r.addr += this.SI;
                r.cycle += 5;
                break;
            }
            case 5: {
                r.addr += this.DI;
                r.cycle += 5;
                break;
            }
            case 6: {
                if (mod == 0) {
                    r.addr = this.getWord(r.pc + r.length);
                    r.length += 2;
                    r.cycle += 6;
                    break;
                }
                r.addr += this.BP;
                r.defSeg = 2;
                r.cycle += 5;
                break;
            }
            case 7: {
                r.addr += this.BX;
                r.cycle += 5;
            }
        }
        r.addr &= 0xFFFF;
    }

    public int getValue_rb(int r) {
        switch (r & 7) {
            case 0: {
                return this.AX & 0xFF;
            }
            case 1: {
                return this.CX & 0xFF;
            }
            case 2: {
                return this.DX & 0xFF;
            }
            case 3: {
                return this.BX & 0xFF;
            }
            case 4: {
                return this.AX >>> 8;
            }
            case 5: {
                return this.CX >>> 8;
            }
            case 6: {
                return this.DX >>> 8;
            }
            case 7: {
                return this.BX >>> 8;
            }
        }
        return -1;
    }

    public int getValue_rw(int opcode) {
        switch (opcode & 7) {
            case 0: {
                return this.AX;
            }
            case 1: {
                return this.CX;
            }
            case 2: {
                return this.DX;
            }
            case 3: {
                return this.BX;
            }
            case 4: {
                return this.SP;
            }
            case 5: {
                return this.BP;
            }
            case 6: {
                return this.SI;
            }
            case 7: {
                return this.DI;
            }
        }
        return -1;
    }

    public void setValue_rb(int r, int v) {
        v &= 0xFF;
        switch (r & 7) {
            case 0: {
                this.AX = this.AX & 0xFF00 | v;
                break;
            }
            case 1: {
                this.CX = this.CX & 0xFF00 | v;
                break;
            }
            case 2: {
                this.DX = this.DX & 0xFF00 | v;
                break;
            }
            case 3: {
                this.BX = this.BX & 0xFF00 | v;
                break;
            }
            case 4: {
                this.AX = this.AX & 0xFF | v << 8;
                break;
            }
            case 5: {
                this.CX = this.CX & 0xFF | v << 8;
                break;
            }
            case 6: {
                this.DX = this.DX & 0xFF | v << 8;
                break;
            }
            case 7: {
                this.BX = this.BX & 0xFF | v << 8;
            }
        }
    }

    public void setValue_rw(int r, int value) {
        switch (r & 7) {
            case 0: {
                log.info("SET AX=" + Hex.formatWord(value));
                this.AX = value;
                break;
            }
            case 1: {
                this.CX = value;
                break;
            }
            case 2: {
                this.DX = value;
                break;
            }
            case 3: {
                this.BX = value;
                break;
            }
            case 4: {
                this.SP = value;
                break;
            }
            case 5: {
                this.BP = value;
                break;
            }
            case 6: {
                this.SI = value;
                break;
            }
            case 7: {
                this.DI = value;
            }
        }
    }

    public int get_cd(int pc) throws SIMException {
        int ea = this.getWord(pc + 0) + this.getWord(pc + 2) * 16;
        return ea;
    }

    @Override
    protected Runtime8086 createRuntime() throws SIMException {
        return new Runtime8086();
    }

    abstract class JR
    extends AbstractOpcode {
        JR(int opcode, String s) {
            super(opcode, 2, 3, s);
        }

        protected final int jr(int pc) throws SIMException {
            int offset = I8086.this.getByte(pc + 1);
            I8086.this.IP = I8086.this.addOffset(I8086.this.IP, offset);
            return 7;
        }

        protected final int nojmp() {
            return 2;
        }
    }

    class REPE
    extends OpcodePrefix8086 {
        REPE() {
            super(242, 1, 0, "REPE");
        }

        @Override
        public int exec(Runtime8086 r) throws SIMException {
            r.rep = 0;
            ++r.cycle;
            return 1;
        }
    }

    class REPNE
    extends OpcodePrefix8086 {
        REPNE() {
            super(242, 1, 0, "REPNE");
        }

        @Override
        public int exec(Runtime8086 r) throws SIMException {
            r.rep = 1;
            ++r.cycle;
            return 1;
        }
    }

    abstract class AbstractALU
    extends AbstractOpcode {
        ALUOP op;

        AbstractALU(int o, int l, int t, String d, ALUOP op) {
            super(o, l, t, d);
            this.op = op;
        }
    }

    abstract class AbstractALURuntime
    extends OpcodeRuntime8086 {
        ALUOP op;

        AbstractALURuntime(int o, int l, int t, String d, ALUOP op) {
            super(o, l, t, d);
            this.op = op;
        }
    }

    static interface ALUOP {
        public int alu8(int var1, int var2);

        public int alu16(int var1, int var2);
    }
}

