/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.mcs51;

import jmce.intel.mcs51.Interrupt8051;
import jmce.intel.mcs51.MCS51;
import jmce.intel.mcs51.MCS51Constants;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.CycleListener;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;

public class Timer
extends AbstractPeripheral
implements CycleListener {
    private MCS51 mcs51;
    private SingleTimer timer0 = new SingleTimer(0);
    private SingleTimer timer1 = new SingleTimer(1);

    public Timer() {
        this.setName("Timer0/1");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addCycleListener(this);
        this.mcs51 = (MCS51)cpu;
        this.timer0.registerCPU(this.mcs51);
        this.timer1.registerCPU(this.mcs51);
    }

    @Override
    public final void cycle(int n) throws SIMException {
        this.timer0.cycle(n);
        this.timer1.cycle(n);
    }

    class SingleTimer
    implements MCS51Constants {
        private int tconShift;
        private int tmodShift;
        private int TH;
        private int TL;
        private int TF;
        private int ET;
        private int timer;
        private int tcon;
        private int tmod;
        private Interrupt8051 irq;

        SingleTimer(int timer2) {
            this.tconShift = 2 * timer2;
            this.tmodShift = 4 * timer2;
            this.TH = 140 + timer2;
            this.TL = 138 + timer2;
            this.TF = 32 << this.tconShift;
            this.ET = timer2 == 0 ? 2 : 8;
            this.timer = timer2;
        }

        void registerCPU(MCS51 cpu) throws SIMException {
            this.irq = new Interrupt8051(cpu, "Timer" + this.timer, 11 + this.timer * 16){

                @Override
                public void startISR() throws SIMException {
                    Timer.this.mcs51.sfrReset(136, SingleTimer.this.TF);
                    super.startISR();
                }
            };
            this.irq.addInterruptCondition(168, this.ET);
            this.irq.addInterruptCondition(136, this.TF);
            cpu.addIOWriteListener(136, new MemoryWriteListener(){

                @Override
                public void writeMemory(Memory m, int r, int v, int oldValue) {
                    SingleTimer.this.tcon = v >> SingleTimer.this.tconShift;
                }
            });
            cpu.addIOWriteListener(137, new MemoryWriteListener(){

                @Override
                public void writeMemory(Memory m, int r, int v, int oldValue) {
                    SingleTimer.this.tmod = v >> SingleTimer.this.tmodShift;
                }
            });
            cpu.addIOReadListener(140 + this.timer, new MemoryReadListener(){

                @Override
                public int readMemory(Memory m, int r, int v) {
                    return SingleTimer.this.TH;
                }
            });
            cpu.addIOWriteListener(140 + this.timer, new MemoryWriteListener(){

                @Override
                public void writeMemory(Memory m, int r, int v, int oldValue) {
                    SingleTimer.this.TH = v;
                }
            });
            cpu.addIOReadListener(138 + this.timer, new MemoryReadListener(){

                @Override
                public int readMemory(Memory m, int r, int v) {
                    return SingleTimer.this.TL;
                }
            });
            cpu.addIOWriteListener(138 + this.timer, new MemoryWriteListener(){

                @Override
                public void writeMemory(Memory m, int r, int v, int oldValue) {
                    SingleTimer.this.TL = v;
                }
            });
        }

        final void cycle(int n) throws SIMException {
            if ((this.tcon & 0x10) == 0) {
                return;
            }
            switch (this.tmod & 3) {
                case 0: {
                    int tl = this.TL + n;
                    this.TL = tl & 0x1F;
                    if (tl <= 31) break;
                    this.TH = this.TH + 1 & 0xFF;
                    if (this.TH != 0) break;
                    Timer.this.mcs51.sfrSet(136, this.TF);
                    break;
                }
                case 1: {
                    int tl = this.TL + n;
                    this.TL = tl & 0xFF;
                    if (tl <= 255) break;
                    this.TH = this.TH + 1 & 0xFF;
                    if (this.TH != 0) break;
                    Timer.this.mcs51.sfrSet(136, this.TF);
                    break;
                }
                case 2: {
                    int tl = this.TL;
                    while (n-- > 0) {
                        if ((tl = tl + 1 & 0xFF) != 0) continue;
                        tl = this.TL = this.TH;
                        Timer.this.mcs51.sfrSet(136, this.TF);
                    }
                    this.TL = tl;
                }
            }
        }
    }
}

