/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.mcs51;

import jmce.intel.mcs51.Interrupt8051;
import jmce.intel.mcs51.MCS52;
import jmce.intel.mcs51.MCS52Constants;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.CycleListener;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;

public class Timer2
extends AbstractPeripheral
implements CycleListener,
MCS52Constants {
    private Interrupt8051 irq;
    private MCS52 mcs52;
    private int t2 = 0;

    public Timer2() {
        this.setName("Timer2");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        this.mcs52 = (MCS52)cpu;
        this.irq = new Interrupt8051(this.mcs52, "Timer2", 43){

            @Override
            public void startISR() throws SIMException {
                Timer2.this.mcs52.sfrReset(200, 128);
                super.startISR();
            }
        };
        this.irq.addInterruptCondition(168, 32);
        this.irq.addInterruptCondition(200, 128);
        this.mcs52.addIOReadListener(204, new MemoryReadListener(){

            @Override
            public int readMemory(Memory memory, int address, int value) {
                return Timer2.this.t2 & 0xFF;
            }
        });
        this.mcs52.addIOReadListener(205, new MemoryReadListener(){

            @Override
            public int readMemory(Memory memory, int address, int value) {
                return Timer2.this.t2 >>> 8 & 0xFF;
            }
        });
        this.mcs52.addIOWriteListener(204, new MemoryWriteListener(){

            @Override
            public void writeMemory(Memory memory, int address, int value, int oldValue) {
                Timer2.this.t2 = Timer2.this.t2 & 0xFF00 | value;
            }
        });
        this.mcs52.addIOWriteListener(205, new MemoryWriteListener(){

            @Override
            public void writeMemory(Memory memory, int address, int value, int oldValue) {
                Timer2.this.t2 = Timer2.this.t2 & 0xFF | value << 8;
            }
        });
        this.mcs52.addCycleListener(this);
    }

    @Override
    public final void cycle(int n) throws SIMException {
        if (!this.mcs52.sfrIsBit(200, 4)) {
            return;
        }
        this.t2 += n;
        if (this.t2 > 65535) {
            this.mcs52.sfrSetBit(200, 128);
            if (!this.mcs52.sfrIsBit(200, 1)) {
                this.t2 = this.mcs52.sfr(203) * 256 + this.mcs52.sfr(202);
            }
        }
    }
}

