/*
 * Decompiled with CFR 0.152.
 */
package jmce.mos;

import jmce.mos.IRQ6502;
import jmce.mos.M6502;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.CycleListener;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.util.FastArray;
import jmce.util.Hex;
import jmce.util.Logger;

public class VIA6522
extends AbstractPeripheral
implements MemoryWriteListener,
MemoryReadListener,
CycleListener {
    private static Logger log = Logger.getLogger(VIA6522.class);
    private int base = 0;
    public static final int PBR = 0;
    public static final int PAR = 1;
    public static final int PBD = 2;
    public static final int PAD = 3;
    public static final int IFR = 13;
    public static final int IER = 14;
    public static final int IER_CONTROL = 128;
    public static final int IER_TIMER1 = 64;
    public static final int IER_TIMER2 = 32;
    public static final int IER_CB1 = 16;
    public static final int IER_CB2 = 8;
    public static final int IER_SHIFT = 4;
    public static final int IER_CA1 = 2;
    public static final int IER_CA2 = 1;
    public static final int ACR = 11;
    public static final int PCR = 12;
    public static final int T1CL = 4;
    public static final int T1CH = 5;
    public static final int T1LL = 6;
    public static final int T1LH = 7;
    public static final int T2L = 8;
    public static final int T2H = 9;
    public static final int PARA = 15;
    private IRQ6502 irqTimer1;
    private IRQ6502 irqTimer2;
    private int ier = 0;
    private int acr = 0;
    private int pcr = 0;
    private int timer1Counter = 0;
    private int timer1Latch = 0;
    private int timer2Counter = 0;
    private int timer2Latch = 0;
    private boolean timer1Interrupt = false;
    private boolean timer2Interrupt = false;
    private Port6522 pa = null;
    private Port6522 pb = null;

    public VIA6522() throws SIMException {
        this("VIA6522", 0);
    }

    public VIA6522(String name, int base) throws SIMException {
        this.setName(name);
        this.setBase(base);
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.ier = 0;
        this.timer1Interrupt = false;
        this.updateIrqs();
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        this.irqTimer1 = new IRQ6502((M6502)cpu, this.getName() + "/Timer1");
        this.irqTimer2 = new IRQ6502((M6502)cpu, this.getName() + "/Timer2");
        this.pa = new Port6522('A', 0);
        this.pb = new Port6522('B', 4);
        for (int i = 0; i < 16; ++i) {
            cpu.addIOWriteListener(this.base + i, this);
            cpu.addIOReadListener(this.base + i, this);
        }
        cpu.addCycleListener(this);
    }

    private void startTimer2() {
        this.timer2Interrupt = true;
        this.timer2Counter = this.timer2Latch;
    }

    private void startTimer1() {
        this.timer1Interrupt = true;
        this.timer1Counter = this.timer1Latch;
    }

    @Override
    public void cycle(int n) throws SIMException {
        this.pa.cycle(n);
        this.pb.cycle(n);
        while (n > 0) {
            this.timer1Counter = this.timer1Counter - 1 & 0xFFFF;
            if (this.timer1Counter == 0) {
                if (this.timer1Interrupt) {
                    this.irqTimer1.setActive(true);
                }
                if ((this.acr & 0x40) != 0) {
                    this.timer1Counter = this.timer1Latch;
                } else {
                    this.timer1Interrupt = false;
                }
            }
            this.timer2Counter = this.timer2Counter - 1 & 0xFFFF;
            if (this.timer2Counter == 0 && this.timer2Interrupt) {
                this.irqTimer2.setActive(true);
                this.timer2Interrupt = false;
            }
            --n;
        }
    }

    @Override
    public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
        switch (address &= 0xF) {
            case 3: {
                this.pa.setDir(value);
                break;
            }
            case 2: {
                this.pb.setDir(value);
                break;
            }
            case 13: {
                log.info(this + " IFR=" + Hex.formatByte(value));
                System.exit(1);
                break;
            }
            case 15: {
                this.pa.setOutput(value);
                log.info(this + " PARA=" + Hex.formatByte(value));
                break;
            }
            case 1: {
                this.pa.write(value);
                break;
            }
            case 0: {
                this.pb.write(value);
                break;
            }
            case 12: {
                this.pcr(value);
                break;
            }
            case 4: 
            case 6: {
                this.timer1Latch &= 0xFF00;
                this.timer1Latch |= value;
                break;
            }
            case 7: {
                this.timer1Latch &= 0xFF;
                this.timer1Latch |= value << 8;
                this.irqTimer1.setActive(false);
                break;
            }
            case 5: {
                this.timer1Latch &= 0xFF;
                this.timer1Latch |= value << 8;
                this.irqTimer1.setActive(false);
                this.startTimer1();
                break;
            }
            case 8: {
                this.timer2Latch &= 0xFF00;
                this.timer2Latch |= value;
                break;
            }
            case 9: {
                this.timer2Latch &= 0xFF;
                this.timer2Latch |= value << 8;
                this.irqTimer2.setActive(false);
                this.startTimer2();
                break;
            }
            case 11: {
                this.acr = value;
                break;
            }
            case 14: {
                this.ier(value);
            }
        }
    }

    @Override
    public int readMemory(Memory memory, int address, int value) throws SIMException {
        switch (address &= 0xF) {
            case 2: {
                value = this.pb.getDir();
                break;
            }
            case 3: {
                value = this.pa.getDir();
                break;
            }
            case 0: {
                value = this.pb.read();
                break;
            }
            case 1: {
                value = this.pa.read();
                break;
            }
            case 13: {
                value = 0;
                if (this.irqTimer1.isActive()) {
                    value |= 0x40;
                }
                if (this.irqTimer2.isActive()) {
                    value |= 0x20;
                }
                if (this.pa.irq1()) {
                    value |= 2;
                }
                if (this.pa.irq2()) {
                    value |= 1;
                }
                if (this.pb.irq1()) {
                    value |= 0x10;
                }
                if (this.pb.irq2()) {
                    value |= 8;
                }
                if ((value & this.ier) == 0) break;
                value |= 0x80;
                break;
            }
            case 8: {
                this.irqTimer2.setActive(false);
                value = this.timer2Counter;
                break;
            }
            case 9: {
                value = this.timer2Counter >>> 8;
                break;
            }
            case 4: {
                this.irqTimer1.setActive(false);
                value = this.timer1Counter;
                break;
            }
            case 5: {
                value = this.timer1Counter >>> 8;
                break;
            }
            case 6: {
                value = this.timer1Latch & 0xFF;
                break;
            }
            case 7: {
                value = this.timer1Latch >>> 8;
                break;
            }
            case 11: {
                value = this.acr;
                break;
            }
            case 14: {
                value = this.ier | 0x80;
                break;
            }
            case 15: {
                value = this.pa.getPort();
            }
        }
        return value &= 0xFF;
    }

    private void pcr(int value) throws SIMException {
        this.pcr = value;
        this.pa.pcr(value);
        this.pb.pcr(value);
    }

    private void ier(int value) throws SIMException {
        this.ier = (value & 0x80) == 0 ? (this.ier &= ~(value & 0x7F)) : (this.ier |= value & 0x7F);
        this.updateIrqs();
    }

    private void updateIrqs() throws SIMException {
        this.irqTimer1.setEnabled((this.ier & 0x40) != 0);
        this.irqTimer2.setEnabled((this.ier & 0x20) != 0);
        this.pa.updateIrqs();
        this.pb.updateIrqs();
    }

    public void writePortA(int a) throws SIMException {
        this.pa.setInput(a);
    }

    public int readPortA() throws SIMException {
        return this.pa.getPort();
    }

    public void writePortB(int b) throws SIMException {
        this.pb.setInput(b);
    }

    public int readPortB() throws SIMException {
        return this.pb.getPort();
    }

    public void addPortAWriteListener(MemoryWriteListener l) {
        this.cpu.addIOWriteListener(this.base + 1, l);
    }

    public void addPortBWriteListener(MemoryWriteListener l) {
        this.cpu.addIOWriteListener(this.base + 0, l);
    }

    public boolean readCB2() {
        return this.pb.getC2();
    }

    public void writeCB2(boolean mode) throws SIMException {
        this.pb.setC2(mode);
    }

    public boolean readCA1() {
        return this.pa.getC1();
    }

    public void writeCA1(boolean mode) throws SIMException {
        this.pa.setC1(mode);
    }

    public void addCA2MemoryWriteListener(MemoryWriteListener l) {
        this.pa.addC2MemoryWriteListener(l);
    }

    public boolean readCA2() {
        return this.pa.getC2();
    }

    public void writeCA2(boolean mode) throws SIMException {
        this.pa.setC2(mode);
    }

    public boolean readCB1() {
        return this.pb.getC1();
    }

    public void writeCB1(boolean mode) throws SIMException {
        this.pb.setC1(mode);
    }

    public int getTimer2Counter() {
        return this.timer2Counter;
    }

    @Override
    public String toString() {
        return this.getName() + " at 0x" + Hex.formatWord(this.base);
    }

    class Port6522 {
        private FastArray<MemoryWriteListener> mwl2 = new FastArray();
        private boolean c1 = false;
        private boolean c2 = false;
        private boolean autoSetC2;
        private IRQ6502 irq1;
        private IRQ6502 irq2;
        private int shift;
        private int dir;
        private int in;
        private int out;
        char portName;

        Port6522(char name, int shift) throws SIMException {
            this.irq1 = new IRQ6502((M6502)VIA6522.this.cpu, VIA6522.this.getName() + "/C" + name + "1");
            this.irq2 = new IRQ6502((M6502)VIA6522.this.cpu, VIA6522.this.getName() + "/C" + name + "2");
            this.shift = shift;
            this.portName = name;
        }

        public void setDir(int dir) {
            this.dir = dir;
        }

        public int getDir() {
            return this.dir;
        }

        public int getPort() {
            return (this.in & ~this.dir | this.out & this.dir) & 0xFF;
        }

        public void setOutput(int n) {
            this.out = n;
        }

        public void setInput(int n) {
            this.in = n;
        }

        public void updateIrqs() throws SIMException {
            if (this.shift == 0) {
                this.irq1.setEnabled((VIA6522.this.ier & 2) != 0);
                this.irq2.setEnabled((VIA6522.this.ier & 1) != 0);
            } else {
                this.irq1.setEnabled((VIA6522.this.ier & 0x10) != 0);
                this.irq2.setEnabled((VIA6522.this.ier & 8) != 0);
            }
        }

        public void pcr(int value) throws SIMException {
            int i = value >>> 1 + this.shift & 7;
            switch (i) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.irq2.setEnabled(true);
                    break;
                }
                default: {
                    this.irq2.setEnabled(false);
                    if (i == 6) {
                        this.setC2(false);
                    }
                    if (i != 7) break;
                    this.setC2(true);
                }
            }
        }

        void resetIfC2() throws SIMException {
            int i = VIA6522.this.pcr >>> 1 + this.shift & 7;
            if (i != 1 && i != 3) {
                this.irq2.setActive(false);
            }
        }

        public int read() throws SIMException {
            this.irq1.setActive(false);
            this.resetIfC2();
            return this.getPort();
        }

        public void write(int n) throws SIMException {
            int i = VIA6522.this.pcr >>> 1 + this.shift & 7;
            this.setOutput(n);
            this.irq1.setActive(false);
            this.resetIfC2();
            if (i == 4) {
                this.setC2(false);
            }
            if (i == 5) {
                this.setC2(false);
                this.autoSetC2 = true;
            }
        }

        public void cycle(int n) throws SIMException {
            if (this.autoSetC2) {
                this.autoSetC2 = false;
                this.setC2(true);
            }
        }

        public boolean irq1() throws SIMException {
            return this.irq1.isActive();
        }

        public boolean irq2() throws SIMException {
            return this.irq2.isActive();
        }

        public void setC1(boolean mode) throws SIMException {
            boolean cbctrl;
            int i = VIA6522.this.pcr >>> 1 + this.shift & 7;
            boolean bl = cbctrl = (VIA6522.this.pcr & 1 << this.shift) != 0;
            if (this.c1 != mode) {
                if (i == 4) {
                    this.setC2(true);
                }
                if (cbctrl == mode) {
                    this.irq1.setActive(true);
                }
                this.c1 = mode;
            }
        }

        public boolean getC2() {
            return this.c2;
        }

        public boolean getC1() {
            return this.c1;
        }

        void addC2MemoryWriteListener(MemoryWriteListener l) {
            this.mwl2.add(l);
        }

        public void setC2(boolean mode) throws SIMException {
            int i = this.mwl2.getSize();
            while (--i >= 0) {
                this.mwl2.get(i).writeMemory(null, 2, mode ? 1 : 0, this.c2 ? 1 : 0);
            }
            i = VIA6522.this.pcr >>> 1 + this.shift & 7;
            if (mode != this.c2) {
                switch (i) {
                    case 0: 
                    case 1: {
                        if (!this.c2 || mode) break;
                        this.irq2.setActive(true);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (this.c2 || !mode) break;
                        this.irq2.setActive(true);
                    }
                }
                this.c2 = mode;
            }
        }
    }
}

