/*
 * Decompiled with CFR 0.152.
 */
package jmce.philips;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import jmce.philips.Saa5050FontGraphics;
import jmce.philips.Saa5050FontGraphics2;
import jmce.philips.Saa5050FontNormal;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.SwingHardware;
import jmce.util.Timer;
import jmce.util.TimerListener;

public class SAA5050
extends AbstractPeripheral
implements SwingHardware,
MemoryWriteListener {
    public static final Color[] colors = new Color[]{Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white};
    private DisplaySAA5050 dsp;
    private Memory m = null;
    private int base = 0;
    private int scroll = 0;
    private boolean doBlink;
    private static final int dotSize = 2;
    private static final int numCols = 40;
    private static final int numRows = 24;
    private static final int sizeRow = 80;

    public SAA5050() {
        this.setName("SAA5050");
        this.dsp = new DisplaySAA5050();
    }

    public void setMemory(Memory m) {
        this.m = m;
    }

    public void setAddress(int a) {
        this.base = a;
    }

    @Override
    public Component getComponent() {
        return this.dsp;
    }

    public int getScroll() {
        return this.scroll;
    }

    public void setScroll(int scroll) {
        this.scroll = scroll;
        this.dsp.repaint();
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        for (int i = 0; i < 2048; ++i) {
            this.m.addMemoryWriteListener(this.base + i, this);
        }
        Timer timer = new Timer(500, true, new TimerListener(){

            @Override
            public void timerExpired() {
                SAA5050.this.doBlink = !SAA5050.this.doBlink;
                SAA5050.this.dsp.repaint();
            }
        });
        cpu.addTimerMs(timer);
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.dsp.repaint();
    }

    class DisplaySAA5050
    extends JComponent {
        private static final long serialVersionUID = 1L;
        Color fa = colors[6];
        Color fg = colors[6];
        Color bg = Color.black;
        int[] fontGraphics;
        int[] fontAlpha;
        int lastCode = 32;
        boolean graphics = false;
        boolean doubleHeight = false;
        private boolean[] skip = new boolean[256];
        private boolean blink;

        DisplaySAA5050() {
            this.setPreferredSize(new Dimension(480, 480));
        }

        public void updateComponent() {
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Insets insets = this.getInsets();
            g.translate(insets.left, insets.top);
            int pos = SAA5050.this.scroll;
            this.fa = this.fg = colors[6];
            this.fontAlpha = Saa5050FontNormal.font;
            this.fontGraphics = Saa5050FontGraphics.font;
            this.lastCode = 32;
            this.graphics = false;
            this.doubleHeight = false;
            this.bg = Color.black;
            this.blink = false;
            for (int r = 0; r < 24; ++r) {
                this.doubleHeight = false;
                for (int c = 0; c < 40; ++c) {
                    try {
                        if (!this.skip[c]) {
                            this.teletext(g, c, r, SAA5050.this.m.getMemory(SAA5050.this.base + pos + c));
                            this.skip[c] = this.doubleHeight;
                            continue;
                        }
                        this.skip[c] = false;
                        continue;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                pos += 80;
            }
        }

        void teletext(Graphics g, int c, int r, int code) {
            switch (code) {
                case 8: {
                    this.blink = SAA5050.this.doBlink;
                    break;
                }
                case 9: {
                    this.blink = false;
                    break;
                }
                case 12: {
                    this.doubleHeight = false;
                    break;
                }
                case 13: {
                    this.doubleHeight = true;
                    break;
                }
                case 0: 
                case 10: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.fa = colors[code - 1];
                    this.graphics = false;
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    this.fg = colors[code - 17];
                    this.graphics = true;
                    break;
                }
                case 25: {
                    this.fontGraphics = Saa5050FontGraphics.font;
                    break;
                }
                case 26: {
                    this.fontGraphics = Saa5050FontGraphics2.font;
                    break;
                }
                case 28: {
                    this.bg = Color.black;
                    break;
                }
                case 29: {
                    Color color = this.bg = this.graphics ? this.fg : this.fa;
                }
            }
            if (code < 32) {
                code = 32;
            }
            this.lastCode = code;
            if (this.graphics) {
                this.paintChar(g, c, r, code, this.fg, this.bg, this.fontGraphics);
            } else {
                this.paintChar(g, c, r, code, this.fa, this.bg, this.fontAlpha);
            }
        }

        void drawLine(Graphics g, int x, int y, Color fg, Color bg, int[] font, int pos) {
            for (int x1 = 0; x1 < 6; ++x1) {
                if (font[pos] == 0) {
                    g.setColor(bg);
                } else {
                    g.setColor(fg);
                }
                g.fillRect(x, y, 2, 2);
                x += 2;
                ++pos;
            }
        }

        void paintChar(Graphics g, int c, int r, int code, Color fg, Color bg, int[] font) {
            Color tmp;
            int y = r * 10 * 2;
            int pos = (code - 32) * 60;
            if ((code & 0x80) != 0) {
                tmp = fg;
                fg = bg;
                bg = tmp;
                code &= 0x7F;
            }
            if (this.blink) {
                tmp = fg;
                fg = bg;
                bg = tmp;
            }
            for (int y1 = 0; y1 < 10; ++y1) {
                int x = c * 6 * 2;
                this.drawLine(g, x, y, fg, bg, font, pos);
                if (this.doubleHeight) {
                    this.drawLine(g, x, y += 2, fg, bg, font, pos);
                }
                y += 2;
                pos += 6;
            }
        }
    }
}

