/*
 * Decompiled with CFR 0.152.
 */
package jmce.philips.p2000;

import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.swing.KeyboardMatrix;
import jmce.zilog.z80.CTC;

class Keyboard
extends KeyboardMatrix
implements MemoryReadListener,
MemoryWriteListener {
    int outputRegister = 0;
    CTC ctc = null;

    public Keyboard() {
        this.setNumRows(10);
        this.setNumCols(8);
        this.setKey(0, 0, 37, 54, 38, 81, 51, 53, 55, 52);
        this.setKey(1, 0, 9, 72, 90, 83, 68, 71, 74, 70);
        this.setKey(2, 0, 110, 32, -1, -1, -1, 40, 44, 39);
        this.setKey(3, 0, 17, 78, 60, 88, 67, 66, 77, 86);
        this.setKey(4, 0, 112, 89, 65, 87, 69, 84, 85, 82);
        this.setKey(5, 0, -1, 57, 107, 109, 8, 48, 49, 45);
        this.setKey(6, 0, 105, 79, 104, 103, 10, 80, 56, 64);
        this.setKey(7, 0, 99, 46, 98, 97, -1, 47, 75, 50);
        this.setKey(8, 0, 102, 76, 101, 100, -1, 59, 73, 58);
        this.setKey(9, 0, 16);
        this.setKey(9, 7, 16);
        this.setKeyLocation(9, 0, 2);
        this.setKeyLocation(9, 7, 3);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        int i;
        super.registerCPU(cpu);
        for (i = 0; i <= 31; ++i) {
            cpu.addIOReadListener(i, this);
        }
        for (i = 16; i <= 31; ++i) {
            cpu.addIOWriteListener(i, this);
        }
    }

    @Override
    public int readMemory(Memory memory, int address, int value) throws SIMException {
        if ((this.outputRegister & 0x40) != 0) {
            value = 255;
            for (int i = 0; i < 10; ++i) {
                value &= this.getRow(i);
            }
        } else {
            value = address > 9 ? 255 : this.getRow(address);
        }
        return value;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.outputRegister = value;
    }

    @Override
    protected void keyEvent(int r, int c, boolean pressed) {
        super.keyEvent(r, c, pressed);
        if ((this.outputRegister & 0x40) != 0) {
            try {
                this.ctc.count(3, 1);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public void setCtc(CTC ctc) {
        this.ctc = ctc;
    }
}

