/*
 * Decompiled with CFR 0.152.
 */
package jmce.philips.p2000;

import jmce.philips.SAA5050;
import jmce.philips.p2000.Keyboard;
import jmce.sim.Loadable;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.audio.Speaker;
import jmce.sim.memory.PlainMemory;
import jmce.zilog.z80.CTC;
import jmce.zilog.z80.Z80;

public class P2000T
extends Z80 {
    private SAA5050 sa;
    private CTC ctc;
    private Speaker spk;

    public P2000T() {
        this.setName("P2000T");
        this.setClock(2500000L);
        this.setRealTime(true);
    }

    @Override
    protected void initMemories() {
        if (this.getMemoryForName("MEMORY") == null) {
            PlainMemory m = new PlainMemory("MEMORY", 65536);
            m.setReadOnly(0, 4096);
            m.setReadOnly(22528, 2048);
            this.addHardware(m);
            Loadable load = new Loadable("p2000/basic.bin", 4096);
            this.addHardware(load);
            load = new Loadable("p2000/p2000rom.bin", 0);
            this.addHardware(load);
        }
        super.initMemories();
    }

    @Override
    protected void initPeripherals() throws SIMException {
        this.ctc = (CTC)this.getHardware((Class)CTC.class);
        if (this.ctc == null) {
            this.ctc = new CTC();
            this.ctc.setBase(136);
            this.addHardware(this.ctc);
        }
        this.sa = (SAA5050)this.getHardware((Class)SAA5050.class);
        if (this.sa == null) {
            this.sa = new SAA5050();
            this.addHardware(this.sa);
        }
        for (int i = 48; i <= 63; ++i) {
            this.addIOWriteListener(i, new MemoryWriteListener(){

                @Override
                public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
                    P2000T.this.sa.setScroll(value);
                }
            });
            this.addIOReadListener(i, new MemoryReadListener(){

                @Override
                public int readMemory(Memory memory, int address, int value) throws SIMException {
                    return P2000T.this.sa.getScroll();
                }
            });
        }
        this.sa.setMemory(this.getMemoryForName("MEMORY"));
        this.sa.setAddress(20480);
        Keyboard k = (Keyboard)this.getHardware((Class)Keyboard.class);
        if (k == null) {
            k = new Keyboard();
            this.addHardware(k);
        }
        k.setCtc(this.ctc);
        k.setComponent(this.sa.getComponent());
        this.spk = (Speaker)this.getHardware((Class)Speaker.class);
        if (this.spk == null) {
            this.spk = new Speaker();
            this.addHardware(this.spk);
        }
        for (int i = 80; i <= 95; ++i) {
            this.addIOWriteListener(i, new MemoryWriteListener(){

                @Override
                public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
                    if ((value & 1) != 0) {
                        P2000T.this.spk.setFreq(440);
                    } else {
                        P2000T.this.spk.setFreq(0);
                    }
                }
            });
        }
        super.initPeripherals();
    }
}

