/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.DeviceConsumer;
import jmce.sim.SIMException;
import jmce.sim.SampleDeviceProducer;
import jmce.util.RingBuffer;

public class BufferedDeviceProducer<E>
extends SampleDeviceProducer<E> {
    private static final long serialVersionUID = 1L;
    private RingBuffer<E> buffer;

    public BufferedDeviceProducer() {
        this.buffer = new RingBuffer();
    }

    public BufferedDeviceProducer(int size) {
        this.buffer = new RingBuffer(size);
    }

    @Override
    public void addConsumer(DeviceConsumer<E> c) {
        super.add(c);
        try {
            this.consumeBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void consumeBuffer() throws SIMException {
        if (this.size() > 0) {
            while (!this.buffer.isEmpty()) {
                this.consume(this.buffer.get());
            }
        }
    }

    public void produce(E c) throws SIMException {
        this.buffer.put(c);
        this.consumeBuffer();
    }

    public boolean isFull() {
        return this.buffer.isFull();
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public E consume() {
        if (this.buffer.isEmpty()) {
            throw new Error("Consume empty buffer");
        }
        E c = this.buffer.get();
        return c;
    }
}

