/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.SIMException;

public class CPUException
extends SIMException {
    private static final long serialVersionUID = 1L;
    private CPU cpu;

    public CPUException(CPU cpu, String message) {
        super(message);
        this.cpu = cpu;
    }

    @Override
    public String getMessage() {
        Memory m = this.cpu.getMemoryForName("MEMORY");
        String s = this.cpu.getName() + " " + super.getMessage();
        try {
            if (m != null) {
                int pc = this.cpu.pc();
                s = s + " AT " + m.getMemoryName(pc);
            } else {
                s = s + " Unknown memory";
            }
        }
        catch (Exception e) {
            s = s + " Unknow address";
        }
        return s;
    }
}

