/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jmce.sim.AbstractPeripheral;
import jmce.sim.Hardware;
import jmce.sim.SIMException;
import jmce.util.Logger;
import jmce.util.Timer;
import jmce.util.TimerListener;

public class Speaker
extends AbstractPeripheral {
    private static Logger log = Logger.getLogger(Speaker.class);
    private static final int feedTime = 20;
    private int sample = 4000;
    private int freq = 0;
    private boolean installed = false;
    private AudioFormat fmt;
    private SourceDataLine line;
    private int bufferLen = 0;
    private boolean speaker = true;
    private byte[] buffer;
    static int[] music = new int[]{262, 294, 330, 349, 392, 440, 494, 523, 587, 659};

    public Speaker() {
        this.setName("Speaker");
        this.setSampleRate(8000);
    }

    public void setSpeaker(boolean mode) {
        if (!this.installed) {
            return;
        }
        if (mode != this.speaker) {
            this.speaker = mode;
            if (this.speaker) {
                this.line.start();
            } else {
                this.line.stop();
            }
            log.fine("Speaker=" + mode);
            if (mode) {
                this.line.start();
            } else {
                this.line.stop();
            }
        }
    }

    public void setSampleRate(int n) {
        this.sample = n;
        this.buffer = new byte[this.sample];
        log.fine("Sample rate=" + n);
    }

    @Override
    public void init(Hardware p) throws SIMException {
        super.init(p);
        try {
            this.fmt = new AudioFormat(this.sample, 8, 1, false, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.fmt);
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(this.fmt);
            this.line.start();
            Timer timer = new Timer(20, true, new TimerListener(){

                @Override
                public void timerExpired() {
                    Speaker.this.feed();
                }
            });
            this.installed = true;
            Timer.addTimer(timer);
        }
        catch (Exception e) {
            this.installed = false;
            System.out.println(e);
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setFreq(int f) {
        if (f == this.freq) {
            return;
        }
        this.freq = f;
        if (!this.installed) {
            return;
        }
        log.fine("Freq=" + f);
        if (f <= 0) {
            this.bufferLen = 0;
            this.line.stop();
        } else {
            if (this.speaker) {
                this.line.start();
            }
            this.bufferLen = this.sample / f;
            if (this.bufferLen > this.buffer.length) {
                this.bufferLen = this.buffer.length;
            }
            for (int i = 0; i < this.bufferLen; ++i) {
                this.buffer[i] = (byte)(i < this.bufferLen / 2 ? 255 : 0);
            }
        }
        this.line.flush();
    }

    void feed() {
        if (!this.speaker) {
            return;
        }
        if (this.bufferLen <= 0) {
            return;
        }
        int count = 0;
        while (this.line.available() >= this.bufferLen) {
            count += this.line.write(this.buffer, 0, this.bufferLen);
        }
        if (count > 0) {
            log.finer("Written " + count + " bytes");
        }
    }

    public static void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] argv) {
        Speaker s = new Speaker();
        try {
            s.init(null);
            for (int i = 0; i < music.length; ++i) {
                s.setFreq(music[i]);
                Speaker.delay(200);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.exit(0);
    }

    @Override
    public String toString() {
        return "Speaker SR=" + this.sample + " installed=" + this.installed;
    }
}

