/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.cpu;

import jmce.sim.AbstractHardware;
import jmce.sim.Register;
import jmce.sim.RegisterReadListener;
import jmce.sim.RegisterWriteListener;
import jmce.sim.SIMException;
import jmce.util.FastArray;
import jmce.util.Hex;

public abstract class AbstractRegister
extends AbstractHardware
implements Register {
    private int family;
    private int width;
    private int reset;
    protected FastArray<RegisterWriteListener> wl = new FastArray();
    protected FastArray<RegisterReadListener> rl = new FastArray();
    protected int mask;

    AbstractRegister(String name, int family, int width, int reset) {
        super(name);
        this.family = family;
        this.width = width;
        this.mask = (1 << width) - 1;
        this.reset = reset;
    }

    @Override
    public void setResetValue(int reset) {
        this.reset = reset;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getFamily() {
        return this.family;
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.setRegister(this.reset);
    }

    @Override
    public String hexValue() throws SIMException {
        return this.hexValue(this.getRegister());
    }

    @Override
    public String descValue() throws SIMException {
        return this.hexValue();
    }

    @Override
    public String hexValue(int value) {
        if (this.width < 16) {
            return Hex.formatByte(value);
        }
        return Hex.formatWord(value);
    }

    @Override
    public void addRegisterWriteListener(RegisterWriteListener l) {
        this.wl.add(l);
    }

    @Override
    public void addRegisterReadListener(RegisterReadListener l) {
        this.rl.add(l);
    }
}

