/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.cpu;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import jmce.sim.LoadInfo;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.cpu.AbstractLoader;
import jmce.util.Hex;
import jmce.util.Logger;

public class MotorolaLoader
extends AbstractLoader {
    private static final Logger log = Logger.getLogger(MotorolaLoader.class);

    public MotorolaLoader(String ext) {
        super(ext);
    }

    @Override
    public void load(Memory m, String name, int base, LoadInfo info) throws SIMException {
        try {
            String line;
            int lenAddress = 4;
            BufferedReader rd = new BufferedReader(new FileReader(name));
            int start = -1;
            int end = -1;
            while ((line = rd.readLine()) != null) {
                int i;
                if (!line.startsWith("S")) {
                    throw new SIMIOException(name, " is not a valid intel file");
                }
                int type = Hex.getDigit(line, 1);
                int lenData = Hex.getByte(line, 2);
                int address = Hex.getHex(line, 4, lenAddress);
                log.info("Type " + type + " len " + lenData);
                int chksum = 0;
                for (i = 0; i < lenData + 1; ++i) {
                    chksum += Hex.getByte(line, 2 + i * 2);
                }
                lenData -= lenAddress / 2 + 1;
                if ((chksum &= 0xFF) != 255) {
                    throw new SIMException("Invalid chksum " + Hex.formatByte(chksum) + " in " + line);
                }
                if (type == 9) break;
                if (type != 1) {
                    throw new SIMException("Unsupported record type " + type);
                }
                if (address < start || start == -1) {
                    start = address;
                }
                if (address + lenData - 1 > end || end == -1) {
                    end = address + lenData - 1;
                }
                log.info("Load " + lenData + " at " + Hex.formatWord(address));
                for (i = 0; i < lenData; ++i) {
                    m.setMemory(address + i, Hex.getByte(line, 4 + lenAddress + i * 2));
                }
            }
            info.start = start;
            info.end = end;
            rd.close();
        }
        catch (IOException e) {
            throw new SIMIOException(name, " Reading");
        }
    }
}

