/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.disk;

import jmce.sim.AbstractPeripheral;
import jmce.sim.Disk;
import jmce.sim.SIMException;
import jmce.util.Logger;

public abstract class AbstractDisk
extends AbstractPeripheral
implements Disk {
    private static Logger log = Logger.getLogger(AbstractDisk.class);
    protected int numTrack;
    protected int numHead;
    protected int numSector;
    protected int sectorSize;
    protected boolean mounted = false;
    protected boolean readOnly = false;
    protected byte[] buffer = null;
    protected int track;
    protected int head;
    protected int sector;

    public AbstractDisk() {
        this(77, 1, 26, 128);
    }

    public AbstractDisk(int track, int head, int sector, int ssize) {
        this.setName("Disk");
        this.setNumTrack(track);
        this.setNumHead(head);
        this.setNumSector(sector);
        this.setSectorSize(ssize);
    }

    @Override
    public void setNumTrack(int t) {
        this.numTrack = t;
    }

    @Override
    public int getNumTrack() {
        return this.numTrack;
    }

    @Override
    public void setNumSector(int s) {
        this.numSector = s;
    }

    @Override
    public int getNumSector() {
        return this.numSector;
    }

    @Override
    public void setNumHead(int h) {
        this.numHead = h;
    }

    @Override
    public int getNumHead() {
        return this.numHead;
    }

    @Override
    public void setSectorSize(int size) {
        this.sectorSize = size;
        this.buffer = new byte[size];
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public void dismount() throws SIMException {
        this.setMounted(false);
    }

    @Override
    public boolean isMounted() {
        return this.mounted;
    }

    protected boolean setMounted(boolean b) {
        this.mounted = b;
        return this.mounted;
    }

    @Override
    public boolean mount() throws SIMException {
        return this.setMounted(true);
    }

    public int read(int track, int head, int sector) throws SIMException {
        this.setTrack(track);
        this.setHead(head);
        this.setSector(sector);
        return this.read();
    }

    @Override
    public int read() throws SIMException {
        if (!this.seek(this.track, this.head, this.sector)) {
            return -3;
        }
        int pos = this.numSector * this.numHead * this.track + this.numSector * this.head + this.sector - 1;
        int n = this.read(pos *= this.sectorSize);
        return n;
    }

    private boolean seek(int track, int head, int sector) throws SIMException {
        if (track < 0 || track >= this.getNumTrack()) {
            log.info("Track " + track + " not valid.");
            return false;
        }
        if (head < 0 || head >= this.getNumHead()) {
            log.info("Head " + head + " not valid.");
            return false;
        }
        if (sector < 1 || sector > this.getNumSector()) {
            log.info("Sector " + sector + " not valid.");
            return false;
        }
        if (!this.isMounted() && !this.mount()) {
            log.info("Drive  not ready " + this.getName());
            return false;
        }
        return true;
    }

    public int write(int track, int head, int sector) throws SIMException {
        this.setTrack(track);
        this.setHead(head);
        this.setSector(sector);
        return this.write();
    }

    @Override
    public int write() throws SIMException {
        if (this.readOnly) {
            return -2;
        }
        if (!this.seek(this.track, this.head, this.sector)) {
            return -3;
        }
        int pos = this.numSector * this.numHead * this.track + this.numSector * this.head + this.sector - 1;
        int n = this.write(pos *= this.sectorSize);
        return n;
    }

    @Override
    public int getSectorSize() {
        return this.sectorSize;
    }

    @Override
    public int getSector() {
        return this.sector;
    }

    @Override
    public int getHead() {
        return this.head;
    }

    @Override
    public int getTrack() {
        return this.track;
    }

    @Override
    public void setHead(int head) {
        this.head = head;
    }

    @Override
    public void setSector(int sector) {
        this.sector = sector;
    }

    @Override
    public void setTrack(int track) {
        this.track = track;
    }

    @Override
    public void format() throws SIMException {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = -1;
        }
        for (int s = 1; s <= this.getNumSector(); ++s) {
            this.setSector(s);
            this.write();
        }
    }

    protected abstract int write(int var1) throws SIMException;

    protected abstract int read(int var1) throws SIMException;

    public int getDiskSize() {
        return this.getNumTrack() * this.getNumHead() * this.getNumSector() * this.getSectorSize();
    }

    public String getDiskSizeString() {
        int size = this.getDiskSize();
        if (size < 0x100000) {
            return size + " Bytes";
        }
        if (size < 0x40000000) {
            return (size + 1023 - 1) / 1024 + " KB";
        }
        return size / 0x100000 + " MB";
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean mode) {
        this.readOnly = mode;
    }
}

