/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.disk;

import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Disk;
import jmce.sim.DiskController;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.util.Hex;
import jmce.util.Logger;

public class BootLoader
extends AbstractPeripheral
implements ResetListener {
    private static Logger log = Logger.getLogger(BootLoader.class);
    private int address = 0;

    public BootLoader() {
        this.setName("DiskBootLoader");
        this.setAddress(0);
    }

    public void setAddress(int a) {
        this.address = a;
    }

    public int getAddress() {
        return this.address;
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addResetListener(this);
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        DiskController fdc = (DiskController)cpu.getHardware(DiskController.class);
        if (fdc == null) {
            log.info("FDC not installed");
        } else if (fdc.getDiskCount() < 1) {
            log.info("No disk installed");
        } else {
            Disk d = fdc.getDisk(0);
            byte[] buffer = d.getBuffer();
            d.setTrack(0);
            d.setHead(0);
            d.setSector(1);
            int len = d.read();
            log.info("Bootloader " + len + " bytes from drive 0");
            for (int i = 0; i < len; ++i) {
                cpu.setByte(i + this.address, buffer[i]);
            }
        }
    }

    @Override
    public String toString() {
        return "Disk boot loader AT 0x" + Hex.formatWord(this.address);
    }
}

