/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.memory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import jmce.sim.CPU;
import jmce.sim.Hardware;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.memory.PlainMemory;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.util.Timer;
import jmce.util.TimerListener;

public class PersistentMemory
extends PlainMemory
implements TimerListener,
MemoryWriteListener,
ResetListener {
    private static Logger log = Logger.getLogger(PersistentMemory.class);
    private boolean changed = false;
    private String filename;

    public PersistentMemory() {
    }

    public PersistentMemory(String name, String filename, int size) {
        super(name, size);
        this.setFilename(filename);
    }

    @Override
    public void writeMemory(Memory m, int a, int v, int o) {
        if (v != o) {
            if (this.cpu != null && this.cpu.isRunning()) {
                log.info(this.getName() + " changed at " + this.getMemoryName(a) + " from " + Hex.formatByte(o) + " to " + Hex.formatByte(v));
            }
            this.changed = true;
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addResetListener(this);
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        this.load();
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        super.init(parent);
        this.addMemoryWriteListener(this);
        Timer.createTimer(1000, true, this);
    }

    @Override
    public void timerExpired() {
        if (!this.changed) {
            return;
        }
        FileOutputStream os = null;
        log.info("Save " + this.toString() + " to " + this.filename());
        try {
            this.changed = false;
            os = new FileOutputStream(new File(this.filename()));
            for (int i = 0; i < this.getSize(); ++i) {
                os.write(this.getMemory(i));
            }
            os.close();
        }
        catch (Exception e) {
            System.out.println(e);
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        os = null;
    }

    protected String filename() {
        StringTokenizer st = new StringTokenizer(this.getFilename(), ".");
        int n = st.countTokens();
        if (n == 1) {
            return this.getFilename() + "." + this.getSize();
        }
        String s = "";
        for (int i = 0; i < n; ++i) {
            String s1 = st.nextToken();
            if (i == n - 1) {
                s = s + "." + this.getSize();
            }
            if (i > 0) {
                s = s + ".";
            }
            s = s + s1;
        }
        return s;
    }

    protected void load() throws SIMException {
        File file = new File(this.filename());
        try {
            if (file.exists()) {
                int c;
                log.info("Loading from " + file);
                FileInputStream is = new FileInputStream(file);
                int i = 0;
                while ((c = is.read()) >= 0) {
                    this.setMemory(i++, c);
                }
                is.close();
            }
        }
        catch (FileNotFoundException ex) {
            throw new SIMIOException(this.filename(), "File not found");
        }
        catch (IOException ex) {
            throw new SIMIOException(this.filename(), "Error reading");
        }
    }
}

