/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.serial;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jmce.sim.DeviceConsumer;
import jmce.sim.Hardware;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.Serial;
import jmce.util.Logger;

public class SerialFile
extends Serial
implements DeviceConsumer<Integer> {
    private static final Logger log = Logger.getLogger(SerialFile.class);
    private String filename = "";
    private OutputStream os = null;

    public SerialFile() {
        this("serial.txt");
    }

    public SerialFile(String name) {
        this.setFileName(name);
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        super.init(parent);
        log.info("Serial to " + this.filename);
        try {
            this.os = new FileOutputStream(this.filename);
        }
        catch (FileNotFoundException e) {
            throw new SIMIOException(this.filename, " Not found");
        }
        this.addInputConsumer(this);
    }

    @Override
    public void consume(Integer c) throws SIMException {
        try {
            if (this.os != null) {
                this.os.write(c);
            }
        }
        catch (IOException e) {
            throw new SIMIOException(this.filename, " Writing");
        }
    }

    public void setFileName(String s) {
        this.filename = s;
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public String toString() {
        return "SerialFile " + this.filename;
    }
}

