/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.tape;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jmce.sim.SIMException;
import jmce.sim.TapePulse;
import jmce.sim.tape.AbstractTape;
import jmce.sim.tape.TapeData;
import jmce.sim.tape.TapeFileDecoder;
import jmce.util.FastArray;
import jmce.util.Logger;

public class TapeFile
extends AbstractTape {
    private static Logger log = Logger.getLogger(TapeFile.class);
    private String config;
    private FastArray<TapeFileDecoder> decoders = new FastArray();
    private boolean playing = false;
    private boolean recording = false;
    private InputStream is = null;
    private TapeFileDecoder decoder;
    private TapeData data = null;
    private int dataPtr;

    public TapeFile() {
        super("Tape");
    }

    public TapeFile(String name) {
        super(name);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.close();
    }

    public TapeData getTapeData() {
        return this.data;
    }

    public int getCurrentTapeData() {
        if (this.data == null) {
            return 0;
        }
        return this.dataPtr;
    }

    public int getNumTapeData() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getSize();
    }

    private void close() {
        this.playing = false;
        this.recording = false;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is = null;
        }
    }

    protected void addDecoder(TapeFileDecoder decoder) {
        this.decoders.add(decoder);
    }

    @Override
    public String getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(String config) {
        this.config = config;
    }

    @Override
    public void rewind() throws SIMException {
        this.close();
        this.notifyStop();
    }

    @Override
    public void play() throws SIMException {
        this.dataPtr = 0;
        if (this.playing) {
            return;
        }
        if (this.config == null) {
            throw new SIMException("No file specified");
        }
        try {
            this.is = new FileInputStream(this.config);
            this.is.close();
        }
        catch (Exception ex) {
            throw new SIMException("File not found " + this.config);
        }
        if (this.decoders.getSize() == 0) {
            throw new SIMException("No decoders installed");
        }
        this.decoder = null;
        for (int i = 0; i < this.decoders.getSize(); ++i) {
            this.decoder = this.decoders.get(i);
            try {
                this.is = new FileInputStream(this.config);
                if (this.decoder.isFileSupported(this.is)) {
                    log.info("Decoder " + this.decoder + " for " + this.config);
                    break;
                }
                this.is.close();
                continue;
            }
            catch (Exception ignore) {
                log.info(ignore);
                this.close();
                this.decoder = null;
            }
        }
        if (this.decoder == null) {
            this.close();
            throw new SIMException("File " + this.config + " not supported");
        }
        try {
            this.data = this.decoder.decode(new BufferedInputStream(this.is));
        }
        catch (IOException ex) {
            log.info(ex);
            this.data = null;
        }
        this.close();
        this.notifyPlay();
        log.info(this.config + " decoded with " + this.decoder + " size=" + this.data.getSize());
        this.playing = true;
    }

    @Override
    public boolean isPlay() {
        return this.playing;
    }

    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public void rec() throws SIMException {
        this.recording = true;
        this.notifyRec();
    }

    @Override
    public void stop() throws SIMException {
        this.close();
        this.notifyStop();
    }

    @Override
    public TapePulse nextPulse() {
        if (this.data == null) {
            return null;
        }
        if (this.dataPtr >= this.data.getSize()) {
            return null;
        }
        if (this.dataPtr == this.data.getSize() - 1) {
            log.info("Play terminated");
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (TapePulse)this.data.get(this.dataPtr++);
    }
}

