/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.terminal;

import jmce.sim.AbstractHardware;
import jmce.sim.Hardware;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.terminal.CRT;
import jmce.sim.terminal.Terminal;

public abstract class AbstractCRT
extends AbstractHardware
implements CRT {
    protected Terminal terminal = null;
    protected boolean[] lineChanged;
    protected boolean screenChanged;
    protected int numCol;
    protected int numRow;
    protected Memory charMemory;
    protected Memory attMemory;

    public AbstractCRT(String name) {
        this.setName(name);
    }

    public AbstractCRT() {
        this("AbstractCRT");
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.terminal = (Terminal)parent;
        this.numCol = this.terminal.getNumCol();
        this.numRow = this.terminal.getNumRow();
        this.lineChanged = new boolean[this.numRow];
        this.screenChanged = false;
        this.charMemory = this.terminal.getCharMemory();
        this.attMemory = this.terminal.getAttMemory();
        this.charMemory.addMemoryWriteListener(this);
        this.attMemory.addMemoryWriteListener(this);
        super.init(parent);
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) {
        this.changedLine(address / this.numCol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedLine(int n) {
        boolean[] blArray = this.lineChanged;
        synchronized (this.lineChanged) {
            this.lineChanged[n] = true;
            this.screenChanged = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getChar(int r, int c) throws SIMException {
        return this.charMemory.getMemory(r * this.numCol + c);
    }

    public int getAtt(int r, int c) throws SIMException {
        return this.attMemory.getMemory(r * this.numCol + c);
    }
}

