/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.terminal;

import java.awt.Font;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import jmce.sim.DeviceConsumer;
import jmce.sim.Hardware;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.memory.PlainMemory;
import jmce.sim.terminal.CRT;
import jmce.sim.terminal.SwingCRT;
import jmce.sim.terminal.Terminal;
import jmce.util.Logger;

public class SampleTerminal
extends Terminal {
    private static Logger log = Logger.getLogger(SampleTerminal.class);
    protected int abortKey = 30;
    private int numRow;
    private int numCol;
    private int numStatus;
    private Font font = new Font("Monospaced", 0, 18);
    private int row;
    private int col;
    private Memory videoAtt = new PlainMemory("AttMemory");
    private Memory videoChar = new PlainMemory("CharMemory");
    private boolean insertMode = false;
    private int savedRow;
    private int savedCol;
    private byte att;
    private HashMap<Integer, String> keys = new HashMap();
    private PrintStream ps = null;
    private String filename = null;
    private static Class defaultCRT = SwingCRT.class;

    public static void setDefaultCRT(String name) throws SIMException {
        try {
            SampleTerminal.setDefaultCRT(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            throw new SIMException("Class not found " + name);
        }
    }

    public static void setDefaultCRT(Class clazz) {
        defaultCRT = clazz;
    }

    public SampleTerminal() {
        this("Sample terminal");
    }

    @Override
    public int getFontSize() {
        return this.font.getSize();
    }

    @Override
    public void setFontSize(int size) {
        this.font = this.font.deriveFont((float)size);
    }

    public SampleTerminal(String name) {
        super(name);
        this.setNumRow(25);
        this.setNumCol(80);
        this.setNumStatus(1);
        this.defineFunctionKey(65574, '\u0005');
        this.defineFunctionKey(65576, '\u0018');
        this.defineFunctionKey(65573, '\u0013');
        this.defineFunctionKey(65575, '\u0004');
        this.defineFunctionKey(65691, '\u0016');
        this.defineFunctionKey(65546, '\r');
        this.defineFunctionKey(65545, '\t');
        this.defineFunctionKey(65569, '\u0012');
        this.defineFunctionKey(65570, '\u0003');
        this.defineFunctionKey(65691, '\u0016');
        this.defineFunctionKey(65663, '\u007f');
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void write(Integer k) throws SIMException {
        if (k == this.abortKey && this.abortKey != -1) {
            if (this.cpu != null) {
                this.cpu.abort("ABORT  pressed.");
            }
            return;
        }
        String s = this.getFunctionKey(k);
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                super.write(Integer.valueOf(s.charAt(i)));
            }
        } else if (k >= 0 && k <= 255) {
            super.write(k);
        }
    }

    @Override
    public int getNumStatus() {
        return this.numStatus;
    }

    @Override
    public void setNumStatus(int n) {
        this.numStatus = n;
    }

    private void setMemorySize() {
        this.videoAtt.setSize(this.getScreenSize());
        this.videoChar.setSize(this.getScreenSize());
    }

    @Override
    public void setNumRow(int row) {
        this.numRow = row;
        this.setMemorySize();
    }

    @Override
    public void setNumCol(int col) {
        this.numCol = col;
        this.setMemorySize();
    }

    @Override
    public int getNumRow() {
        return this.numRow;
    }

    @Override
    public int getNumCol() {
        return this.numCol;
    }

    public int getWindowSize() {
        return this.numCol * (this.numRow - this.numStatus);
    }

    public int getScreenSize() {
        return this.numCol * this.numRow;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public boolean getCursor() {
        return true;
    }

    @Override
    public void setCursor(int row, int col) {
        if (row < 0) {
            row = 0;
        } else if (row >= this.numRow) {
            row = this.numRow - 1;
        }
        if (col < 0) {
            col = 0;
        } else if (col >= this.numCol) {
            col = this.numCol - 1;
        }
        try {
            this.setAtt(this.row, this.col, this.getAtt(this.row, this.col));
            this.row = row;
            this.col = col;
            this.setAtt(this.row, this.col, this.getAtt(this.row, this.col));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setAtt(int r, int c, int a) throws SIMException {
        this.setAtt(this.getPos(r, c), a);
    }

    void setAtt(int pos, int a) throws SIMException {
        this.videoAtt.setMemory(pos, a);
    }

    public int getAtt() {
        return this.att;
    }

    public void setAtt(int n) {
        this.att = (byte)n;
    }

    public void setChar(int r, int c, int ch) throws SIMException {
        this.setChar(this.getPos(r, c), ch);
    }

    public void setChar(int pos, int c) throws SIMException {
        this.videoChar.setMemory(pos, c);
    }

    @Override
    public void setStatusLine(int r, int c, Object o) {
        try {
            String s = String.valueOf(o);
            if (r < this.numStatus) {
                r += this.numRow - this.numStatus;
                for (int i = 0; i < s.length(); ++i) {
                    this.setAtt(r, c, 1);
                    this.setChar(r, c, s.charAt(i));
                }
            }
        }
        catch (Exception discard) {
            // empty catch block
        }
    }

    @Override
    public void printStatusLine(int r, Object o) {
        try {
            String s = String.valueOf(o);
            if (r < this.numStatus) {
                r += this.numRow - this.numStatus;
                for (int c = 0; c < this.numCol; ++c) {
                    this.setAtt(r, c, 1);
                    this.setChar(r, c, c < s.length() ? (int)s.charAt(c) : 32);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.setAtt(0);
        this.home();
        this.cls();
        for (int i = 0; i < this.numStatus; ++i) {
            this.printStatusLine(i, "");
        }
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        CRT crt = (CRT)this.getHardware((Class)CRT.class);
        if (crt == null) {
            try {
                crt = (CRT)defaultCRT.newInstance();
            }
            catch (Exception e) {
                throw new SIMException("Error creating CRT class");
            }
            this.addHardware(crt);
        }
        super.init(parent);
        this.videoAtt.setSize(this.getScreenSize());
        this.videoChar.setSize(this.getScreenSize());
        log.info(this + " - Initialized");
        this.addInputConsumer(new DeviceConsumer<Integer>(){

            @Override
            public void consume(Integer c) throws SIMException {
                SampleTerminal.this.putchar(c);
            }
        });
    }

    public int getAtt(int r, int c) throws SIMException {
        return this.getAtt(this.getPos(r, c));
    }

    public int getAtt(int pos) throws SIMException {
        return this.videoAtt.getMemory(pos);
    }

    public int getChar(int r, int c) throws SIMException {
        return this.getChar(this.getPos(r, c));
    }

    public int getChar(int pos) throws SIMException {
        return this.videoChar.getMemory(pos);
    }

    int getPos(int row, int col) {
        return row * this.numCol + col;
    }

    int getPos(int col) {
        return this.row * this.numCol + col;
    }

    int getPos() {
        return this.row * this.numCol + this.col;
    }

    public void home() {
        this.setCursor(0, 0);
    }

    public void cls() {
        try {
            for (int i = 0; i < this.getWindowSize(); ++i) {
                this.setChar(i, 32);
                this.setAtt(i, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setInsertMode(boolean insertMode) {
        this.insertMode = insertMode;
    }

    public void saveCursor() {
        this.savedCol = this.getCol();
        this.savedRow = this.getRow();
    }

    public void restoreCursor() {
        this.setCursor(this.savedRow, this.savedCol);
    }

    public void clearEol() {
        try {
            int pos = this.getPos();
            for (int i = this.col; i < this.numCol; ++i) {
                this.setChar(pos++, 32);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void scrollUp(int from, int size, int n) {
        try {
            int i;
            for (i = 0; i < size - n; ++i) {
                this.setChar(from + i, this.getChar(from + i + n));
                this.setAtt(from + i, this.getAtt(from + i + n));
            }
            for (i = 0; i < n; ++i) {
                this.videoChar.setMemory(from + size - 1 - i, 32);
                this.videoAtt.setMemory(from + size - 1 - i, this.att);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void scrollDown(int from, int size, int n) {
        try {
            int i;
            for (i = 0; i < size - n; ++i) {
                this.videoChar.setMemory(from + size - i - 1, this.getChar(from + size - i - 1 - n));
                this.videoAtt.setMemory(from + size - i - 1, this.getAtt(from + size - i - 1 - n));
            }
            for (i = 0; i < n; ++i) {
                this.videoChar.setMemory(from + i, 32);
                this.videoAtt.setMemory(from + i, this.att);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void insertChar() {
        int pos = this.getPos();
        this.scrollDown(pos, (this.getNumRow() - this.getNumStatus()) * this.getNumCol() - pos, 1);
    }

    public void insertChar(int c) {
        try {
            int pos = this.getPos();
            this.insertChar();
            this.setChar(pos, c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertLine() {
        this.scrollDown(this.row * this.numCol, (this.numRow - this.numStatus - this.row) * this.numCol, this.numCol);
    }

    public void deleteChar() {
        int pos = this.getPos();
        this.scrollUp(pos, (this.numRow - this.numStatus) * this.numCol - pos, 1);
    }

    public void deleteLine() {
        this.scrollUp(this.row * this.numCol, (this.numRow - this.row - this.numStatus) * this.numCol, this.numCol);
    }

    void clearLine() {
        try {
            int pos = this.getPos(0);
            int c = 0;
            while (c <= this.getNumCol()) {
                this.setChar(pos, 32);
                ++c;
                ++pos;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearFromLine() {
        try {
            int pos = this.getPos(0);
            int c = 0;
            while (c <= this.getCol()) {
                this.setChar(pos, 32);
                ++c;
                ++pos;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearLine(int r) {
        try {
            int pos = r * this.numCol;
            for (int c = 0; c < this.numCol; ++c) {
                this.setChar(pos++, 32);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearToCursor() {
        this.clearFromLine();
        for (int r = 0; r < this.row; ++r) {
            this.clearLine(r);
        }
    }

    public void clearEos() {
        this.clearEol();
        for (int r = this.row + 1; r < this.numRow; ++r) {
            this.clearLine(r);
        }
    }

    public void up() {
        if (this.row > 0) {
            this.setCursor(this.row - 1, this.col);
        }
    }

    public void down() {
        if (this.row + 1 < this.numRow - this.numStatus) {
            this.setCursor(this.row + 1, this.col);
        }
    }

    public void left() {
        if ((this.row != 0 || this.col != 0) && --this.col < 0) {
            --this.row;
            this.col = this.numCol - 1;
        }
        this.setCursor(this.row, this.col);
    }

    public void right() {
        if (this.row == this.getNumRow() - 1 - this.numStatus && this.col == this.getNumCol() - 1) {
            return;
        }
        if (++this.col >= this.getNumCol()) {
            this.col = 0;
            if (++this.row >= this.getNumRow() - this.numStatus) {
                this.row = this.getNumRow() - 1 - this.numStatus;
            }
        }
        this.setCursor(this.row, this.col);
    }

    @Override
    public void putchar(int c) throws SIMException {
        try {
            switch (c) {
                default: {
                    if (c < 32 || c > 127) {
                        c = 32;
                    }
                    if (this.insertMode) {
                        this.insertChar(c);
                    } else {
                        if (this.ps != null) {
                            this.ps.print((char)c);
                        }
                        this.setChar(this.row * this.numCol + this.col, c);
                        this.setAtt(this.row, this.col, this.getAtt());
                    }
                    if (this.col + 1 >= this.numCol) {
                        if (this.row + 1 >= this.numRow - this.numStatus) {
                            this.scrollUp(0, (this.numRow - this.numStatus) * this.numCol, this.numCol);
                            this.setCursor(this.row, 0);
                            break;
                        }
                        this.setCursor(this.row + 1, 0);
                        break;
                    }
                    this.setCursor(this.row, this.col + 1);
                    break;
                }
                case 9: {
                    int nc = this.col / 8 * 8 + 8;
                    if (nc >= this.numCol) {
                        nc = this.numCol - 1;
                    }
                    this.setCursor(this.row, nc);
                    break;
                }
                case 127: {
                    if (this.col > 0) {
                        --this.col;
                    }
                    this.setChar(this.row, this.col, 32);
                    this.setAtt(this.row, this.col, this.getAtt());
                    this.setCursor(this.row, this.col);
                    break;
                }
                case 8: {
                    if (this.col <= 0) break;
                    this.setCursor(this.row, this.col - 1);
                    break;
                }
                case 13: {
                    this.setCursor(this.row, 0);
                    break;
                }
                case 10: {
                    if (this.ps != null) {
                        this.ps.println();
                        this.ps.flush();
                    }
                    this.setCursor(this.row, 0);
                    if (this.row + 1 >= this.numRow - this.numStatus) {
                        this.scrollUp(0, (this.numRow - this.numStatus) * this.numCol, this.numCol);
                        break;
                    }
                    this.setCursor(this.row + 1, this.col);
                    break;
                }
                case 12: {
                    this.cls();
                    this.home();
                }
                case 7: 
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void defineFunctionKey(int k, char c) {
        this.defineFunctionKey(k, "" + c);
    }

    @Override
    public void defineFunctionKey(int k, String s) {
        this.keys.put(k, s);
    }

    @Override
    public String getFunctionKey(int k) {
        return this.keys.get(k);
    }

    @Override
    public Memory getCharMemory() {
        return this.videoChar;
    }

    @Override
    public Memory getAttMemory() {
        return this.videoAtt;
    }

    @Override
    public String getEchoFile() {
        return this.filename;
    }

    @Override
    public void setEchoFile(String file) {
        this.filename = file;
        try {
            this.ps = new PrintStream(new FileOutputStream(file));
        }
        catch (Exception ex) {
            this.ps = null;
        }
    }

    public int getAbortKey() {
        return this.abortKey;
    }

    public void setAbortKey(int n) {
        this.abortKey = n;
    }

    @Override
    public String toString() {
        return this.getName() + " - " + this.getNumRow() + "x" + this.getNumCol();
    }
}

