/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.terminal;

import jmce.sim.Hardware;
import jmce.sim.SIMException;
import jmce.sim.terminal.AbstractCRT;
import jmce.sim.terminal.Terminal;

public class ttyCRT
extends AbstractCRT
implements Runnable {
    public final int UP = 18432;
    public final int DOWN = 20480;
    public final int LEFT = 19200;
    public final int RIGHT = 19712;
    public final int KEY_F10 = 17408;
    public final int KEY_DEL = 21248;
    private int NROW;
    private int NCOL;
    private byte[] line;
    private Thread thread = null;

    private native void ttyPutchar(byte[] var1, int var2, int var3);

    private native void ttySetCursorPosition(int var1, int var2);

    private native void ttySetCursor(boolean var1);

    private native boolean ttyKbhit();

    private native int ttyGetch();

    private native int ttyGetNumRow();

    private native int ttyGetNumCol();

    private native boolean ttyInit();

    private native void ttyReset();

    public ttyCRT() {
        System.loadLibrary("jmce");
        this.ttyInit();
        this.NROW = this.ttyGetNumRow();
        this.NCOL = this.ttyGetNumCol();
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.terminal = (Terminal)parent;
        int r = this.terminal.getNumRow() - this.terminal.getNumStatus();
        if (this.NROW > r) {
            this.terminal.setNumStatus(this.NROW - r);
        } else {
            this.terminal.setNumStatus(0);
        }
        this.terminal.setNumRow(this.NROW);
        this.terminal.setNumCol(this.NCOL);
        super.init(parent);
        this.line = new byte[this.NCOL];
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.start();
    }

    @Override
    public void destroy() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            if (this.thread == null) {
                this.ttyReset();
                return;
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.thread == null) continue;
            if (this.ttyKbhit()) {
                int c = this.ttyGetch();
                switch (c) {
                    case 21248: {
                        c = 65663;
                        break;
                    }
                    case 17408: {
                        c = 65657;
                        break;
                    }
                    case 18432: {
                        c = 65574;
                        break;
                    }
                    case 20480: {
                        c = 65576;
                        break;
                    }
                    case 19200: {
                        c = 65573;
                        break;
                    }
                    case 19712: {
                        c = 65575;
                        break;
                    }
                }
                try {
                    this.terminal.write(c);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (!this.screenChanged) continue;
            boolean[] blArray = this.lineChanged;
            // MONITORENTER : this.lineChanged
            try {
                this.screenChanged = false;
                this.ttySetCursor(false);
                for (int r = 0; r < this.NROW; ++r) {
                    if (!this.lineChanged[r]) continue;
                    this.lineChanged[r] = false;
                    int count = 0;
                    int pos = r * this.NCOL;
                    int att = this.getAtt(r, 0);
                    this.ttySetCursorPosition(r, 0);
                    for (int c = 0; c < this.NCOL; ++c, ++pos) {
                        if (att != this.getAtt(r, c)) {
                            this.ttyPutchar(this.line, count, att);
                            att = this.getAtt(r, c);
                            count = 0;
                        }
                        this.line[count++] = (byte)this.getChar(r, c);
                    }
                    this.ttyPutchar(this.line, count, att);
                }
                if (this.terminal.getCursor()) {
                    this.ttySetCursorPosition(this.terminal.getRow(), this.terminal.getCol());
                    this.ttySetCursor(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

