/*
 * Decompiled with CFR 0.152.
 */
package jmce.sinclair.spectrum;

import jmce.intel.i8080.I8080;
import jmce.sim.CPU;
import jmce.sim.LoadInfo;
import jmce.sim.LoadableListener;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.sim.SIMSWException;
import jmce.sim.memory.ArrayMemory;
import jmce.sim.memory.CombinedMemory;
import jmce.sim.memory.LoadableMemory;
import jmce.sim.memory.PlainMemory;
import jmce.sinclair.spectrum.Screen;
import jmce.sinclair.spectrum.SpectrumConstants;
import jmce.sinclair.spectrum.SpectrumMemory;
import jmce.util.Logger;

public class Memory128K
extends CombinedMemory
implements MemoryWriteListener,
SpectrumConstants,
SpectrumMemory,
ResetListener,
MemoryReadListener {
    private static Logger log = Logger.getLogger(Memory128K.class);
    private Memory[] bank = new Memory[8];
    private LoadableMemory rom0;
    private LoadableMemory rom1;
    private ArrayMemory roms = new ArrayMemory();
    private ArrayMemory banks = new ArrayMemory();
    private I8080 i8080;
    private int mmu;
    private Screen screen;

    public Memory128K() {
        super("MEMORY");
        for (int i = 0; i < 8; ++i) {
            this.bank[i] = new PlainMemory("Bank" + i, 16384);
            this.banks.addHardwareMemory(this.bank[i]);
        }
        this.addHardware(this.banks);
        this.rom0 = new LoadableMemory("Rom0", 16384, "sinclair/128a.rom");
        this.rom0.addLoadableListener(new LoadableListener(){

            @Override
            public void startLoad(CPU cpu) {
                Memory128K.this.writeMMU(0);
            }

            @Override
            public void endLoad(CPU cpu, LoadInfo info) {
            }
        });
        this.rom1 = new LoadableMemory("Rom1", 16384, "sinclair/128b.rom");
        this.rom1.addLoadableListener(new LoadableListener(){

            @Override
            public void startLoad(CPU cpu) {
                Memory128K.this.writeMMU(16);
            }

            @Override
            public void endLoad(CPU cpu, LoadInfo info) {
                Memory128K.this.writeMMU(0);
            }
        });
        this.roms.addHardwareMemory(this.rom0);
        this.roms.addHardwareMemory(this.rom1);
        this.addHardware(this.roms);
        this.addMemory(this.roms);
        this.addMemory(this.bank[5]);
        this.addMemory(this.bank[2]);
        this.addMemory(this.banks);
        log.info("Memory " + this.toString());
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        this.i8080 = (I8080)cpu;
        cpu.addResetListener(this);
        cpu.addIOReadListener(this);
        cpu.addIOWriteListener(this);
        this.screen = (Screen)cpu.getHardware(Screen.class);
        if (this.screen == null) {
            throw new SIMSWException("No Spectrum Screen installed!");
        }
    }

    public void writeMMU(int value) {
        int old = this.mmu;
        if ((this.mmu & 0x20) != 0) {
            return;
        }
        this.mmu = value;
        if ((this.mmu & 8) != (old & 8)) {
            this.screen.setMemory(this.getVideoMemory());
        }
        this.banks.setIndex(this.mmu & 7);
        this.roms.setIndex((this.mmu & 0x10) != 0 ? 1 : 0);
    }

    @Override
    public int readMemory(Memory memory, int address, int value) throws SIMException {
        if ((address |= this.i8080.getPortHI() << 8) == 32765) {
            value = this.mmu;
        }
        return value;
    }

    @Override
    public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
        if ((address |= this.i8080.getPortHI() << 8) == 32765) {
            this.writeMMU(value);
        }
    }

    @Override
    public Memory getVideoMemory() {
        return (this.mmu & 8) == 0 ? this.bank[5] : this.bank[7];
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        this.mmu &= 0xFFFFFFDF;
        this.writeMMU(0);
    }
}

