/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class KFixedField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = 1L;
    protected int len;
    private boolean selected = false;
    private Color changedColor = Color.red;
    private Color normalColor = Color.black;

    public KFixedField(String s) {
        this(s.length());
        this.setText(s);
        this.setText(s);
    }

    public KFixedField(int len) {
        this.setFontMonospace();
        this.len = len;
        this.setEditable(false);
        this.setText("");
        this.addFocusListener(this);
    }

    private void setFontMonospace() {
        Font font = this.getFont();
        int style = font.getStyle();
        font = new Font("Monospaced", style, font.getSize());
        this.setFont(font);
        this.normalColor = this.getForeground();
    }

    @Override
    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        while (s.length() < this.len) {
            if (this.getHorizontalAlignment() == 4) {
                s = " " + s;
                continue;
            }
            s = s + " ";
        }
        s = s.substring(0, this.len);
        String old = this.getText();
        if (old == null) {
            old = "";
        }
        if (s.equals(old)) {
            this.setForeground(this.normalColor);
        } else {
            this.setForeground(this.changedColor);
            super.setText(s);
        }
    }

    @Override
    public void updateUI() {
        this.setFont(null);
        this.setForeground(null);
        super.updateUI();
        this.setFontMonospace();
    }

    @Override
    public void setEditable(boolean mode) {
        super.setEditable(mode);
        this.setFocusable(mode);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.isEditable() && this.isEnabled()) {
            this.selectAll();
        }
    }
}

