/*
 * Decompiled with CFR 0.152.
 */
package jmce.util;

import jmce.util.RingBuffer;

public class FastLinkedList<T> {
    private RingBuffer<Node<T>> nodePool = new RingBuffer(256);
    private Node<T> head = new Node();
    private int count = 0;

    public void remove(Node<T> e) {
        ((Node)e).prev.next = ((Node)e).next;
        ((Node)e).next.prev = ((Node)e).prev;
        ((Node)e).element = null;
        this.nodePool.put(e);
        --this.count;
    }

    private Node<T> newLink(T e, Node<T> next, Node<T> prev) {
        Node<T> l = this.nodePool.get();
        if (l == null) {
            l = new Node(e, next, prev);
        } else {
            ((Node)l).element = e;
            ((Node)l).next = (Node)next;
            ((Node)l).prev = (Node)prev;
        }
        ++this.count;
        return l;
    }

    void addBefore(Node<T> l, T element) {
        Node<T> l1 = this.newLink(element, l, ((Node)l).prev);
        ((Node)l1).prev.next = (Node)l1;
        ((Node)l1).next.prev = (Node)l1;
    }

    public final void addToBegin(T element) {
        this.addBefore(((Node)this.head).next, element);
    }

    public final void addToEnd(T element) {
        this.addBefore(this.head, element);
    }

    public final Node<T> getHead() {
        return this.head;
    }

    public final Node<T> getFirst() {
        return ((Node)this.head).next;
    }

    public final Node<T> getLast() {
        return ((Node)this.head).prev;
    }

    public final boolean isHead(Node<T> l) {
        return l == this.head;
    }

    public final int getSize() {
        return this.count;
    }

    public final Node<T> search(T element) {
        Node e = ((Node)this.head).next;
        while (e != this.head) {
            if (e.element == element) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public static class Node<T> {
        private T element;
        private Node<T> next;
        private Node<T> prev;

        private Node() {
            this.next = this.prev = this;
            this.element = null;
        }

        private Node(T e, Node<T> next, Node<T> prev) {
            this.element = e;
            this.next = next;
            this.prev = prev;
        }

        public final T get() {
            return this.element;
        }

        public final Node<T> Next() {
            return this.next;
        }

        public final Node<T> Previous() {
            return this.prev;
        }

        public final boolean hasNext() {
            return this.next != this;
        }
    }
}

