/*
 * Decompiled with CFR 0.152.
 */
package jmce.util;

import jmce.sim.SIMException;
import jmce.util.FastLinkedList;
import jmce.util.Logger;
import jmce.util.Timer;

public class TimerManager
extends Thread {
    private static Logger log = Logger.getLogger(TimerManager.class);
    private String name;
    private static TimerManager msTimer = null;
    private FastLinkedList<Timer> queue = new FastLinkedList();

    public TimerManager(String name) {
        this.name = name;
    }

    public final int getSize() {
        return this.queue.getSize();
    }

    public static void addTimer(Timer t) {
        if (msTimer == null) {
            msTimer = new TimerManager("ms Timer");
            msTimer.start();
        }
        msTimer.add(t);
    }

    public final void add(Timer t) {
        t.manager = this;
        t.remainingTime = t.initialTime;
        t.status = 1;
        FastLinkedList.Node<Timer> l = this.queue.getFirst();
        while (!this.queue.isHead(l)) {
            int r = l.get().remainingTime;
            if (t.remainingTime <= r) {
                l.get().remainingTime -= t.remainingTime;
                this.queue.addBefore(l, t);
                return;
            }
            t.remainingTime -= r;
            l = l.Next();
        }
        this.queue.addToEnd(t);
    }

    public final void remove(Timer t) {
        t.status = 3;
        t.manager = null;
        FastLinkedList.Node<Timer> l = this.queue.search(t);
        if (l != null) {
            this.queue.remove(l);
        }
    }

    public final void elapsed(int n) throws SIMException {
        FastLinkedList.Node<Timer> l;
        while (n > 0 && !this.queue.isHead(l = this.queue.getFirst())) {
            Timer t = l.get();
            if (n >= t.remainingTime) {
                n -= t.remainingTime;
                this.queue.remove(l);
                if (t.status != 1) continue;
                t.target.timerExpired();
                t.status = 0;
                if (!t.isRepeat()) continue;
                this.add(t);
                continue;
            }
            t.remainingTime -= n;
            break;
        }
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        while (true) {
            try {
                while (true) {
                    Thread.yield();
                    long now = System.currentTimeMillis();
                    time = now - time;
                    if (time > 0L) {
                        this.elapsed((int)time);
                    }
                    time = now;
                }
            }
            catch (Throwable e) {
                System.out.println(e);
                continue;
            }
            break;
        }
    }

    @Override
    public String toString() {
        return this.name;
    }
}

