/*
 * Decompiled with CFR 0.152.
 */
package jmce.viara.diseqc;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jmce.intel.mcs51.MCS51;
import jmce.intel.mcs51.MCS51Constants;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.SwingHardware;
import jmce.swing.Util;
import jmce.util.Logger;
import jmce.util.Timer;
import jmce.util.TimerListener;
import jmce.viara.diseqc.DiseqcLed;
import jmce.viara.diseqc.JFactory;

public class DiseqcMotor
extends AbstractPeripheral
implements SwingHardware,
MemoryWriteListener,
MCS51Constants {
    private static Logger log = Logger.getLogger(DiseqcMotor.class);
    private int position = 0;
    private JPanel p = null;
    JSlider slider;
    DiseqcLed ledWest = new DiseqcLed("West", Color.blue);
    DiseqcLed ledEst = new DiseqcLed("Est", Color.red);
    DiseqcLed ledStatus = new DiseqcLed("Status", Color.green);
    DiseqcLed ledPower = new DiseqcLed("Power", Color.orange);
    JToggleButton bEst = new JToggleButton("GO East");
    JToggleButton bWest = new JToggleButton("GO West");
    static final int MOTOR_STARTUP_TIME = 200;
    static final int MOTOR_PULSE_TIME = 20;
    static final int MOTOR_PULSE_MAX = 1000;
    boolean motor;
    boolean direction;
    Timer timerPowerOn = null;
    Timer timerPowerOff = null;
    Timer timerPulse = null;

    public DiseqcMotor() {
        super("Motor");
        Hashtable<Integer, JLabel> d = new Hashtable<Integer, JLabel>();
        for (int i = 1; i < 4; ++i) {
            d.put(-i * 30, new JLabel(i * 30 + "W"));
            d.put(i * 30, new JLabel(i * 30 + "E"));
        }
        d.put(0, new JLabel("000"));
        JFactory.setDimensionToMax(this.ledEst, this.ledWest, this.ledPower, this.ledStatus);
        this.slider = new JSlider(-90, 90, 0);
        this.slider.setMajorTickSpacing(30);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setEnabled(false);
        this.slider.setLabelTable(d);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.motor = false;
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(128, this);
        cpu.addIOWriteListener(144, this);
        this.timerPowerOff = new Timer((int)(200L * cpu.getCycleMillis()), false, new TimerListener(){

            @Override
            public void timerExpired() {
                DiseqcMotor.this.MotorOff();
            }
        });
        this.timerPowerOn = new Timer((int)(200L * cpu.getCycleMillis()), false, new TimerListener(){

            @Override
            public void timerExpired() {
                DiseqcMotor.this.MotorOn();
            }
        });
        this.timerPulse = new Timer((int)(20L * cpu.getCycleMillis()), true, new TimerListener(){

            @Override
            public void timerExpired() {
                DiseqcMotor.this.MotorPulse();
            }
        });
    }

    private void setP1(int v) {
        this.ledEst.set((v & 0x80) != 0);
        this.ledWest.set((v & 0x40) != 0);
    }

    private void setP0(int v) {
        boolean newMotor;
        boolean bl = newMotor = (v & 8) == 0;
        if (newMotor && !this.motor) {
            this.cpu.addTimerCycle(this.timerPowerOn);
        } else if (!newMotor && this.motor) {
            this.cpu.addTimerCycle(this.timerPowerOff);
        }
        this.direction = (v & 0x10) != 0;
        this.motor = newMotor;
        this.ledStatus.set((v & 4) == 0);
        this.ledPower.set((v & 8) == 0);
    }

    public void MotorOff() {
        log.fine("Motor OFF");
        this.timerPulse.cancel();
    }

    public void MotorOn() {
        log.fine("Motor ON");
        this.cpu.addTimerCycle(this.timerPulse);
    }

    private void MotorPulse() {
        try {
            if (this.direction) {
                if (this.position < 1000) {
                    ++this.position;
                    this.updatePosition();
                    ((MCS51)this.cpu).cplBit(148);
                }
            } else if (this.position > -1000) {
                --this.position;
                this.updatePosition();
                ((MCS51)this.cpu).cplBit(148);
            }
        }
        catch (Exception e) {
            log.info(e);
        }
    }

    @Override
    public void writeMemory(Memory m, int a, int v, int oldValue) throws SIMException {
        if (a == 128) {
            this.setP0(v);
        } else if (a == 144) {
            this.setP1(v);
        }
    }

    void updatePosition() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int value = 90 * DiseqcMotor.this.position / 1000;
                DiseqcMotor.this.slider.setValue(-value);
            }
        });
    }

    public void setPosition(int position) {
        this.position = position;
        this.updatePosition();
    }

    @Override
    public JComponent getComponent() {
        if (this.p == null) {
            this.p = new JPanel(new GridBagLayout());
            GridBagConstraints g = new GridBagConstraints();
            g.gridx = 0;
            g.gridy = 0;
            g.gridwidth = 1;
            g.gridheight = 1;
            g.fill = 1;
            g.insets = new Insets(2, 2, 2, 2);
            g.anchor = 10;
            g.weightx = 1.0;
            g.gridwidth = 4;
            this.p.add((Component)this.slider, g);
            ++g.gridy;
            g.gridwidth = 1;
            g.gridx = 0;
            this.p.add((Component)this.ledWest, g);
            ++g.gridx;
            this.p.add((Component)this.ledEst, g);
            ++g.gridx;
            this.p.add((Component)this.ledPower, g);
            ++g.gridx;
            this.p.add((Component)this.ledStatus, g);
            ++g.gridx;
            g.gridx = 0;
            ++g.gridy;
            g.gridwidth = 2;
            this.p.add((Component)this.bWest, g);
            g.gridx += 2;
            this.p.add((Component)this.bEst, g);
            JTextField diseqc = new JTextField(20);
            Util.setTitle(diseqc, "Diseqc Command");
            ++g.gridy;
            g.gridx = 0;
            g.gridx = 0;
            g.gridwidth = 4;
            this.bEst.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent av) {
                    try {
                        if (DiseqcMotor.this.bEst.isSelected()) {
                            ((MCS51)DiseqcMotor.this.cpu).sfrReset(128, 1);
                        } else {
                            ((MCS51)DiseqcMotor.this.cpu).sfrSet(128, 1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.bWest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent av) {
                    try {
                        if (DiseqcMotor.this.bWest.isSelected()) {
                            ((MCS51)DiseqcMotor.this.cpu).sfrReset(128, 2);
                        } else {
                            ((MCS51)DiseqcMotor.this.cpu).sfrSet(128, 2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.p;
    }
}

