/*
 * Decompiled with CFR 0.152.
 */
package jmce.yaze;

import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.cpm.DPBYAHD;
import jmce.sim.disk.AbstractDiskController;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.yaze.YazeConstants;

public class FDC
extends AbstractDiskController
implements YazeConstants,
MemoryReadListener,
MemoryWriteListener {
    private static Logger log = Logger.getLogger(FDC.class);
    private boolean commandInProcess = false;
    protected int commandResult = 0;
    private int dma = 0;

    public FDC() {
        this.setName("Yaze FDC");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOReadListener(15, this);
        cpu.addIOWriteListener(10, this);
        cpu.addIOWriteListener(14, this);
        cpu.addIOWriteListener(11, this);
        cpu.addIOWriteListener(12, this);
        cpu.addIOWriteListener(13, this);
        cpu.addIOWriteListener(16, this);
        cpu.addIOWriteListener(17, this);
    }

    protected void setDma(int dma) {
        this.dma = dma;
    }

    private void diskio(int cmd) throws SIMException {
        this.commandInProcess = true;
        this.commandResult = 1;
        if (this.drive < 0 || this.drive >= this.getHardwareCount()) {
            log.info("Disk not found");
            return;
        }
        byte[] buffer = this.disk.getBuffer();
        switch (cmd) {
            case 0: {
                this.cpu.setStatusLine('R');
                if (this.disk.read() != buffer.length) {
                    return;
                }
                for (int i = 0; i < buffer.length; ++i) {
                    this.cpu.setByte(this.dma + i, buffer[i] & 0xFF);
                }
                break;
            }
            case 1: {
                int i;
                this.cpu.setStatusLine('W');
                for (i = 0; i < buffer.length; ++i) {
                    buffer[i] = (byte)this.cpu.getByte(this.dma + i);
                }
                i = this.disk.write();
                if (i == buffer.length) break;
                return;
            }
            default: {
                return;
            }
        }
        this.commandResult = 0;
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        this.setLive();
        if (this.commandInProcess) {
            this.commandInProcess = false;
            return this.commandResult;
        }
        if (this.drive < 0 || this.drive >= this.getDiskCount()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.setLive();
        switch (address) {
            case 10: {
                this.setDrive(value);
                break;
            }
            case 13: {
                this.disk.setSector(value);
                break;
            }
            case 11: {
                int t = this.disk.getTrack() & 0xFF00;
                this.disk.setTrack(t | value);
                break;
            }
            case 12: {
                int t = this.disk.getTrack() & 0xFF;
                this.disk.setTrack(t | value << 8);
                break;
            }
            case 17: {
                this.dma &= 0xFF;
                this.dma |= value << 8;
                this.setDma(this.dma);
                break;
            }
            case 16: {
                this.dma &= 0xFF00;
                this.dma |= value;
                this.setDma(this.dma);
                break;
            }
            case 14: {
                this.diskio(value);
            }
        }
    }

    void addImageDiskYazeHD(String name) {
        this.addImageDisk(name, new DPBYAHD());
    }

    void addDirDiskYazeHD(String name) {
        this.addDirDiskCPM(name, new DPBYAHD());
    }

    @Override
    public String toString() {
        return "Yaze FDC AT 0x" + Hex.formatByte(10);
    }
}

