/*
 * Decompiled with CFR 0.152.
 */
package jmce.z80pack;

import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.Serial;
import jmce.util.Hex;

public class Network
extends Serial
implements MemoryReadListener,
MemoryWriteListener {
    private int base;

    public Network() {
        this.setName("Network");
        this.setBase(255);
    }

    public Network(String name, int base) {
        this.setName(name);
        this.setBase(base);
    }

    public void setBase(int base) {
        this.base = base;
    }

    public int getBase() {
        return this.base;
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(this.base + 1, this);
        cpu.addIOReadListener(this.base + 0, this);
        cpu.addIOReadListener(this.base + 1, this);
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        value = 0;
        if (address == this.base + 0) {
            this.setIdle();
            if (this.readyRead()) {
                value |= 1;
            }
            if (this.readyWrite()) {
                value |= 2;
            }
        } else if (address == this.base + 1) {
            this.setLive();
            value = (Integer)this.read();
            this.cpu.setStatusLine('r');
        }
        return value;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.setLive();
        this.write(value);
        this.cpu.setStatusLine('w');
    }

    @Override
    public String toString() {
        return "Network at 0x" + Hex.formatByte(this.base);
    }
}

