/*
 * Decompiled with CFR 0.152.
 */
package jmce.z80pack;

import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.Serial;
import jmce.z80pack.Z80PackConstants;

public class Printer
extends Serial
implements Z80PackConstants,
MemoryReadListener,
MemoryWriteListener {
    public Printer() {
        this.setName("Z80pack printer");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(3, this);
        cpu.addIOReadListener(2, this);
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        this.setIdle();
        return this.readyWrite() ? 255 : 0;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.setLive();
        this.cpu.setStatusLine('P');
        this.write(value);
    }

    @Override
    public String toString() {
        return "Z80Pack printer STATUS=2 DATA=3";
    }
}

