/*
 * Decompiled with CFR 0.152.
 */
package jmce.z80pack;

import jmce.sim.SIMException;
import jmce.sim.Serial;
import jmce.sim.SysKit;
import jmce.sim.disk.BootLoader;
import jmce.sim.serial.SerialFile;
import jmce.sim.serial.TCPClient;
import jmce.sim.serial.TCPServer;
import jmce.sim.terminal.Terminal;
import jmce.z80pack.Console;
import jmce.z80pack.Delay;
import jmce.z80pack.FDC;
import jmce.z80pack.Memory;
import jmce.z80pack.Network;
import jmce.z80pack.Printer;
import jmce.z80pack.Timer;
import jmce.z80pack.Z80PackConstants;
import jmce.zilog.z80.Z80;

public class Z80Pack
extends Z80
implements Z80PackConstants {
    @Override
    protected void initMemories() {
        jmce.sim.Memory m = this.getMemoryForName("MEMORY");
        if (m == null) {
            this.addHardware(new Memory());
        }
        super.initMemories();
    }

    @Override
    protected void initPeripherals() throws SIMException {
        Serial s;
        if (this.getHardware((Class)Console.class) == null) {
            Console c = new Console();
            Terminal t = Terminal.createTerminal();
            c.addHardware(t);
            c.setConnected(t);
            this.addHardware(c);
        }
        if (this.getHardware((Class)FDC.class) == null) {
            FDC fdc = new FDC();
            fdc.addImageDiskIBM3740("z80pack/disks/library/cpm3-1.dsk");
            fdc.addImageDiskIBM3740("z80pack/disks/library/cpm3-2.dsk");
            fdc.addDirDiskIBM3740("disks/fd1");
            fdc.addDirDiskIBM3740("disks/fd2");
            fdc.addNullDisk();
            fdc.addNullDisk();
            fdc.addNullDisk();
            fdc.addNullDisk();
            fdc.addImageDiskZ80PackHD("z80pack/disks/library/hd-work.dsk");
            fdc.addDirDiskZ80PackHD("disks/hd");
            fdc.addNullDisk();
            fdc.addNullDisk();
            fdc.addNullDisk();
            fdc.addNullDisk();
            fdc.addNullDisk();
            fdc.addNullDisk();
            this.addHardware(fdc);
        }
        if (this.getHardware((Class)BootLoader.class) == null) {
            this.addHardware(new BootLoader());
        }
        if (this.getHardware((Class)Timer.class) == null) {
            this.addHardware(new Timer());
        }
        if (this.getHardware((Class)Delay.class) == null) {
            this.addHardware(new Delay());
        }
        if (this.getHardware((Class)Network.class) == null) {
            Network n = new Network("Network # 1", 40);
            s = new TCPServer(4040);
            n.addHardware(s);
            n.setConnected(s);
            this.addHardware(n);
            n = new Network("Network # 2", 42);
            s = new TCPServer(4042);
            n.addHardware(s);
            n.setConnected(s);
            this.addHardware(n);
            n = new Network("Network # 3", 44);
            s = new TCPServer(4044);
            n.addHardware(s);
            n.setConnected(s);
            this.addHardware(n);
            n = new Network("Network # 4", 46);
            s = new TCPServer(4046);
            n.addHardware(s);
            n.setConnected(s);
            this.addHardware(n);
            n = new Network("Network # 5", 50);
            s = new TCPClient(4002);
            n.addHardware(s);
            n.setConnected(s);
            this.addHardware(n);
        }
        if (this.getHardware((Class)Printer.class) == null) {
            Printer p = new Printer();
            s = new SerialFile("printer.txt");
            p.addHardware(s);
            p.setConnected(s);
            this.addHardware(p);
        }
        if (this.getHardware((Class)SysKit.class) == null) {
            this.addHardware(new SysKit());
        }
    }
}

