/*
 * Decompiled with CFR 0.152.
 */
package jmce.zilog.z80;

import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.CycleListener;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.zilog.z80.INTZ80;
import jmce.zilog.z80.Z80;

public class CTC
extends AbstractPeripheral
implements ResetListener,
MemoryReadListener,
MemoryWriteListener,
CycleListener {
    private static Logger log = Logger.getLogger(CTC.class);
    public static final int CTC_CHANNEL = 4;
    public static final int CW_IE = 128;
    public static final int CW_VECTOR = 1;
    public static final int CW_RESET = 2;
    private int base = 0;
    private INTZ80[] irq = new INTZ80[4];
    private Z80 z80;
    private int[] counter = new int[4];
    private int[] time = new int[4];
    private int[] prescaler = new int[4];
    private int[] cw = new int[4];
    private int[] clock = new int[4];
    private boolean[] waitTime = new boolean[4];

    public CTC() {
        super("CTC");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        this.z80 = (Z80)cpu;
        this.z80.addResetListener(this);
        this.z80.addCycleListener(this);
        for (int i = 0; i < 4; ++i) {
            this.irq[i] = new INTZ80(this.z80, "CTC" + i);
            this.irq[i].setAutoReset(true);
            this.z80.addIOWriteListener(this.base + i, this);
            this.z80.addIOReadListener(this.base + i, this);
        }
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        for (int i = 0; i < 4; ++i) {
            this.reset(i);
        }
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        int ch = address - this.base;
        value = this.counter[ch];
        log.fine("CTC RD=" + Hex.formatByte(value) + " AT " + ch + " = " + value);
        return value;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        int ch = address - this.base;
        log.fine("CTC WR=" + Hex.formatByte(value) + " AT " + ch);
        if (this.waitTime[ch]) {
            this.waitTime[ch] = false;
            this.counter[ch] = this.time[ch] = value;
            return;
        }
        if ((value & 1) == 0) {
            log.fine("Vector=" + (value & 0xF8));
            for (int i = 0; i < 4; ++i) {
                this.irq[i].setVector(value & 0xF8 | i << 1);
            }
            return;
        }
        this.cw[ch] = value;
        if ((value & 2) != 0) {
            this.reset(ch);
        }
        this.prescaler[ch] = (value & 0x40) != 0 ? 1 : ((value & 0x20) == 0 ? 16 : 256);
        if ((value & 4) != 0) {
            this.waitTime[ch] = true;
        }
    }

    private final void clock(int i, int n) throws SIMException {
        if (this.waitTime[i]) {
            return;
        }
        int n2 = i;
        this.clock[n2] = this.clock[n2] + n;
        while (this.clock[i] > this.prescaler[i]) {
            int n3 = i;
            this.clock[n3] = this.clock[n3] - this.prescaler[i];
            this.counter[i] = this.counter[i] - 1 & 0xFF;
            if (this.counter[i] != 0) continue;
            if ((this.cw[i] & 0x80) != 0) {
                log.fine("CH=" + i + " IRQ " + this.irq[i].toString());
                this.irq[i].setActive(true);
            }
            this.counter[i] = this.time[i];
        }
    }

    public final void count(int i, int n) throws SIMException {
        if ((this.cw[i] & 0x40) == 0) {
            return;
        }
        this.clock(i, n);
    }

    @Override
    public final void cycle(int n) throws SIMException {
        for (int i = 0; i < 4; ++i) {
            if ((this.cw[i] & 0x48) != 0) continue;
            this.clock(i, n);
        }
    }

    public void reset(int ch) {
        this.cw[ch] = 0;
        this.time[ch] = 0;
        this.counter[ch] = 0;
        this.prescaler[ch] = 16;
        this.waitTime[ch] = false;
        this.clock[ch] = 0;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public int getBase() {
        return this.base;
    }

    @Override
    public String toString() {
        return "Z80 CTC AT " + Hex.formatByte(this.base);
    }
}

