/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jmce.Jmce;
import jmce.Property;
import jmce.sim.CPU;
import jmce.sim.ExceptionEvent;
import jmce.sim.LoadInfo;
import jmce.sim.Tape;
import jmce.sim.TapeEventListener;
import jmce.sim.TapePulse;
import jmce.sim.cpu.AbstractCPU;
import jmce.sim.tape.TapeData;
import jmce.sim.tape.TapeFile;
import jmce.swing.SwingThread;
import jmce.swing.Util;
import jmce.util.Logger;

public class ApplicationFrame
extends JFrame
implements TapeEventListener {
    private static final long serialVersionUID = 1L;
    protected AbstractCPU cpu;
    private TapeFile tape = null;
    protected JFileChooser fc = null;
    private JProgressBar tapeBar = new JProgressBar();
    private JLabel usage = new JLabel("100.00%");
    private boolean restoreRealTime = false;
    protected AbstractAction actionTapeLoad;
    protected AbstractAction actionTapeListen;
    protected AbstractAction actionTapePlay;
    protected AbstractAction actionTapeFast;
    protected AbstractAction actionTapeStop;
    protected AbstractAction actionFileLoad;
    protected AbstractAction actionFileExit;

    public ApplicationFrame(CPU _cpu) {
        this.cpu = (AbstractCPU)_cpu;
        this.fc = new JFileChooser();
        String cd = Property.getProperty("file.directory", ".");
        this.fc.setCurrentDirectory(new File(cd));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ApplicationFrame.this.performExit();
            }
        });
    }

    protected void performLoad() {
        try {
            if (this.fc.showOpenDialog(this) == 0) {
                LoadInfo info = new LoadInfo();
                this.cpu.load(this.fc.getSelectedFile().getCanonicalPath(), 0, info);
                this.showMessage("File :" + this.fc.getSelectedFile(), "Loaded : " + info);
                Property.setProperty("file.directory", this.fc.getCurrentDirectory().getPath());
            }
        }
        catch (Throwable ex) {
            this.showError(ex);
        }
    }

    protected final void performExit() {
        this.setVisible(false);
        this.cpu.stop();
        try {
            this.cpu.destroy();
            System.exit(0);
        }
        catch (Exception ex) {
            Logger.writeEx(ex);
            System.exit(0);
        }
    }

    private final void performTapeListen() throws Exception {
        int sample = 44100;
        int wavLow = 103;
        int wavHigh = -103;
        this.tape.play();
        SwingThread w = new SwingThread(this, "Listen cassette file", this.tape.getConfig()){
            private static final long serialVersionUID = 1L;

            @Override
            public void doWork() throws Exception {
                TapePulse tp;
                TapeData data = ApplicationFrame.this.tape.getTapeData();
                if (data == null) {
                    throw new Exception("No file loaded");
                }
                this.setMaximum(ApplicationFrame.this.tape.getNumTapeData());
                AudioFormat fmt = new AudioFormat(44100.0f, 8, 1, false, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, fmt);
                SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(fmt);
                line.start();
                byte[] buffer = new byte[1024];
                int bufferLen = 0;
                int wav = 103;
                while ((tp = ApplicationFrame.this.tape.nextPulse()) != null && !this.isCancelled()) {
                    this.setValue(ApplicationFrame.this.tape.getCurrentTapeData());
                    int n = (int)(0.5 + 44100.0 / (double)data.getClock() * (double)tp.getWidth());
                    for (int i = 0; i < n; ++i) {
                        buffer[bufferLen++] = wav;
                        if (bufferLen < buffer.length) continue;
                        line.write(buffer, 0, bufferLen);
                        bufferLen = 0;
                    }
                    switch (tp.getType()) {
                        case 1: {
                            wav = 103;
                            break;
                        }
                        case 2: {
                            wav = -103;
                            break;
                        }
                        case 3: {
                            wav = wav == 103 ? -103 : 103;
                        }
                    }
                }
                line.close();
            }
        };
        w.start();
        this.tape.stop();
        if (w.getException() != null) {
            this.showError(w.getException());
        }
    }

    private final void performTapeLoad() {
        try {
            if (this.fc.showOpenDialog(this) == 0) {
                String name = this.fc.getSelectedFile().getCanonicalPath();
                this.tape.setConfig(name);
            }
        }
        catch (Throwable ex) {
            this.showError(ex);
        }
    }

    private final void performTapePlay() {
        try {
            this.tapeBar.setStringPainted(false);
            this.tapeBar.setIndeterminate(true);
            this.tape.play();
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    private final void performTapeStop() {
        try {
            this.tape.stop();
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    protected final void addIcon(Action action, String name) {
        Icon icon = Util.getIcon(this.getClass(), name);
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    protected final void addKey(JMenuItem item, char m) {
        item.setMnemonic(m);
        item.setAccelerator(KeyStroke.getKeyStroke((int)m, 8));
    }

    protected JMenu createMenuFile() {
        this.actionFileLoad = new AbstractAction("Load"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.performLoad();
            }
        };
        this.actionFileExit = new AbstractAction("Exit"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.performExit();
            }
        };
        this.addIcon(this.actionFileLoad, "load.gif");
        this.addIcon(this.actionFileExit, "exit.gif");
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menu.setIcon(Util.getIcon(this.getClass(), "file.gif"));
        this.addKey(menu.add(this.actionFileLoad), 'L');
        this.addKey(menu.add(this.actionFileExit), 'X');
        return menu;
    }

    protected JMenu createMenuTape() {
        this.tape = (TapeFile)this.cpu.getHardware((Class)TapeFile.class);
        if (this.tape == null) {
            return null;
        }
        this.actionTapePlay = new AbstractAction("Play"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.performTapePlay();
            }
        };
        this.actionTapeLoad = new AbstractAction("Load"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.performTapeLoad();
            }
        };
        this.actionTapeStop = new AbstractAction("Stop"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.performTapeStop();
            }
        };
        this.actionTapeFast = new AbstractAction("Fast play"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.restoreRealTime = true;
                ApplicationFrame.this.cpu.setRealTime(false);
                ApplicationFrame.this.performTapePlay();
            }
        };
        this.actionTapeListen = new AbstractAction("Listen"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ApplicationFrame.this.performTapeListen();
                }
                catch (Exception ex) {
                    ApplicationFrame.this.showError(ex);
                }
            }
        };
        JMenu menu = new JMenu("Tape");
        menu.setMnemonic('E');
        menu.setIcon(Util.getIcon(this.getClass(), "cassette.png"));
        this.addKey(menu.add(this.actionTapeLoad), 'L');
        this.addKey(menu.add(this.actionTapePlay), 'P');
        this.addKey(menu.add(this.actionTapeFast), 'F');
        this.addKey(menu.add(this.actionTapeStop), 'S');
        this.addKey(menu.add(this.actionTapeListen), 'K');
        this.tapeBar.setStringPainted(false);
        this.tapeBar.setIndeterminate(true);
        this.tape.addTapeEventListener(this);
        this.tapeStop(this.tape);
        return menu;
    }

    protected void showMessage(String title, String msg) {
        JOptionPane.showMessageDialog(this, msg, title, 1);
    }

    void showError(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Error JMCE Ver. " + Jmce.versionNumber, 0);
    }

    void showError(ExceptionEvent e) {
        this.showError(e.ex);
    }

    void showError(Throwable e) {
        String s = e.toString();
        if (s == null || s.length() == 0) {
            s = e.toString();
        }
        this.showError(s);
    }

    @Override
    public void tapeStop(Tape tape) {
        this.actionTapeListen.setEnabled(true);
        this.actionTapeFast.setEnabled(true);
        this.actionTapePlay.setEnabled(true);
        this.actionTapeStop.setEnabled(false);
        this.actionTapeLoad.setEnabled(true);
        if (this.restoreRealTime) {
            this.restoreRealTime = false;
            this.cpu.setRealTime(true);
        }
    }

    @Override
    public void tapePlay(Tape tape) {
        this.actionTapeFast.setEnabled(false);
        this.actionTapeListen.setEnabled(false);
        this.actionTapePlay.setEnabled(false);
        this.actionTapeStop.setEnabled(true);
        this.actionTapeLoad.setEnabled(false);
    }

    @Override
    public void tapeRec(Tape tape) {
    }

    @Override
    public void tapePower(Tape tape) {
    }

    protected final JToolBar createToolBar() {
        JToolBar p = new JToolBar();
        this.usage.setFont(new Font("Monospaced", 1, 20));
        this.usage.setForeground(Color.yellow);
        this.usage.setBackground(Color.black);
        this.usage.setOpaque(true);
        p.add(new JLabel(Util.getIcon(this.getClass(), "Cpu.gif")));
        p.add(this.usage);
        if (this.tape != null) {
            p.add(new JToolBar.Separator());
            p.add(new JLabel(Util.getIcon(this.getClass(), "cassette.png")));
            p.add(this.tapeBar);
        }
        return p;
    }

    protected void swingTimer() {
        if (this.cpu.isRunning()) {
            double d = this.cpu.getUsage();
            this.usage.setForeground(Color.white);
            if (d > 90.0) {
                this.usage.setForeground(Color.red);
            } else if (d > 50.0) {
                this.usage.setForeground(Color.yellow);
            } else if (d > 25.0) {
                this.usage.setForeground(Color.green);
            } else if (d > 10.0) {
                this.usage.setForeground(Color.cyan);
            }
            String s = d + "%";
            while (s.length() < 7) {
                s = " " + s;
            }
            this.usage.setText(s);
        }
        if (this.tape != null && this.tape.isPlay()) {
            if (this.tapeBar.isIndeterminate()) {
                this.tapeBar.setIndeterminate(false);
                this.tapeBar.setMaximum(this.tape.getNumTapeData());
                this.tapeBar.setStringPainted(true);
            }
            this.tapeBar.setValue(this.tape.getCurrentTapeData());
        }
    }

    protected void setEmulation(boolean e) {
        if (this.actionFileLoad != null) {
            this.actionFileLoad.setEnabled(!e);
        }
    }
}

