/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import jmce.Command;
import jmce.Monitor;
import jmce.StringToken;
import jmce.sim.Memory;
import jmce.util.Hex;

class CommandExamine
extends Command {
    int address = 0;

    CommandExamine(Monitor m) {
        super(m, "examine\t[mem] add", "Examine / change memory");
    }

    @Override
    public void exec(StringToken st) throws Exception {
        this.monitor.checkCPU();
        Memory m = this.monitor.cpu.getMemoryAt(0);
        if (st.getTokenCount() > 2) {
            m = this.monitor.getArgMemory(st, 1);
            this.address = this.getHexNumber(st, 2);
        } else if (st.getTokenCount() > 1) {
            this.address = this.getHexNumber(st, 1);
        }
        this.println("Examine :" + m.getName() + " at " + Hex.formatWord(this.address));
        while (true) {
            int v;
            StringBuffer line = new StringBuffer();
            this.print(Hex.formatWord(this.address) + " " + Hex.formatByte(m.getMemory(this.address)));
            this.getLine(" ", line);
            if (line.length() == 0) {
                ++this.address;
                continue;
            }
            st = new StringToken(line.toString());
            if (st.getTokenAt(0).charAt(0) == '.') {
                return;
            }
            try {
                v = this.getHexNumber(st, 0);
            }
            catch (Exception ex) {
                this.println(ex);
                continue;
            }
            m.setMemory(this.address, v);
            this.println(Hex.formatWord(this.address) + " ==> " + Hex.formatByte(m.getMemory(this.address)));
            ++this.address;
        }
    }
}

