/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.Timer;
import jmce.ApplicationFrame;
import jmce.sim.CPU;
import jmce.sim.ExceptionEvent;
import jmce.sim.ExceptionListener;
import jmce.sim.TapeEventListener;
import jmce.swing.Util;

public class JMonitor
extends ApplicationFrame
implements ExceptionListener,
TapeEventListener {
    private static final long serialVersionUID = 1L;
    private AbstractAction actionToolsStop;
    private AbstractAction actionToolsGo;
    private AbstractAction actionToolsReset;

    public JMonitor(CPU _cpu, JComponent frame) {
        super(_cpu);
        this.createActions();
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)frame, "Center");
        if (this.cpu != null && this.cpu.getExceptionListenerCount() == 0) {
            this.cpu.addExceptionListener(this);
            this.createMenuBar();
            this.setEmulation(true);
            Timer t = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMonitor.this.swingTimer();
                }
            });
            t.setRepeats(true);
            t.start();
            p.add((Component)this.createToolBar(), "First");
        }
        this.setContentPane(p);
    }

    @Override
    protected void setEmulation(boolean e) {
        super.setEmulation(e);
        this.actionToolsStop.setEnabled(e);
        this.actionToolsGo.setEnabled(!e);
        this.actionToolsReset.setEnabled(!e);
    }

    private void performStart() {
        this.cpu.start();
        this.setEmulation(true);
    }

    JButton addToBar(JToolBar bar, Action action) {
        action.putValue("MnemonicKey", null);
        JButton b = bar.add(action);
        String s = (String)action.getValue("Name");
        if (s != null) {
            b.setToolTipText(s);
        }
        return b;
    }

    public void createMenuBar() {
        JMenuBar bar = new JMenuBar();
        bar.add(this.createMenuFile());
        bar.add(this.createMenuTools());
        JMenu m = this.createMenuTape();
        if (m != null) {
            bar.add(m);
        }
        this.setJMenuBar(bar);
    }

    JMenu createMenuTools() {
        JMenu menu = new JMenu("Tools");
        menu.setMnemonic('T');
        menu.setIcon(Util.getIcon(this.getClass(), "Cpu.gif"));
        this.addKey(menu.add(this.actionToolsGo), 'G');
        this.addKey(menu.add(this.actionToolsStop), 'S');
        this.addKey(menu.add(this.actionToolsReset), 'R');
        return menu;
    }

    protected void createActions() {
        this.actionToolsStop = new AbstractAction("Stop"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JMonitor.this.performStop();
            }
        };
        this.actionToolsGo = new AbstractAction("Go"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JMonitor.this.performStart();
            }
        };
        this.actionToolsReset = new AbstractAction("Reset"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JMonitor.this.performReset();
            }
        };
        this.addIcon(this.actionToolsGo, "play.gif");
        this.addIcon(this.actionToolsStop, "stop.gif");
        this.addIcon(this.actionToolsReset, "reset.gif");
    }

    public boolean isRunning() {
        return this.cpu.isRunning();
    }

    void performStop() {
        this.cpu.stop();
        this.setEmulation(false);
    }

    void performReset() {
    }

    @Override
    public void exceptionEvent(ExceptionEvent ev) {
        if (this.isVisible()) {
            this.showError(ev);
        }
        this.setEmulation(this.cpu.isRunning());
    }
}

