/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import jmce.PanelDebug;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.swing.KHexField;
import jmce.swing.KMemoryChoice;

class PanelMemory
extends PanelDebug {
    private static final long serialVersionUID = 1L;
    public static final int NROW = 8;
    public static final int NCOL = 16;
    KHexField[][] data = new KHexField[8][16];
    KHexField[] address = new KHexField[8];
    KMemoryChoice memories;
    KHexField start = new KHexField(32);

    public PanelMemory(String title, CPU _cpu) {
        super(title, _cpu);
        int c;
        int r;
        this.memories = new KMemoryChoice(this.cpu);
        for (r = 0; r < 8; ++r) {
            this.address[r] = new KHexField(32);
            this.address[r].setText("********");
            for (c = 0; c < 16; ++c) {
                this.data[r][c] = new KHexField(8);
                this.data[r][c].setText("**");
            }
        }
        this.g.anchor = 10;
        this.g.gridwidth = 3;
        this.add((Component)new JLabel("Start"), this.g);
        this.g.gridx += this.g.gridwidth;
        this.g.gridwidth = 5;
        this.add((Component)this.start, this.g);
        this.g.gridx += this.g.gridwidth;
        this.g.gridwidth = 3;
        this.add((Component)new JLabel(" Memory"), this.g);
        this.g.gridx += this.g.gridwidth;
        this.g.gridwidth = 6;
        this.add((Component)this.memories, this.g);
        this.g.gridwidth = 1;
        this.g.gridx = 0;
        ++this.g.gridy;
        for (r = 0; r < 8; ++r) {
            this.add((Component)this.address[r], this.g);
            ++this.g.gridx;
            this.add((Component)new JLabel(" "), this.g);
            ++this.g.gridx;
            for (c = 0; c < 16; ++c) {
                this.add((Component)this.data[r][c], this.g);
                ++this.g.gridx;
                if (c != 7) continue;
                this.add((Component)new JLabel(" - "), this.g);
                ++this.g.gridx;
            }
            this.g.gridx = 0;
            ++this.g.gridy;
        }
        ActionListener updateMemory = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PanelMemory.this.update(PanelMemory.this.cpu);
            }
        };
        this.memories.addActionListener(updateMemory);
        this.start.addActionListener(updateMemory);
        this.start.setEditable(true);
        this.start.setValue(0);
        this.start.setValue(0);
    }

    void setStart(int a) {
        this.start.setValue(a);
        this.update(this.cpu);
    }

    @Override
    public void update(CPU cpu) {
        int a = this.start.getValue();
        Memory m = this.memories.getMemory();
        for (int r = 0; r < 8; ++r) {
            if (a >= m.getSize()) {
                this.address[r].setText("--------");
            } else {
                this.address[r].setValue(a);
            }
            for (int c = 0; c < 16; ++c) {
                if (a >= m.getSize()) {
                    this.data[r][c].setText("--");
                    continue;
                }
                try {
                    this.data[r][c].setValue(m.getMemory(a));
                    ++a;
                    continue;
                }
                catch (Exception ex) {
                    this.data[r][c].setText("??");
                }
            }
        }
    }
}

