/*
 * Decompiled with CFR 0.152.
 */
package jmce.altair;

import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.Serial;

public class Console
extends Serial
implements MemoryReadListener,
MemoryWriteListener {
    public Console() {
        this.setName("Altair Console");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(17, this);
        cpu.addIOReadListener(16, this);
        cpu.addIOReadListener(17, this);
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        switch (address) {
            case 16: {
                this.setIdle();
                value = 0;
                if (this.readyRead()) {
                    value |= 1;
                }
                if (this.readyWrite()) {
                    value |= 2;
                }
                return value;
            }
            case 17: {
                this.setLive();
                return (Integer)this.read();
            }
        }
        return 0;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        switch (address) {
            case 17: {
                this.setLive();
                this.write(value);
            }
        }
    }
}

