/*
 * Decompiled with CFR 0.152.
 */
package jmce.altair;

import jmce.altair.AltairConstants;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.disk.AbstractDiskController;
import jmce.sim.disk.ImageDisk;
import jmce.util.Hex;
import jmce.util.Logger;

public class FDC
extends AbstractDiskController
implements MemoryReadListener,
MemoryWriteListener,
AltairConstants {
    private int status = 255;
    private boolean sectorReady = false;
    private int counter = -1;
    private static Logger log = Logger.getLogger(FDC.class);

    public FDC() {
        this.setName("Altair 8800 FDC");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOReadListener(8, this);
        cpu.addIOReadListener(9, this);
        cpu.addIOReadListener(10, this);
        cpu.addIOWriteListener(8, this);
        cpu.addIOWriteListener(9, this);
        cpu.addIOWriteListener(10, this);
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        this.setLive();
        switch (address) {
            case 8: {
                value = this.status;
                if (this.disk.getTrack() == 0) {
                    value &= 0xFFFFFFBF;
                    break;
                }
                value |= 0x40;
                break;
            }
            case 9: {
                if (this.sectorReady) {
                    int s = this.disk.getSector();
                    if (++s > this.disk.getNumSector()) {
                        s = 1;
                    }
                    log.fine("Set sector to " + s);
                    this.disk.setSector(s);
                    this.counter = -1;
                }
                value = this.disk.getSector() - 1 << 1;
                boolean bl = this.sectorReady = !this.sectorReady;
                if (!this.sectorReady) break;
                value |= 1;
                break;
            }
            case 10: {
                this.cpu.setStatusLine('R');
                if (this.counter == -1) {
                    log.fine("Read T=" + this.disk.getTrack() + " S=" + this.disk.getSector());
                    this.disk.read();
                    this.counter = 0;
                }
                log.finest("Read byte at " + this.counter);
                value = this.disk.getBuffer()[this.counter] & 0xFF;
                if (++this.counter < this.disk.getSectorSize()) break;
                this.counter = 0;
            }
        }
        log.finer("RD AT " + Hex.formatByte(address) + " = " + Hex.formatByte(value) + " ST=" + Hex.formatByte(this.status));
        return value;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.setLive();
        log.finer("WR " + Hex.formatByte(value) + " AT " + Hex.formatByte(address));
        switch (address) {
            case 8: {
                if ((value & 0x80) == 0) {
                    if ((value &= 0xF) < this.getDiskCount()) {
                        this.setDrive(this.drive);
                        log.fine("Select drive " + this.disk.getName() + "=" + value);
                        this.status = 245;
                        this.sectorReady = false;
                        this.counter = -1;
                        break;
                    }
                    log.info("Invalid drive " + value);
                    this.disk = this.nullDisk;
                    this.status = 255;
                    break;
                }
                log.info("Unselect drive");
                this.status = 255;
                this.disk = this.nullDisk;
                break;
            }
            case 9: {
                int t;
                if (this.disk == this.nullDisk) break;
                if ((value & 4) != 0) {
                    log.fine("Load head");
                    this.status &= 0xFFFFFFFB;
                    this.status &= 0xFFFFFF7F;
                }
                if ((value & 1) != 0) {
                    t = this.disk.getTrack() + 1;
                    if (t >= this.disk.getNumTrack()) {
                        t = this.disk.getNumTrack() - 1;
                    }
                    log.fine("Set track=" + t);
                    this.disk.setTrack(t);
                }
                if ((value & 2) == 0) break;
                t = this.disk.getTrack() - 1;
                if (t < 0) {
                    t = 0;
                }
                this.disk.setTrack(t);
                log.fine("Set track=" + t);
            }
        }
    }

    void addAltairFD(String disk) {
        ImageDisk d = new ImageDisk(disk);
        d.setNumTrack(77);
        d.setNumSector(32);
        d.setSectorSize(137);
        this.addHardware(d);
    }
}

