/*
 * Decompiled with CFR 0.152.
 */
package jmce.atmel;

import jmce.sim.I2cSlave;
import jmce.sim.SIMException;
import jmce.sim.memory.PersistentMemory;
import jmce.util.Hex;
import jmce.util.Logger;

public class AT24C16
extends PersistentMemory
implements I2cSlave {
    private static Logger log = Logger.getLogger(AT24C16.class);
    private int address;

    public AT24C16() {
        super("AT24C16", "AT24C16.eeprom", 2048);
    }

    @Override
    public boolean i2cAddress(int address) {
        return (address & 0xF0) == 160;
    }

    @Override
    public boolean i2cWrite(int count, int value) throws SIMException {
        switch (count) {
            default: {
                log.fine("Write " + Hex.formatByte(value) + " at " + Hex.formatWord(this.address));
                this.setMemory(this.address++, value);
                break;
            }
            case 0: {
                this.address = (value >> 1 & 7) * 256 | this.address & 0xFF;
                break;
            }
            case 1: {
                this.address = this.address & 0xFF00 | value;
            }
        }
        return true;
    }

    @Override
    public int i2cRead(int count) throws SIMException {
        int value = this.getMemory(this.address);
        log.fine("Read " + Hex.formatByte(value) + " at " + Hex.formatWord(this.address));
        ++this.address;
        return value;
    }
}

