/*
 * Decompiled with CFR 0.152.
 */
package jmce.freescale;

import jmce.freescale.M68HC05;
import jmce.freescale.M68HC08Constants;
import jmce.sim.SIMException;
import jmce.sim.cpu.AbstractCPU;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.StandardRegister;

public class M68HC08
extends M68HC05
implements M68HC08Constants {
    private int H;

    public M68HC08() {
        super("M68HC08");
        this.setResetVector(65534);
    }

    @Override
    protected void initRegisters() {
        super.initRegisters();
        this.addRegister(new StandardRegister("H", 10, 8){

            @Override
            public int getRegister() {
                return M68HC08.this.H;
            }

            @Override
            public void setRegister(int value) {
                M68HC08.this.H = value;
            }
        });
    }

    @Override
    protected void initOpcodes() {
        super.initOpcodes();
        this.setOpcode(new AbstractOpcode(148, 1, 2, "TXS"){

            @Override
            public int exec(int pc) throws SIMException {
                M68HC08.this.SP = (M68HC08.this.H << 8 | M68HC08.this.X) - 1;
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(69, 3, 3, "LDHX\t#%word"){

            @Override
            public int exec(int pc) throws SIMException {
                M68HC08.this.H = M68HC08.this.getByte(pc + 1);
                M68HC08.this.X = M68HC08.this.getByte(pc + 2);
                M68HC08.this.ccr(4, AbstractCPU.bit7(M68HC08.this.H));
                M68HC08.this.ccr(2, M68HC08.this.H + M68HC08.this.X == 0);
                return 3;
            }
        });
        this.setOpcode(new AbstractOpcode(85, 2, 4, "LDHX\t%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                int a = M68HC08.this.getWord(M68HC08.this.getByte(pc + 1));
                M68HC08.this.H = M68HC08.this.getByte(a + 0);
                M68HC08.this.X = M68HC08.this.getByte(a + 1);
                M68HC08.this.ccr(4, AbstractCPU.bit7(M68HC08.this.H));
                M68HC08.this.ccr(2, M68HC08.this.H + M68HC08.this.X == 0);
                return 3;
            }
        });
    }
}

