/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.i8080;

import jmce.intel.i8080.I8080Constants;
import jmce.sim.CPU;
import jmce.sim.CpuRuntime;
import jmce.sim.Hardware;
import jmce.sim.Interrupt;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.cpu.AbstractCPU;
import jmce.sim.cpu.AbstractDecoder;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.StandardRegister;
import jmce.sim.memory.PlainMemory;
import jmce.util.Hex;

public class I8080
extends AbstractCPU
implements I8080Constants {
    public int A;
    public int F;
    public int BC;
    public int DE;
    public int HL;
    public int PC;
    public int SP;
    public boolean iff1;
    public boolean iff2;
    protected static final boolean[] parityTable = new boolean[]{true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true};
    private static int[] dec8Table = new int[256];
    private static int[] inc8Table = new int[256];
    private static int[][][] adc8Table = new int[256][256][2];
    private static int[][][] sbc8Table = new int[256][256][2];
    protected static int[] booleanTable = new int[256];
    private int portHI;
    private static final int[] cccFlag;
    private static final int[] cccValue;

    public I8080() {
        this("I8080");
    }

    public I8080(String name) {
        super(name);
        this.setEndian(0);
        this.setClock(2000000L);
        this.setClockPerCycle(1);
    }

    @Override
    public final void setWord(int a, int v) throws SIMException {
        this.memory.setMemory(a + 0, v);
        this.memory.setMemory(a + 1, v >>> 8);
    }

    @Override
    public final int getWord(int a) throws SIMException {
        return this.memory.getMemory(a + 0) | this.memory.getMemory(a + 1) << 8;
    }

    @Override
    public final void pc(int pc) {
        this.PC = pc;
    }

    @Override
    public final int pc() {
        return this.PC;
    }

    protected final boolean FLAG_C() {
        return (this.F & 1) != 0;
    }

    protected final void FLAG_C(boolean value) {
        this.F = value ? (this.F |= 1) : (this.F &= 0xFFFFFFFE);
    }

    protected final boolean FLAG_Z() {
        return (this.F & 0x40) != 0;
    }

    protected final boolean FLAG_V() {
        return (this.F & 4) != 0;
    }

    protected final boolean FLAG_S() {
        return (this.F & 0x80) != 0;
    }

    protected final boolean FLAG_H() {
        return (this.F & 0x10) != 0;
    }

    protected final void FLAG_Z(boolean value) {
        this.F = value ? (this.F |= 0x40) : (this.F &= 0xFFFFFFBF);
    }

    protected final void FLAG_S(boolean value) {
        this.F = value ? (this.F |= 0x80) : (this.F &= 0xFFFFFF7F);
    }

    protected void FLAG_H(boolean value) {
        this.F = value ? (this.F |= 0x10) : (this.F &= 0xFFFFFFEF);
    }

    protected final void FLAG_V(boolean value) {
        this.F = value ? (this.F |= 4) : (this.F &= 0xFFFFFFFB);
    }

    protected final boolean FLAG_N() {
        return (this.F & 2) != 0;
    }

    protected final void FLAG_N(boolean value) {
        this.F = value ? (this.F |= 2) : (this.F &= 0xFFFFFFFD);
    }

    protected final boolean FLAG_3() {
        return (this.F & 8) != 0;
    }

    protected final boolean FLAG_5() {
        return (this.F & 0x20) != 0;
    }

    protected final void FLAG_5(boolean value) {
        this.F = value ? (this.F |= 0x20) : (this.F &= 0xFFFFFFDF);
    }

    protected final void FLAG_3(boolean value) {
        this.F = value ? (this.F |= 8) : (this.F &= 0xFFFFFFF7);
    }

    protected void initMemories() {
        Memory m = this.getMemoryForName("MEMORY");
        if (m == null) {
            m = (Memory)this.addHardware(new PlainMemory("MEMORY", 65536));
        }
        this.setMemory(m);
        m = this.getMemoryForName("IO");
        if (m == null) {
            m = (Memory)this.addHardware(new PlainMemory("IO", 256));
        }
        this.setIO(m);
    }

    protected void initRegisters() {
        this.addRegister(new StandardRegister("PC", 1, 16, 0){

            @Override
            public int getRegister() {
                return I8080.this.PC;
            }

            @Override
            public void setRegister(int value) {
                I8080.this.PC = value;
            }
        });
        this.addRegister(new StandardRegister("SP", 4, 16, 0){

            @Override
            public int getRegister() {
                return I8080.this.SP;
            }

            @Override
            public void setRegister(int value) {
                I8080.this.SP = value;
            }
        });
        this.addRegister(new StandardRegister("A", 2, 8, 0){

            @Override
            public int getRegister() {
                return I8080.this.A;
            }

            @Override
            public void setRegister(int value) {
                I8080.this.A = value;
            }
        });
        this.addRegister(new StandardRegister("F", 6, 8, 0){

            @Override
            public String descValue() {
                String s = "";
                s = s + "[" + Hex.formatByte(I8080.this.F) + "]";
                s = I8080.this.FLAG_S() ? s + "S" : s + "-";
                s = I8080.this.FLAG_Z() ? s + "Z" : s + "-";
                s = I8080.this.FLAG_5() ? s + "5" : s + "-";
                s = I8080.this.FLAG_H() ? s + "H" : s + "-";
                s = I8080.this.FLAG_3() ? s + "3" : s + "-";
                s = I8080.this.FLAG_V() ? s + "P" : s + "-";
                s = I8080.this.FLAG_N() ? s + "N" : s + "-";
                s = I8080.this.FLAG_C() ? s + "C" : s + "-";
                return s;
            }

            @Override
            public int getRegister() {
                return I8080.this.F;
            }

            @Override
            public void setRegister(int value) {
                I8080.this.F = value;
            }
        });
        this.addRegister(new StandardRegister("BC", 10, 16, 0){

            @Override
            public int getRegister() {
                return I8080.this.BC;
            }

            @Override
            public void setRegister(int value) {
                I8080.this.BC = value;
            }
        });
        this.addRegister(new StandardRegister("DE", 10, 16, 0){

            @Override
            public int getRegister() {
                return I8080.this.DE;
            }

            @Override
            public void setRegister(int value) {
                I8080.this.DE = value;
            }
        });
        this.addRegister(new StandardRegister("HL", 10, 16, 0){

            @Override
            public int getRegister() {
                return I8080.this.HL;
            }

            @Override
            public void setRegister(int value) {
                I8080.this.HL = value;
            }
        });
    }

    protected final void h(int v) {
        this.HL = this.HL & 0xFF | v << 8;
    }

    protected final void l(int v) {
        this.HL = this.HL & 0xFF00 | v & 0xFF;
    }

    protected final void b(int v) {
        this.BC = this.BC & 0xFF | v << 8;
    }

    protected final void c(int v) {
        this.BC = this.BC & 0xFF00 | v & 0xFF;
    }

    protected final void d(int v) {
        this.DE = this.DE & 0xFF | v << 8;
    }

    protected final void e(int v) {
        this.DE = this.DE & 0xFF00 | v & 0xFF;
    }

    protected final void f(int value) {
        this.F = value;
    }

    public final int af() {
        return this.A << 8 | this.F;
    }

    protected final void af(int v) {
        this.A = v >> 8;
        this.F = v & 0xFF;
    }

    @Override
    public final boolean isInterruptEnabled() {
        return this.iff1 & this.iff2;
    }

    protected void initPeripherals() throws SIMException {
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.initMemories();
        this.initPeripherals();
        this.initRegisters();
        this.initOpcodes();
        this.initOpcodeDecoder();
        super.init(parent);
    }

    protected final void push(int value) throws SIMException {
        this.SP = this.SP - 2 & 0xFFFF;
        this.setWord(this.SP, value);
    }

    public final int pop() throws SIMException {
        int v = this.getWord(this.SP);
        this.SP = this.SP + 2 & 0xFFFF;
        return v;
    }

    public final int getPortHI() {
        return this.portHI;
    }

    public final void out(int portLow, int portHI, int value) throws SIMException {
        this.portHI = portHI;
        this.setIOByte(portLow, value);
    }

    protected final int in(int portLOW, int portHI) throws SIMException {
        this.portHI = portHI;
        return this.getIOByte(portLOW);
    }

    public final void daa() {
        boolean tmp3;
        int tmp1 = this.A;
        int tmp2 = 0;
        boolean tmp = tmp3 = this.FLAG_C();
        if (this.FLAG_H() || (tmp1 & 0xF) > 9) {
            tmp2 |= 6;
        }
        if (tmp3 || tmp1 > 159 || tmp1 > 143 && (tmp1 & 0xF) > 9) {
            tmp2 |= 0x60;
            tmp = true;
        }
        if (tmp1 > 153) {
            tmp = true;
        }
        if (this.FLAG_N()) {
            this.sub8(tmp2);
        } else {
            this.add8(tmp2);
        }
        this.FLAG_C(tmp);
        this.FLAG_V(parityTable[this.A]);
    }

    public final int rl(int value) {
        boolean bit7 = (value & 0x80) != 0;
        int c = this.FLAG_C() ? 1 : 0;
        value <<= 1;
        value |= c;
        this.F = booleanTable[value &= 0xFF];
        this.FLAG_C(bit7);
        return value;
    }

    protected final int rlc(int value) {
        boolean bit7 = (value & 0x80) != 0;
        value <<= 1;
        value &= 0xFF;
        if (bit7) {
            value |= 1;
        }
        this.F = booleanTable[value];
        this.FLAG_C(bit7);
        return value;
    }

    protected final int rr(int value) {
        boolean bit0 = (value & 1) != 0;
        value = value >> 1 & 0x7F;
        if (this.FLAG_C()) {
            value |= 0x80;
        }
        this.F = booleanTable[value];
        this.FLAG_C(bit0);
        return value;
    }

    public final void rla() {
        boolean bit7 = (this.A & 0x80) != 0;
        this.FLAG_H(false);
        this.FLAG_N(false);
        int c = this.FLAG_C() ? 1 : 0;
        this.A = (this.A << 1 | c) & 0xFF;
        this.FLAG_C(bit7);
        this.FLAG_H(false);
        this.FLAG_N(false);
    }

    public final void rra() {
        boolean bit0 = (this.A & 1) != 0;
        this.A = this.A >> 1 & 0x7F;
        if (this.FLAG_C()) {
            this.A |= 0x80;
        }
        this.FLAG_C(bit0);
        this.FLAG_N(false);
        this.FLAG_H(false);
    }

    public final void rlca() {
        boolean bit7 = (this.A & 0x80) != 0;
        this.A = this.A << 1 & 0xFF;
        if (bit7) {
            this.A |= 1;
        }
        this.FLAG_C(bit7);
        this.FLAG_N(false);
        this.FLAG_H(false);
        this.FLAG_3((this.A & 8) != 0);
        this.FLAG_5((this.A & 0x20) != 0);
    }

    public final void rrca() {
        boolean bit0 = (this.A & 1) != 0;
        this.A = this.A >>> 1 & 0xFF;
        if (bit0) {
            this.A |= 0x80;
        }
        this.FLAG_C(bit0);
        this.FLAG_N(false);
        this.FLAG_H(false);
        this.FLAG_3((this.A & 8) != 0);
        this.FLAG_5((this.A & 0x20) != 0);
    }

    public final int rrc(int value) {
        boolean bit0 = (value & 1) != 0;
        value = value >>> 1 & 0x7F;
        if (bit0) {
            value |= 0x80;
        }
        this.F = booleanTable[value];
        this.FLAG_C(bit0);
        return value;
    }

    @Override
    protected void resetRegisters() throws SIMException {
        super.resetRegisters();
        this.iff2 = false;
        this.iff1 = false;
    }

    public final void or(int value) {
        this.A = (this.A | value) & 0xFF;
        this.F = booleanTable[this.A];
    }

    public final void scf() {
        this.FLAG_C(true);
        this.FLAG_H(false);
        this.FLAG_N(false);
        this.FLAG_3((this.A & 8) != 0);
        this.FLAG_5((this.A & 0x20) != 0);
    }

    public final void ccf() {
        this.FLAG_H(this.FLAG_C());
        this.FLAG_N(false);
        this.FLAG_C(!this.FLAG_C());
        this.FLAG_3((this.A & 8) != 0);
        this.FLAG_5((this.A & 0x20) != 0);
    }

    public final void cpl() {
        this.A ^= 0xFF;
        this.FLAG_H(true);
        this.FLAG_N(true);
        this.FLAG_3((this.A & 8) != 0);
        this.FLAG_5((this.A & 0x20) != 0);
    }

    public final void xor(int value) {
        this.A = (this.A ^ value) & 0xFF;
        this.F = booleanTable[this.A];
    }

    public final void and(int value) {
        this.A = this.A & value & 0xFF;
        this.F = booleanTable[this.A] | 0x10;
    }

    public final void add8(int b) {
        this.adc8(b, 0);
    }

    public final void adc8(int b, int c) {
        int ans = this.A + b + c;
        this.F = adc8Table[ans & 0xFF][this.A][c];
        this.A = ans & 0xFF;
    }

    public final void sub8(int b) {
        this.sbc8(b, 0);
    }

    public final void sbc8(int b, int c) {
        int ans = this.A - b - c;
        this.F = sbc8Table[ans & 0xFF][this.A][c];
        this.A = ans & 0xFF;
    }

    public final void cp(int v) {
        int tmp = this.A;
        this.sbc8(v, 0);
        this.A = tmp;
    }

    public final int inc(int value) {
        this.F = this.F & 1 | inc8Table[value];
        return value + 1 & 0xFF;
    }

    public final int dec(int value) {
        this.F = this.F & 1 | dec8Table[value];
        return value - 1 & 0xFF;
    }

    public final int sbc16(int a, int b, int c) {
        int ans = a - b - c;
        this.F = this.F & 0x28 | 2;
        if ((ans & 0x8000) != 0) {
            this.F |= 0x80;
        }
        if ((ans & 0xFFFF) == 0) {
            this.F |= 0x40;
        }
        if ((ans & 0x10000) != 0) {
            this.F |= 1;
        }
        if (((b ^ a) & (a ^ ans) & 0x8000) != 0) {
            this.F |= 4;
        }
        if (((a ^ ans ^ b) & 0x1000) != 0) {
            this.F |= 0x10;
        }
        return ans & 0xFFFF;
    }

    public final int add16(int a, int b) {
        int ans = a + b;
        this.FLAG_H(((a ^ ans ^ b) & 0x1000) != 0);
        this.FLAG_C((ans & 0x10000) != 0);
        this.FLAG_N(false);
        return ans & 0xFFFF;
    }

    protected final int adc16(int a, int b, int c) {
        int ans = a + b + c;
        this.F &= 0x28;
        if ((ans & 0x8000) != 0) {
            this.F |= 0x80;
        }
        if ((ans & 0x10000) != 0) {
            this.F |= 1;
        }
        if ((ans & 0xFFFF) == 0) {
            this.F |= 0x40;
        }
        if (((a ^ ans ^ b) & 0x1000) != 0) {
            this.F |= 0x10;
        }
        if (((b ^ a ^ 0x8000) & (b ^ ans) & 0x8000) != 0) {
            this.F |= 4;
        }
        return ans & 0xFFFF;
    }

    public final void setValuePP(int opcode, int value) {
        switch (opcode >> 4 & 3) {
            case 0: {
                this.BC = value;
                break;
            }
            case 1: {
                this.DE = value;
                break;
            }
            case 2: {
                this.HL = value;
                break;
            }
            case 3: {
                this.SP = value;
            }
        }
    }

    public final boolean getFlagCCC(int opcode) {
        return (this.F & cccFlag[opcode = opcode >> 3 & 7]) == cccValue[opcode];
    }

    public String getCCC(int opcode) {
        switch (opcode >> 3 & 7) {
            case 0: {
                return "NZ";
            }
            case 1: {
                return "Z";
            }
            case 2: {
                return "NC";
            }
            case 3: {
                return "C";
            }
            case 4: {
                return "PO";
            }
            case 5: {
                return "PE";
            }
            case 6: {
                return "P";
            }
            case 7: {
                return "M";
            }
        }
        return "";
    }

    public final void setValueQQ(int opcode, int value) {
        switch (opcode >> 4 & 3) {
            case 0: {
                this.BC = value;
                break;
            }
            case 1: {
                this.DE = value;
                break;
            }
            case 2: {
                this.HL = value;
                break;
            }
            case 3: {
                this.af(value);
            }
        }
    }

    public String getPP(int opcode) {
        switch (opcode >> 4 & 3) {
            case 0: {
                return "BC";
            }
            case 1: {
                return "DE";
            }
            case 2: {
                return "HL";
            }
            case 3: {
                return "SP";
            }
        }
        return "";
    }

    public final int getValuePP(int opcode) {
        switch (opcode >> 4 & 3) {
            case 0: {
                return this.BC;
            }
            case 1: {
                return this.DE;
            }
            case 2: {
                return this.HL;
            }
            case 3: {
                return this.SP;
            }
        }
        return 0;
    }

    public String getQQ(int opcode) {
        switch (opcode >> 4 & 3) {
            case 0: {
                return "BC";
            }
            case 1: {
                return "DE";
            }
            case 2: {
                return "HL";
            }
            case 3: {
                return "AF";
            }
        }
        return "";
    }

    public final int getValueQQ(int opcode) {
        switch (opcode >> 4 & 3) {
            case 0: {
                return this.BC;
            }
            case 1: {
                return this.DE;
            }
            case 2: {
                return this.HL;
            }
            case 3: {
                return this.af();
            }
        }
        return 0;
    }

    public String getRRR(int opcode) {
        switch (opcode & 7) {
            case 0: {
                return "B";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "E";
            }
            case 4: {
                return "H";
            }
            case 5: {
                return "L";
            }
            case 6: {
                return "(HL)";
            }
            case 7: {
                return "A";
            }
        }
        return "";
    }

    public final int getValueRRR(int opcode) throws SIMException {
        switch (opcode & 7) {
            case 0: {
                return this.BC >>> 8;
            }
            case 1: {
                return this.BC & 0xFF;
            }
            case 2: {
                return this.DE >>> 8;
            }
            case 3: {
                return this.DE & 0xFF;
            }
            case 4: {
                return this.HL >>> 8;
            }
            case 5: {
                return this.HL & 0xFF;
            }
            case 6: {
                return this.getByte(this.HL);
            }
            case 7: {
                return this.A;
            }
        }
        return 0;
    }

    public final void setValueRRR(int opcode, int value) throws SIMException {
        switch (opcode & 7) {
            case 0: {
                this.BC = this.BC & 0xFF | value << 8;
                break;
            }
            case 1: {
                this.BC = this.BC & 0xFF00 | value & 0xFF;
                break;
            }
            case 2: {
                this.DE = this.DE & 0xFF | value << 8;
                break;
            }
            case 3: {
                this.DE = this.DE & 0xFF00 | value & 0xFF;
                break;
            }
            case 4: {
                this.HL = this.HL & 0xFF | value << 8;
                break;
            }
            case 5: {
                this.HL = this.HL & 0xFF00 | value & 0xFF;
                break;
            }
            case 6: {
                this.setByte(this.HL, value);
                break;
            }
            case 7: {
                this.A = value;
            }
        }
    }

    protected void initOpcodeDecoder() {
        this.addDecoder(new AbstractDecoder("%ccc", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime _r, int startPc, int len, int currentPc) throws SIMException {
                return I8080.this.getCCC(I8080.this.getByte(currentPc));
            }
        });
        this.addDecoder(new AbstractDecoder("%rrr", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime _r, int startPc, int len, int currentPc) throws SIMException {
                return I8080.this.getRRR(I8080.this.getByte(currentPc));
            }
        });
        this.addDecoder(new AbstractDecoder("%rr3", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime _r, int startPc, int len, int currentPc) throws SIMException {
                return I8080.this.getRRR(I8080.this.getByte(currentPc) >> 3);
            }
        });
        this.addDecoder(new AbstractDecoder("%pp", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime _r, int startPc, int len, int currentPc) throws SIMException {
                return I8080.this.getPP(I8080.this.getByte(currentPc));
            }
        });
        this.addDecoder(new AbstractDecoder("%qq", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime _r, int startPc, int len, int currentPc) throws SIMException {
                return I8080.this.getQQ(I8080.this.getByte(currentPc));
            }
        });
    }

    protected void initOpcodes() {
        int i;
        this.setOpcode(new AbstractOpcode(2, 1, 7, "LD\t(BC),A"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.setByte(I8080.this.BC, I8080.this.A);
                return 10;
            }
        });
        this.setOpcode(new AbstractOpcode(39, 1, 4, "DAA"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.daa();
                return 4;
            }
        });
        for (i = 0; i < 8; ++i) {
            String s = Hex.formatByte(i * 8);
            this.setOpcode(new AbstractOpcode(0xC7 | i << 3, 1, 11, "RST\t" + s){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.push(I8080.this.PC);
                    I8080.this.PC = (this.opcode >> 3 & 7) * 8;
                    return 11;
                }
            });
        }
        this.setOpcode(new AbstractOpcode(7, 1, 4, "RLCA"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.rlca();
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(15, 1, 4, "RRCA"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.rrca();
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(23, 1, 4, "RLA"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.rla();
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(31, 1, 4, "RRA"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.rra();
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(50, 3, 13, "LD\t(%word),A"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.setByte(I8080.this.getWord(pc + 1), I8080.this.A);
                return 13;
            }
        });
        this.setOpcode(new AbstractOpcode(58, 3, 13, "LD\tA,(%word)"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.A = I8080.this.getByte(I8080.this.getWord(pc + 1));
                return 13;
            }
        });
        this.setOpcode(new AbstractOpcode(243, 1, 4, "DI"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.iff2 = false;
                I8080.this.iff1 = false;
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(251, 1, 4, "EI"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.iff2 = true;
                I8080.this.iff1 = true;
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(201, 1, 10, "RET"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.PC = I8080.this.pop();
                return 10;
            }
        });
        this.setOpcode(new AbstractOpcode(238, 2, 7, "XOR\tA,%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.xor(I8080.this.getByte(pc + 1));
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(206, 2, 7, "ADC\tA,%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.adc8(I8080.this.getByte(pc + 1), I8080.this.FLAG_C() ? 1 : 0);
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(230, 2, 7, "AND\tA,%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.and(I8080.this.getByte(pc + 1));
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(246, 2, 7, "OR\tA,%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.or(I8080.this.getByte(pc + 1));
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(198, 2, 7, "ADD\tA,%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.adc8(I8080.this.getByte(pc + 1), 0);
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(214, 2, 7, "SUB\tA,%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.sbc8(I8080.this.getByte(pc + 1), 0);
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(227, 1, 19, "EX\t(SP),HL"){

            @Override
            public int exec(int pc) throws SIMException {
                int tmp = I8080.this.getByte(I8080.this.SP);
                I8080.this.setByte(I8080.this.SP, I8080.this.HL & 0xFF);
                I8080.this.l(tmp);
                tmp = I8080.this.getByte(I8080.this.SP + 1);
                I8080.this.setByte(I8080.this.SP + 1, I8080.this.HL >>> 8);
                I8080.this.h(tmp);
                return 19;
            }
        });
        this.setOpcode(new AbstractOpcode(235, 1, 4, "EX\tDE,HL"){

            @Override
            public int exec(int pc) throws SIMException {
                int tmp = I8080.this.HL;
                I8080.this.HL = I8080.this.DE;
                I8080.this.DE = tmp;
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(26, 1, 7, "LD\tA,(DE)"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.A = I8080.this.getByte(I8080.this.DE);
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(18, 1, 7, "LD\t(DE),A"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.setByte(I8080.this.DE, I8080.this.A);
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(10, 1, 7, "LD\tA,(BC)"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.A = I8080.this.getByte(I8080.this.BC);
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(118, 1, 4, "HALT"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.halt();
                return 10;
            }
        });
        this.setOpcode(new AbstractOpcode(0, 1, 4, "NOP"){

            @Override
            public int exec(int pc) throws SIMException {
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(254, 2, 7, "CP\t%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.cp(I8080.this.getByte(pc + 1));
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(222, 2, 7, "SBC\tA,%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.sbc8(I8080.this.getByte(pc + 1), I8080.this.FLAG_C() ? 1 : 0);
                return 7;
            }
        });
        this.setOpcode(new AbstractOpcode(47, 1, 4, "CPL"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.cpl();
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(63, 1, 4, "CCF"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.ccf();
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(55, 1, 4, "SCF"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.scf();
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(211, 2, 11, "OUT\t(%byte)"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.out(I8080.this.getByte(pc + 1), 0, I8080.this.A);
                return 11;
            }
        });
        this.setOpcode(new AbstractOpcode(219, 2, 11, "IN\t(%byte)"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.A = I8080.this.in(I8080.this.getByte(pc + 1), I8080.this.A);
                return 11;
            }
        });
        this.setOpcode(new AbstractOpcode(205, 3, 17, "CALL\t%word"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.push(I8080.this.PC);
                I8080.this.PC = I8080.this.getWord(pc + 1);
                return 17;
            }
        });
        this.setOpcode(new AbstractOpcode(195, 3, 10, "JP\t%word"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.PC = I8080.this.getWord(pc + 1);
                return 10;
            }
        });
        this.setOpcode(new AbstractOpcode(233, 1, 10, "JP\tHL"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.PC = I8080.this.HL;
                return 10;
            }
        });
        this.setOpcode(new AbstractOpcode(54, 2, 10, "LD\t(HL),%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.setByte(I8080.this.HL, I8080.this.getByte(pc + 1));
                return 10;
            }
        });
        this.setOpcode(new AbstractOpcode(34, 3, 16, "LD\t(%word),HL"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.setWord(I8080.this.getWord(pc + 1), I8080.this.HL);
                return 16;
            }
        });
        this.setOpcode(new AbstractOpcode(249, 1, 6, "LD\tSP,HL"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.SP = I8080.this.HL;
                return 6;
            }
        });
        this.setOpcode(new AbstractOpcode(42, 3, 16, "LD\tHL,(%word)"){

            @Override
            public int exec(int pc) throws SIMException {
                I8080.this.HL = I8080.this.getWord(I8080.this.getWord(pc + 1));
                return 16;
            }
        });
        this.setOpcode(new AbstractOpcode(52, 1, 11, "INC\t(HL)"){

            @Override
            public int exec(int pc) throws SIMException {
                int i = I8080.this.HL;
                I8080.this.setByte(i, I8080.this.inc(I8080.this.getByte(i)));
                return 11;
            }
        });
        for (i = 0; i < 4; ++i) {
            this.setOpcode(new AbstractOpcode(0xC1 | i << 4, 1, 10, "POP\t%qq"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.setValueQQ(this.opcode, I8080.this.pop());
                    return 10;
                }
            });
            this.setOpcode(new AbstractOpcode(0xC5 | i << 4, 1, 11, "PUSH\t%qq"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.push(I8080.this.getValueQQ(this.opcode));
                    return 11;
                }
            });
            this.setOpcode(new AbstractOpcode(1 | i << 4, 3, 10, "LD\t%pp,%word"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.setValuePP(this.opcode, I8080.this.getWord(pc + 1));
                    return 11;
                }
            });
            this.setOpcode(new AbstractOpcode(0xB | i << 4, 1, 6, "DEC\t%pp"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.setValuePP(this.opcode, I8080.this.getValuePP(this.opcode) - 1 & 0xFFFF);
                    return 6;
                }
            });
            this.setOpcode(new AbstractOpcode(3 | i << 4, 1, 6, "INC\t%pp"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.setValuePP(this.opcode, I8080.this.getValuePP(this.opcode) + 1 & 0xFFFF);
                    return 6;
                }
            });
            this.setOpcode(new AbstractOpcode(9 | i << 4, 1, 11, "ADD\tHL,%pp"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.HL = I8080.this.add16(I8080.this.HL, I8080.this.getValuePP(this.opcode));
                    return 6;
                }
            });
        }
        for (i = 0; i < 8; ++i) {
            this.setOpcode(new AbstractOpcode(5 | i << 3, 1, 4, "DEC\t%rr3"){

                @Override
                public int exec(int pc) throws SIMException {
                    int r = this.opcode >> 3;
                    I8080.this.setValueRRR(r, I8080.this.dec(I8080.this.getValueRRR(r)));
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(0x90 | i, 1, 4, "SUB\tA,%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.sbc8(I8080.this.getValueRRR(this.opcode), 0);
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(0x98 | i, 1, 4, "SBC\tA,%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.sbc8(I8080.this.getValueRRR(this.opcode), I8080.this.FLAG_C() ? 1 : 0);
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(0x80 | i, 1, 4, "ADD\tA,%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.adc8(I8080.this.getValueRRR(this.opcode), 0);
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(0x88 | i, 1, 4, "ADC\tA,%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.adc8(I8080.this.getValueRRR(this.opcode), I8080.this.FLAG_C() ? 1 : 0);
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(0xA0 | i, 1, 4, "AND\t%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.and(I8080.this.getValueRRR(this.opcode));
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(0xA8 | i, 1, 4, "XOR\tA,%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.xor(I8080.this.getValueRRR(this.opcode));
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(0xB0 | i, 1, 4, "OR\tA,%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.or(I8080.this.getValueRRR(this.opcode));
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(0xB8 | i, 1, 4, "CP\t%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.cp(I8080.this.getValueRRR(this.opcode));
                    return 4;
                }
            });
            if (i == 6) continue;
            for (int j = 0; j < 8; ++j) {
                if (j == 6) continue;
                this.setOpcode(new AbstractOpcode(0x40 | i << 3 | j, 1, 4, "LD\t" + this.getRRR(i) + "," + this.getRRR(j)){

                    @Override
                    public final int exec(int pc) throws SIMException {
                        I8080.this.setValueRRR(this.opcode >> 3, I8080.this.getValueRRR(this.opcode));
                        return 4;
                    }
                });
            }
            this.setOpcode(new AbstractOpcode(4 | i << 3, 1, 4, "INC\t" + this.getRRR(i)){

                @Override
                public int exec(int pc) throws SIMException {
                    int r = this.opcode >> 3;
                    I8080.this.setValueRRR(r, I8080.this.inc(I8080.this.getValueRRR(r)));
                    return 4;
                }
            });
            this.setOpcode(new AbstractOpcode(6 | i << 3, 2, 7, "LD\t%rr3,%byte"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.setValueRRR(this.opcode >> 3, I8080.this.getByte(pc + 1));
                    return 7;
                }
            });
            this.setOpcode(new AbstractOpcode(0x46 | i << 3, 1, 7, "LD\t%rr3,(HL)"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.setValueRRR(this.opcode >> 3, I8080.this.getByte(I8080.this.HL));
                    return 7;
                }
            });
            this.setOpcode(new AbstractOpcode(0x70 | i, 1, 7, "LD\t(HL),%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    I8080.this.setByte(I8080.this.HL, I8080.this.getValueRRR(this.opcode));
                    return 7;
                }
            });
        }
        for (i = 0; i < 8; ++i) {
            this.setOpcode(new AbstractOpcode(0xC0 | i << 3, 1, 5, "RET\t" + this.getCCC(i)){

                @Override
                public final int exec(int pc) throws SIMException {
                    if (I8080.this.getFlagCCC(this.opcode)) {
                        I8080.this.PC = I8080.this.pop();
                        return 11;
                    }
                    return 5;
                }
            });
            this.setOpcode(new AbstractOpcode(0xC4 | i << 3, 3, 10, "CALL\t%ccc,%word"){

                @Override
                public int exec(int pc) throws SIMException {
                    if (I8080.this.getFlagCCC(this.opcode)) {
                        I8080.this.push(I8080.this.PC);
                        I8080.this.PC = I8080.this.getWord(pc + 1);
                        return 17;
                    }
                    return 10;
                }
            });
            this.setOpcode(new AbstractOpcode(0xC2 | i << 3, 3, 10, "JP\t%ccc,%word"){

                @Override
                public int exec(int pc) throws SIMException {
                    if (I8080.this.getFlagCCC(this.opcode)) {
                        I8080.this.PC = I8080.this.getWord(pc + 1);
                        return 10;
                    }
                    return 3;
                }
            });
        }
    }

    @Override
    public int fireISR(Interrupt isr) throws SIMException {
        this.iff1 = false;
        this.iff2 = false;
        this.push(this.PC);
        this.PC = isr.getVector();
        return 10;
    }

    public int fireNMI(Interrupt isr) throws SIMException {
        this.iff2 = this.iff1;
        this.iff1 = false;
        this.push(this.PC);
        this.PC = isr.getVector();
        return 10;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int ans;
            int c;
            int j;
            int old = i;
            int value = i;
            int F = 2;
            if (value == 128) {
                F |= 4;
            }
            if (((value = value - 1 & 0xFF) & 0x80) != 0) {
                F |= 0x80;
            }
            if (value == 0) {
                F |= 0x40;
            }
            if ((value & 8) != 0) {
                F |= 8;
            }
            if ((value & 0x20) != 0) {
                F |= 0x20;
            }
            if (((old ^ value) & 0x10) != 0) {
                F |= 0x10;
            }
            I8080.dec8Table[i] = F & 0xFF;
            F = 0;
            old = i;
            value = i;
            if (value == 127) {
                F |= 4;
            }
            if (((value = value + 1 & 0xFF) & 0x80) != 0) {
                F |= 0x80;
            }
            if (value == 0) {
                F |= 0x40;
            }
            if ((value & 8) != 0) {
                F |= 8;
            }
            if ((value & 0x20) != 0) {
                F |= 0x20;
            }
            if (((old ^ value) & 0x10) != 0) {
                F |= 0x10;
            }
            I8080.inc8Table[i] = F & 0xFF;
            F = 0;
            if ((i & 0x80) != 0) {
                F |= 0x80;
            }
            if (i == 0) {
                F |= 0x40;
            }
            if (parityTable[i]) {
                F |= 4;
            }
            if ((i & 8) != 0) {
                F |= 8;
            }
            if ((i & 0x20) != 0) {
                F |= 0x20;
            }
            I8080.booleanTable[i] = F & 0xFF;
            for (j = 0; j < 256; ++j) {
                for (c = 0; c < 2; ++c) {
                    F = 0;
                    ans = i + j + c;
                    if ((ans & 0x80) != 0) {
                        F |= 0x80;
                    }
                    if ((ans & 0x100) != 0) {
                        F |= 1;
                    }
                    if ((ans & 0xFF) == 0) {
                        F |= 0x40;
                    }
                    if (((i ^ ans ^ j) & 0x10) != 0) {
                        F |= 0x10;
                    }
                    if (((i ^ j ^ 0x80) & (j ^ ans) & 0x80) != 0) {
                        F |= 4;
                    }
                    if ((ans & 8) != 0) {
                        F |= 8;
                    }
                    if ((ans & 0x20) != 0) {
                        F |= 0x20;
                    }
                    I8080.adc8Table[ans & 0xFF][i][c] = F;
                }
            }
            for (j = 0; j < 256; ++j) {
                for (c = 0; c < 2; ++c) {
                    F = 2;
                    ans = i - j - c;
                    if ((ans & 0x80) != 0) {
                        F |= 0x80;
                    }
                    if ((ans & 0x100) != 0) {
                        F |= 1;
                    }
                    if ((ans & 0xFF) == 0) {
                        F |= 0x40;
                    }
                    if (((i ^ ans ^ j) & 0x10) != 0) {
                        F |= 0x10;
                    }
                    if (((j ^ i) & (i ^ ans) & 0x80) != 0) {
                        F |= 4;
                    }
                    if ((ans & 8) != 0) {
                        F |= 8;
                    }
                    if ((ans & 0x20) != 0) {
                        F |= 0x20;
                    }
                    I8080.sbc8Table[ans & 0xFF][i][c] = F;
                }
            }
        }
        cccFlag = new int[]{64, 64, 1, 1, 4, 4, 128, 128};
        cccValue = new int[]{0, 64, 0, 1, 0, 4, 0, 128};
    }
}

