/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.mcs51;

import jmce.intel.mcs51.MCS51Constants;
import jmce.intel.mcs51.Ports;
import jmce.intel.mcs51.Serial;
import jmce.intel.mcs51.Timer;
import jmce.sim.CPU;
import jmce.sim.CPUException;
import jmce.sim.CallListener;
import jmce.sim.CpuRuntime;
import jmce.sim.Hardware;
import jmce.sim.Interrupt;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.Register;
import jmce.sim.SIMException;
import jmce.sim.cpu.AbstractCPU;
import jmce.sim.cpu.AbstractDecoder;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.MemoryRegister;
import jmce.sim.cpu.PairRegister;
import jmce.sim.cpu.StandardRegister;
import jmce.sim.memory.MemoryBit;
import jmce.sim.memory.OpenCollectorMemoryBit;
import jmce.sim.memory.PlainMemory;
import jmce.sim.terminal.Terminal;
import jmce.util.Logger;

public class MCS51
extends AbstractCPU
implements MCS51Constants {
    protected static final Logger log = Logger.getLogger(MCS51.class);
    public static final String CODE_MEMORY = "CODE";
    public static final String XDATA_MEMORY = "XDATA";
    public static final String DATA_MEMORY = "DATA";
    public static final String SFR_MEMORY = "SFR";
    private Memory data = null;
    private Memory sfr = null;
    private Memory xdata = null;
    private Register RPC;
    private Register RSP;
    private Register RA;
    private Register RB;
    private Register RPSW;
    private Register[] R = new Register[8];
    private Register RDPL;
    private Register RDPH;
    private Register RDPTR;
    private int[] sfrBitmap = new int[256];
    private String[] bitNames = new String[256];
    private int sfrXdataHi = 160;
    private int pc;
    private boolean interruptEnabled = false;
    private boolean interruptInUse = false;
    private int dptrIndex = 0;
    private int[] dptrs = new int[256];
    private boolean auxrDptr = false;

    public MCS51() {
        super("i8051");
        this.setEndian(1);
        this.setClock(12000000L);
        this.setClockPerCycle(12);
    }

    @Override
    public final void setWord(int a, int v) throws SIMException {
        this.memory.setMemory(a + 1, v & 0xFF);
        this.memory.setMemory(a + 0, v >>> 8);
    }

    @Override
    public final int getWord(int a) throws SIMException {
        return this.memory.getMemory(a + 1) | this.memory.getMemory(a + 0) << 8;
    }

    protected int getXdataHi() throws SIMException {
        int value = 0;
        if (this.sfrXdataHi != -1) {
            value = this.sfr(this.sfrXdataHi);
        }
        return value;
    }

    protected void setSfrXdataHi(int sfr) {
        this.sfrXdataHi = sfr;
    }

    protected Memory getXdata() {
        return this.xdata;
    }

    protected Memory getSfr() {
        return this.sfr;
    }

    protected void setSfr(Memory m) {
        this.sfr = m;
    }

    protected void setXdata(Memory m) {
        this.xdata = m;
    }

    protected Memory getData() {
        return this.data;
    }

    protected void setData(Memory m) {
        this.data = m;
    }

    public final int sfr(int add) throws SIMException {
        return this.sfr.getMemory(add);
    }

    public final void sfr(int add, int value) throws SIMException {
        this.sfr.setMemory(add, value);
    }

    public final int getDirect(int add) throws SIMException {
        if (add >= 128) {
            return this.sfr(add);
        }
        return this.data(add);
    }

    public final void setDirect(int add, int value) throws SIMException {
        if (add >= 128) {
            this.sfr(add, value);
        } else {
            this.data(add, value);
        }
    }

    public String getDirectName(int add) {
        if (add >= 128) {
            return this.getSfrName(add);
        }
        return this.getDataName(add);
    }

    public final boolean getBitCode(int add) throws SIMException {
        return this.getBit(this.code(add));
    }

    protected final int getDirectCode(int pc) throws SIMException {
        return this.getDirect(this.code(pc));
    }

    private void initArithmeticOpcode(ArithmeticOperation op, int basecode, String name) {
        int i;
        for (i = 0; i < 8; ++i) {
            this.setOpcode(new Arithmetic(basecode | 8 | i, 1, op, name + "\tA,%reg"){

                @Override
                public int getValue(int pc) throws SIMException {
                    return MCS51.this.r(this.opcode & 7);
                }
            });
        }
        this.setOpcode(new Arithmetic(basecode | 5, 2, op, name + "\tA,%direct"){

            @Override
            public int getValue(int pc) throws SIMException {
                return MCS51.this.getDirectCode(pc + 1);
            }
        });
        for (i = 0; i < 2; ++i) {
            this.setOpcode(new Arithmetic(basecode | 6 | i, 1, op, name + "\tA,%ri"){

                @Override
                public int getValue(int pc) throws SIMException {
                    return MCS51.this.data(MCS51.this.r(this.opcode & 1));
                }
            });
        }
        this.setOpcode(new Arithmetic(basecode | 4, 2, op, name + "\tA,#%byte"){

            @Override
            public int getValue(int pc) throws SIMException {
                return MCS51.this.code(pc + 1);
            }
        });
    }

    protected void initOpcodes() {
        int r;
        for (int i = 0; i < 8; ++i) {
            this.setOpcode(new ACALL(i << 5 | 0x11));
            this.setOpcode(new AJMP(i << 5 | 1));
        }
        this.initArithmeticOpcode(new ArithmeticADD(), 32, "ADD");
        this.initArithmeticOpcode(new ArithmeticADDC(), 48, "ADDC");
        this.initArithmeticOpcode(new ArithmeticANL(), 80, "ANL");
        this.initArithmeticOpcode(new ArithmeticORL(), 64, "ORL");
        this.initArithmeticOpcode(new ArithmeticSUBB(), 144, "SUBB");
        this.initArithmeticOpcode(new ArithmeticXRL(), 96, "XRL");
        this.setOpcode(new ANL_DIRECT_A());
        this.setOpcode(new ANL_DIRECT_DATA());
        this.setOpcode(new ANL_C_DIRECT());
        this.setOpcode(new ANL_C_NOT_DIRECT());
        this.setOpcode(new CJNE_A_DIRECT());
        this.setOpcode(new CJNE_A_DATA());
        for (r = 0; r < 8; ++r) {
            this.setOpcode(new CJNE_R_DATA(r));
            this.setOpcode(new DEC_R(r));
            this.setOpcode(new DJNZ_R(r));
            this.setOpcode(new INC_R(r));
            this.setOpcode(new MOV_A_R(r));
            this.setOpcode(new MOV_R_A(r));
            this.setOpcode(new MOV_R_DIRECT(r));
            this.setOpcode(new MOV_R_DATA(r));
            this.setOpcode(new MOV_DIRECT_R(r));
            this.setOpcode(new XCH_A_R(r));
        }
        for (r = 0; r < 2; ++r) {
            this.setOpcode(new CJNE_RI_DATA(r));
            this.setOpcode(new DEC_RI(r));
            this.setOpcode(new INC_RI(r));
            this.setOpcode(new MOV_A_RI(r));
            this.setOpcode(new MOV_RI_A(r));
            this.setOpcode(new MOV_DIRECT_RI(r));
            this.setOpcode(new MOV_RI_DIRECT(r));
            this.setOpcode(new MOV_RI_DATA(r));
            this.setOpcode(new MOVX_A_RI(r));
            this.setOpcode(new MOVX_RI_A(r));
            this.setOpcode(new XCH_A_RI(r));
            this.setOpcode(new XCHD_A_RI(r));
        }
        this.setOpcode(new CLR_A());
        this.setOpcode(new CLR_C());
        this.setOpcode(new CLR_BIT());
        this.setOpcode(new CPL_A());
        this.setOpcode(new CPL_C());
        this.setOpcode(new CPL_BIT());
        this.setOpcode(new DA_A());
        this.setOpcode(new DEC_A());
        this.setOpcode(new DEC_DIRECT());
        this.setOpcode(new DIV_AB());
        this.setOpcode(new DJNZ_DIRECT());
        this.setOpcode(new INC_A());
        this.setOpcode(new INC_DIRECT());
        this.setOpcode(new INC_DPTR());
        this.setOpcode(new JB());
        this.setOpcode(new JBC());
        this.setOpcode(new JC());
        this.setOpcode(new JMP_A_DPTR());
        this.setOpcode(new JNB());
        this.setOpcode(new JNC());
        this.setOpcode(new JNZ());
        this.setOpcode(new JZ());
        this.setOpcode(new LCALL());
        this.setOpcode(new LJMP());
        this.setOpcode(new MOV_A_DIRECT());
        this.setOpcode(new MOV_A_DATA());
        this.setOpcode(new MOV_DIRECT_A());
        this.setOpcode(new MOV_DIRECT_DIRECT());
        this.setOpcode(new MOV_DIRECT_DATA());
        this.setOpcode(new MOV_C_BIT());
        this.setOpcode(new MOV_BIT_C());
        this.setOpcode(new MOV_DPTR_DATA16());
        this.setOpcode(new MOVC_A_DPTR_A());
        this.setOpcode(new MOVC_A_PC_A());
        this.setOpcode(new MOVX_A_DPTR());
        this.setOpcode(new MOVX_DPTR_A());
        this.setOpcode(new MUL_AB());
        this.setOpcode(new NOP());
        this.setOpcode(new ORL_C_BIT());
        this.setOpcode(new ORL_C_NBIT());
        this.setOpcode(new POP_DIRECT());
        this.setOpcode(new PUSH_DIRECT());
        this.setOpcode(new RET());
        this.setOpcode(new RETI());
        this.setOpcode(new RL_A());
        this.setOpcode(new RLC_A());
        this.setOpcode(new RR_A());
        this.setOpcode(new RRC_A());
        this.setOpcode(new SETB_C());
        this.setOpcode(new SETB_BIT());
        this.setOpcode(new SJMP());
        this.setOpcode(new SWAP_A());
        this.setOpcode(new XCH_A_DIRECT());
        this.setOpcode(new XRL_DIRECT_A());
        this.setOpcode(new XRL_DIRECT_DATA());
        this.setOpcode(new ORL_DIRECT_A());
        this.setOpcode(new ORL_DIRECT_DATA());
    }

    public void setBitName(int add, String name) {
        this.bitNames[add] = name;
    }

    public String getBitName(int add) {
        if (this.bitNames[add] != null) {
            return this.bitNames[add];
        }
        int bit = add & 7;
        add = add < 128 ? 32 + add / 8 : (add &= 0xF8);
        return this.getDirectName(add) + "^" + bit;
    }

    public void setSfrBitmap(int i, int add) {
        this.sfrBitmap[i] = add;
    }

    public final boolean getBit(int add) throws SIMException {
        int value = this.getDirect(this.sfrBitmap[add]);
        return (value & 1 << (add & 7)) != 0;
    }

    public final void cplBit(int bit) throws SIMException {
        this.setBit(bit, !this.getBit(bit));
    }

    public final void setBit(int add, boolean value) throws SIMException {
        int mask = 1 << (add & 7);
        if ((add = this.sfrBitmap[add]) >= 128) {
            if (value) {
                this.sfr.setBit(add, mask);
            } else {
                this.sfr.clrBit(add, mask);
            }
        } else if (value) {
            this.data.setBit(add, mask);
        } else {
            this.data.clrBit(add, mask);
        }
    }

    protected void initRegisters() {
        int i;
        this.RPC = this.addRegister(new StandardRegister("PC", 1, 16, 0){

            @Override
            public int getRegister() {
                return MCS51.this.pc;
            }

            @Override
            public void setRegister(int value) {
                MCS51.this.pc = value;
            }
        });
        this.RSP = this.addRegister(new MemoryRegister(this.sfr, 129, "SP", 4, 8));
        this.RA = this.addRegister(new MemoryRegister(this.sfr, 224, "A", 2, 8));
        this.RB = this.addRegister(new MemoryRegister(this.sfr, 240, "B", 2, 8));
        this.RPSW = this.addRegister(new MemoryRegister(this.sfr, 208, "PSW", 6, 8));
        this.RDPL = this.addRegister(new MemoryRegister(this.sfr, 130, "DPL", 3, 8));
        this.RDPH = this.addRegister(new MemoryRegister(this.sfr, 131, "DPH", 3, 8));
        this.RDPTR = this.addRegister(new PairRegister("DPTR", this.RDPL, this.RDPH));
        for (i = 0; i < 8; ++i) {
            this.R[i] = this.addRegister(new Register8051(i));
        }
        for (i = 0; i < 128; ++i) {
            this.setSfrBitmap(i, 32 + i / 8);
        }
        for (i = 128; i < 256; ++i) {
            this.setSfrBitmap(i, i & 0xF8);
        }
    }

    protected void setDataName(int r, String name) {
        this.data.setMemoryName(r, name);
    }

    protected String getDataName(int r) {
        return this.data.getMemoryName(r);
    }

    protected void setSfrName(int address, String name) {
        this.sfr.setMemoryName(address, name);
    }

    protected String getSfrName(int address) {
        return this.sfr.getMemoryName(address);
    }

    protected void initMemories() {
        Memory m = this.getMemoryForName(CODE_MEMORY);
        if (m == null) {
            m = (Memory)this.addHardware(new PlainMemory(CODE_MEMORY, 65536));
        }
        this.setMemory(m);
        m = this.getMemoryForName(XDATA_MEMORY);
        if (m == null) {
            m = (Memory)this.addHardware(new PlainMemory(XDATA_MEMORY, 65536));
        }
        this.setXdata(m);
        m = this.getMemoryForName(DATA_MEMORY);
        if (m == null) {
            m = (Memory)this.addHardware(new PlainMemory(DATA_MEMORY, 128));
        }
        this.setData(m);
        m = this.getMemoryForName(SFR_MEMORY);
        if (m == null) {
            m = (Memory)this.addHardware(new PlainMemory(SFR_MEMORY, 256));
        }
        this.setSfr(m);
        this.setIO(m);
    }

    protected void initNames() {
        this.setSfrName(224, "ACC");
        this.setSfrName(240, "B");
        this.setSfrName(208, "PSW");
        this.setSfrName(129, "SP");
        this.setSfrName(130, "DPL");
        this.setSfrName(131, "DPH");
        this.setSfrName(128, "P0");
        this.setSfrName(132, "P0M1");
        this.setSfrName(133, "P0M2");
        this.setSfrName(144, "P1");
        this.setSfrName(145, "P1M1");
        this.setSfrName(146, "P1M2");
        this.setSfrName(160, "P2");
        this.setSfrName(164, "P2M1");
        this.setSfrName(165, "P2M2");
        this.setSfrName(176, "P3");
        this.setSfrName(177, "P3M1");
        this.setSfrName(178, "P3M2");
        this.setSfrName(152, "SCON");
        this.setSfrName(153, "SBUF");
        this.setSfrName(136, "TCON");
        this.setSfrName(137, "TMOD");
        this.setSfrName(140, "TH0");
        this.setSfrName(138, "TL0");
        this.setSfrName(141, "TH1");
        this.setSfrName(139, "TL1");
        this.setSfrName(168, "IE");
        for (int i = 0; i < 8; ++i) {
            this.setDataName(i, "R" + i);
        }
        this.setBitName(152, "RI");
        this.setBitName(153, "TI");
        this.setBitName(154, "RB8");
        this.setBitName(155, "TB8");
        this.setBitName(156, "REN");
        this.setBitName(157, "SM2");
        this.setBitName(158, "SM1");
        this.setBitName(159, "SM0");
        this.setBitName(143, "TF1");
        this.setBitName(142, "TR1");
        this.setBitName(141, "TF0");
        this.setBitName(140, "TR0");
        this.setBitName(175, "EA");
        this.setBitName(174, "EC");
        this.setBitName(173, "ET2");
        this.setBitName(172, "ES");
        this.setBitName(171, "ET1");
        this.setBitName(170, "EX1");
        this.setBitName(169, "ET0");
        this.setBitName(168, "EX0");
        this.setBitName(215, "CY");
        this.setBitName(214, "AC");
        this.setBitName(213, "F0");
        this.setBitName(212, "RS1");
        this.setBitName(211, "RS0");
        this.setBitName(210, "OV");
        this.setBitName(209, "F1");
        this.setBitName(208, "P");
        if (this.auxrDptr) {
            this.setSfrName(162, "AUXR1");
        }
    }

    protected void initOpcodeDecoder() {
        this.addDecoder(new AbstractDecoder("%bit", 1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return MCS51.this.getBitName(MCS51.this.code(currentPc + 1));
            }
        });
        this.addDecoder(new AbstractDecoder("%ri", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return "@R" + (MCS51.this.code(startPc) & 1);
            }
        });
        this.addDecoder(new AbstractDecoder("%reg", 0){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return "R" + (MCS51.this.code(startPc) & 7);
            }
        });
        this.addDecoder(new AbstractDecoder("%direct", 1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime _r, int startPc, int len, int currentPc) throws SIMException {
                int r = MCS51.this.code(currentPc + 1);
                return MCS51.this.getDirectName(r);
            }
        });
    }

    protected void initPeripherals() throws SIMException {
        if (this.getHardware((Class)Ports.class) == null) {
            this.addHardware(new Ports(4));
        }
        if (this.getHardware((Class)Timer.class) == null) {
            this.addHardware(new Timer());
        }
        if (this.getHardware((Class)Serial.class) == null) {
            Serial s = new Serial();
            Terminal t = Terminal.createTerminal();
            s.addHardware(t);
            s.setConnected(t);
            this.addHardware(s);
        }
        this.initListeners();
    }

    protected void initListeners() throws SIMException {
        if (this.auxrDptr) {
            this.addIOWriteListener(162, new MemoryWriteListener(){

                @Override
                public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
                    MCS51.this.setDptrIndex(value & 1);
                }
            });
            this.addIOReadListener(162, new MemoryReadListener(){

                @Override
                public int readMemory(Memory memory, int address, int value) throws SIMException {
                    return value & 0xFD;
                }
            });
        }
    }

    @Override
    public final boolean isInterruptEnabled() {
        return this.interruptEnabled && !this.interruptInUse;
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.initMemories();
        this.initPeripherals();
        this.initRegisters();
        this.initOpcodes();
        this.initOpcodeDecoder();
        this.initNames();
        super.init(parent);
        this.addIOWriteListener(168, new MemoryWriteListener(){

            @Override
            public void writeMemory(Memory m, int a, int v, int oldValue) {
                MCS51.this.interruptEnabled = (v & 0x80) != 0;
            }
        });
    }

    public void sfrReset(int sfr, int mask) throws SIMException {
        this.sfr.clrBit(sfr, mask);
    }

    public void sfrSet(int sfr, int mask) throws SIMException {
        this.sfr.setBit(sfr, mask);
    }

    public OpenCollectorMemoryBit getSfrBitOpenCollector(int address, int bit) {
        return new OpenCollectorMemoryBit(this.sfr, address, bit);
    }

    public MemoryBit getSfrBit(int address, int bit) {
        return new MemoryBit(this.sfr, address, bit);
    }

    @Deprecated
    public void addSfrReadListener(int a, MemoryReadListener l) {
        this.sfr.addMemoryReadListener(a, l);
    }

    @Deprecated
    public void addSfrWriteListener(int address, MemoryWriteListener l) {
        this.sfr.addMemoryWriteListener(address, l);
    }

    @Override
    public final void pc(int pc) throws SIMException {
        this.pc = pc;
    }

    @Override
    public final int pc() throws SIMException {
        return this.pc;
    }

    protected final int r(int r) throws SIMException {
        return this.data.getMemory((this.sfr.getMemory(208) & 0x18) + r);
    }

    protected final void r(int r, int n) throws SIMException {
        this.data.setMemory((this.sfr.getMemory(208) & 0x18) + r, n);
    }

    public void code(int addr, int value) throws SIMException {
        this.memory.setMemory(addr, value);
    }

    protected final int acc() throws SIMException {
        return this.sfr.getMemory(224);
    }

    protected final void acc(int value) throws SIMException {
        this.sfr.setMemory(224, value);
    }

    private final int b() throws SIMException {
        return this.sfr.getMemory(240);
    }

    private final void b(int value) throws SIMException {
        this.sfr.setMemory(240, value);
    }

    private final int dptr() throws SIMException {
        return this.sfr.getMemory(131) << 8 | this.sfr.getMemory(130);
    }

    private final void dptr(int value) throws SIMException {
        this.sfr.setMemory(131, value >>> 8);
        this.sfr.setMemory(130, value);
    }

    public final int psw() throws SIMException {
        return this.sfr.getMemory(208);
    }

    public final void psw(int value) throws SIMException {
        this.sfr.setMemory(208, value);
    }

    public final void cy(boolean value) throws SIMException {
        if (value) {
            this.sfr.setBit(208, 128);
        } else {
            this.sfr.clrBit(208, 128);
        }
    }

    public final boolean cy() throws SIMException {
        return this.sfr.isBit(208, 128);
    }

    public final void ac(boolean value) throws SIMException {
        if (value) {
            this.pswSet(64);
        } else {
            this.pswReset(64);
        }
    }

    public final boolean ac() throws SIMException {
        return (this.psw() & 0x40) != 0;
    }

    public final void ov(boolean value) throws SIMException {
        if (value) {
            this.pswSet(4);
        } else {
            this.pswReset(4);
        }
    }

    public final boolean ov() throws SIMException {
        return (this.psw() & 4) != 0;
    }

    private final void pswSet(int value) throws SIMException {
        this.psw(this.psw() | value);
    }

    private final void pswReset(int value) throws SIMException {
        this.psw(this.psw() & ~value);
    }

    public final int code(int addr) throws SIMException {
        return this.memory.getMemory(addr);
    }

    public final int code16(int addr) throws SIMException {
        return this.memory.getMemory(addr) << 8 | this.memory.getMemory(addr + 1);
    }

    public final int xdata(int add) throws SIMException {
        return this.xdata.getMemory(add);
    }

    public final void xdata(int add, int value) throws SIMException {
        this.xdata.setMemory(add, value);
    }

    public final int data(int add) throws SIMException {
        return this.data.getMemory(add);
    }

    public final void data(int add, int value) throws SIMException {
        this.data.setMemory(add, value);
    }

    public final int popw() throws SIMException {
        int sp = this.sfr.getMemory(129);
        int value = this.data(sp) << 8;
        if (--sp < 0) {
            throw new CPUException(this, "Stack underflow at " + this.RPC.hexValue());
        }
        value |= this.data(sp);
        if (--sp < 0) {
            throw new CPUException(this, "Stack underflow at " + this.RPC.hexValue());
        }
        this.sfr.setMemory(129, sp);
        return value;
    }

    public final int pop() throws SIMException {
        int sp = this.sfr.getMemory(129);
        int value = this.data(sp);
        if (--sp < 0) {
            throw new CPUException(this, "Stack underflow at " + this.RPC.hexValue());
        }
        this.sfr.setMemory(129, sp);
        return value;
    }

    public final void pushw(int value) throws SIMException {
        int sp = this.sfr.getMemory(129);
        if (++sp > 255) {
            throw new CPUException(this, "Stack overflow at " + this.RPC.hexValue());
        }
        this.data(sp, value);
        if (++sp > 255) {
            throw new CPUException(this, "Stack overflow at " + this.RPC.hexValue());
        }
        this.data(sp, value >> 8);
        this.sfr.setMemory(129, sp);
    }

    public final void push(int value) throws SIMException {
        int sp = this.sfr.getMemory(129);
        if (++sp > 255) {
            throw new CPUException(this, "Stack overflow at " + this.RPC.hexValue());
        }
        this.data(sp, value);
        this.sfr.setMemory(129, sp);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        for (int i = 0; i < this.sfr.getSize(); ++i) {
            this.sfr.setMemory(i, 0);
        }
        this.setDptrIndex(0);
        this.interruptInUse = false;
    }

    public boolean sfrIsBit(int add, int mask) throws SIMException {
        return this.sfr.isBit(add, mask);
    }

    public void sfrSetBit(int add, int mask) throws SIMException {
        this.sfr.setBit(add, mask);
    }

    public final void setDptrIndex(int i) throws SIMException {
        if (i != this.dptrIndex) {
            this.dptrs[this.dptrIndex] = this.dptr();
            this.dptr(this.dptrs[i]);
            this.dptrIndex = i;
            log.info("Dptr index=" + this.dptrIndex);
        }
    }

    public final int getDptr(int i) throws SIMException {
        return i == this.dptrIndex ? this.dptr() : this.dptrs[i];
    }

    @Override
    public int fireISR(Interrupt isr) throws SIMException {
        this.interruptInUse = true;
        this.pushw(this.pc);
        this.pc = isr.getVector();
        return 2;
    }

    protected final void setAuxrDptrEnabled() {
        this.auxrDptr = true;
    }

    class NOP
    extends AbstractOpcode {
        NOP() {
            super(0, 1, 1, "NOP");
        }

        @Override
        public int exec(int pc) throws SIMException {
            return this.times;
        }
    }

    class MOV_DIRECT_A
    extends AbstractOpcode {
        public MOV_DIRECT_A() {
            super(245, 2, 1, "MOV\t%direct,A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.setDirect(MCS51.this.code(pc + 1), MCS51.this.acc());
            return this.times;
        }
    }

    class MOV_A_DATA
    extends AbstractOpcode {
        public MOV_A_DATA() {
            super(116, 2, 1, "MOV\tA,#%byte");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.code(pc + 1));
            return this.times;
        }
    }

    class MOV_DIRECT_DIRECT
    extends AbstractOpcode {
        public MOV_DIRECT_DIRECT() {
            super(133, 3, 2, "MOV\t%1%direct,%-2%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int source = MCS51.this.code(pc + 1);
            int dest = MCS51.this.code(pc + 2);
            MCS51.this.setDirect(dest, MCS51.this.getDirect(source));
            return this.times;
        }
    }

    class MOVC_A_PC_A
    extends AbstractOpcode {
        public MOVC_A_PC_A() {
            super(131, 1, 2, "MOVC\tA,@PC+A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.code(pc + 1 + MCS51.this.acc()));
            return this.times;
        }
    }

    class MOVX_DPTR_A
    extends AbstractOpcode {
        public MOVX_DPTR_A() {
            super(240, 1, 2, "MOVX\t@DPTR,A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.xdata(MCS51.this.dptr(), MCS51.this.acc());
            return this.times;
        }
    }

    class MOVX_A_DPTR
    extends AbstractOpcode {
        public MOVX_A_DPTR() {
            super(224, 1, 2, "MOVX\tA,@DPTR");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.xdata(MCS51.this.dptr()));
            return this.times;
        }
    }

    class MOVC_A_DPTR_A
    extends AbstractOpcode {
        public MOVC_A_DPTR_A() {
            super(147, 1, 2, "MOVC\tA,@DPTR+A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.code(MCS51.this.dptr() + MCS51.this.acc()));
            return this.times;
        }
    }

    class MOV_A_DIRECT
    extends AbstractOpcode {
        public MOV_A_DIRECT() {
            super(229, 2, 1, "MOV\tA,%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.getDirectCode(pc + 1));
            return this.times;
        }
    }

    class MOV_DIRECT_DATA
    extends AbstractOpcode {
        public MOV_DIRECT_DATA() {
            super(117, 3, 2, "MOV\t%direct,#%byte");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    class MOV_BIT_C
    extends AbstractOpcode {
        public MOV_BIT_C() {
            super(146, 2, 2, "MOV\t%bit,C");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.setBit(MCS51.this.code(pc + 1), MCS51.this.cy());
            return this.times;
        }
    }

    class MOV_C_BIT
    extends AbstractOpcode {
        public MOV_C_BIT() {
            super(162, 2, 1, "MOV\tC,%bit");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.cy(MCS51.this.getBitCode(pc + 1));
            return this.times;
        }
    }

    class ORL_C_NBIT
    extends AbstractOpcode {
        public ORL_C_NBIT() {
            super(160, 2, 2, "ORL\tC,NOT %bit");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.cy(MCS51.this.cy() | !MCS51.this.getBitCode(pc + 1));
            return this.times;
        }
    }

    class ORL_C_BIT
    extends AbstractOpcode {
        public ORL_C_BIT() {
            super(114, 2, 2, "ORL\tC,%bit");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.cy(MCS51.this.getBitCode(pc + 1) | MCS51.this.cy());
            return this.times;
        }
    }

    class RLC_A
    extends AbstractOpcode {
        public RLC_A() {
            super(51, 1, 1, "RLC\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int a = MCS51.this.acc();
            a <<= 1;
            if (MCS51.this.cy()) {
                a |= 1;
            }
            MCS51.this.cy((a & 0x100) != 0);
            MCS51.this.acc(a);
            return this.times;
        }
    }

    class RRC_A
    extends AbstractOpcode {
        public RRC_A() {
            super(19, 1, 1, "RRC\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int a = MCS51.this.acc();
            a >>= 1;
            if (MCS51.this.cy()) {
                a |= 0x80;
            }
            MCS51.this.cy((MCS51.this.acc() & 1) != 0);
            MCS51.this.acc(a);
            return this.times;
        }
    }

    class SETB_C
    extends AbstractOpcode {
        public SETB_C() {
            super(211, 1, 1, "SETB\tC");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.cy(true);
            return this.times;
        }
    }

    class SETB_BIT
    extends AbstractOpcode {
        public SETB_BIT() {
            super(210, 2, 1, "SETB\t%bit");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.setBit(MCS51.this.code(pc + 1), true);
            return this.times;
        }
    }

    class RR_A
    extends AbstractOpcode {
        public RR_A() {
            super(3, 1, 1, "RR\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int a = MCS51.this.acc();
            a >>= 1;
            if ((MCS51.this.acc() & 1) != 0) {
                a |= 0x80;
            }
            MCS51.this.acc(a);
            return this.times;
        }
    }

    class RL_A
    extends AbstractOpcode {
        public RL_A() {
            super(35, 1, 1, "RL\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int a = MCS51.this.acc();
            a <<= 1;
            if ((MCS51.this.acc() & 0x80) != 0) {
                a |= 1;
            }
            MCS51.this.acc(a);
            return this.times;
        }
    }

    class RETI
    extends AbstractOpcode {
        public RETI() {
            super(50, 1, 2, "RETI");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.pc(MCS51.this.popw());
            MCS51.this.interruptInUse = false;
            return this.times;
        }
    }

    class RET
    extends AbstractOpcode {
        public RET() {
            super(34, 1, 2, "RET");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.pc(MCS51.this.popw());
            return this.times;
        }
    }

    class PUSH_DIRECT
    extends AbstractOpcode {
        public PUSH_DIRECT() {
            super(192, 2, 2, "PUSH\t%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.push(MCS51.this.getDirectCode(pc + 1));
            return this.times;
        }
    }

    class POP_DIRECT
    extends AbstractOpcode {
        public POP_DIRECT() {
            super(208, 2, 2, "POP\t%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.pop());
            return this.times;
        }
    }

    class MOV_DPTR_DATA16
    extends AbstractOpcode {
        public MOV_DPTR_DATA16() {
            super(144, 3, 2, "MOV\tDPTR,%word");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.dptr(MCS51.this.code(pc + 1) << 8 | MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    class LJMP
    extends AbstractOpcode {
        LJMP() {
            super(2, 3, 2, "LJMP\t%word");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.pc(MCS51.this.code16(pc + 1));
            return this.times;
        }
    }

    class LCALL
    extends AbstractOpcode {
        LCALL() {
            super(18, 3, 2, "LCALL\t%word");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int address = MCS51.this.code16(pc + 1);
            CallListener l = MCS51.this.getCallListener(address);
            if (l != null) {
                return l.call(MCS51.this, address);
            }
            MCS51.this.pushw(pc + 3);
            MCS51.this.pc(address);
            return this.times;
        }
    }

    class JMP_A_DPTR
    extends AbstractOpcode {
        JMP_A_DPTR() {
            super(115, 1, 2, "JMP\t@A+DPTR");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.pc(MCS51.this.dptr() + MCS51.this.acc());
            return this.times;
        }
    }

    class JZ
    extends JR {
        JZ() {
            super(96, 2, 2, "JZ\t%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            if (MCS51.this.acc() == 0) {
                this.jr(pc, MCS51.this.code(pc + 1));
            }
            return this.times;
        }
    }

    class JNZ
    extends JR {
        JNZ() {
            super(112, 2, 2, "JNZ\t%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            if (MCS51.this.acc() != 0) {
                this.jr(pc, MCS51.this.code(pc + 1));
            }
            return this.times;
        }
    }

    class JC
    extends JR {
        JC() {
            super(64, 2, 2, "JC\t%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            if (MCS51.this.cy()) {
                this.jr(pc, MCS51.this.code(pc + 1));
            }
            return this.times;
        }
    }

    class JNC
    extends JR {
        JNC() {
            super(80, 2, 2, "JNC\t%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            if (!MCS51.this.cy()) {
                this.jr(pc, MCS51.this.code(pc + 1));
            }
            return this.times;
        }
    }

    class JNB
    extends JR {
        JNB() {
            super(48, 3, 2, "JNB\t%bit,%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            boolean bit = MCS51.this.getBitCode(pc + 1);
            if (!bit) {
                this.jr(pc, MCS51.this.code(pc + 2));
            }
            return this.times;
        }
    }

    class JBC
    extends JR {
        JBC() {
            super(16, 3, 2, "JBC\t%bit,%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            if (MCS51.this.getBit(add)) {
                MCS51.this.setBit(add, false);
                this.jr(pc, MCS51.this.code(pc + 2));
            }
            return this.times;
        }
    }

    class JB
    extends JR {
        JB() {
            super(32, 3, 2, "JB\t%bit,%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            if (MCS51.this.getBitCode(pc + 1)) {
                this.jr(pc, MCS51.this.code(pc + 2));
            }
            return this.times;
        }
    }

    class INC_DPTR
    extends AbstractOpcode {
        INC_DPTR() {
            super(163, 1, 2, "INC\tDPTR");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.dptr(MCS51.this.dptr() + 1);
            return this.times;
        }
    }

    class INC_DIRECT
    extends AbstractOpcode {
        INC_DIRECT() {
            super(5, 2, 1, "INC\t%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int a = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(a, MCS51.this.getDirect(a) + 1);
            return this.times;
        }
    }

    class INC_A
    extends AbstractOpcode {
        INC_A() {
            super(4, 1, 1, "INC\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.acc() + 1);
            return this.times;
        }
    }

    class DJNZ_DIRECT
    extends DJNZ {
        DJNZ_DIRECT() {
            super(213, 3, 2, "DJNZ\t%direct,%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int address = MCS51.this.code(pc + 1);
            int value = MCS51.this.getDirect(address) - 1;
            MCS51.this.setDirect(address, value);
            this.jnz(pc, value);
            return this.times;
        }
    }

    class MUL_AB
    extends AbstractOpcode {
        public MUL_AB() {
            super(164, 1, 4, "MUL\tAB");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int value = MCS51.this.acc() * MCS51.this.b();
            MCS51.this.b(value >> 8);
            MCS51.this.acc(value);
            MCS51.this.cy(false);
            MCS51.this.ov(value > 255);
            return this.times;
        }
    }

    class DIV_AB
    extends AbstractOpcode {
        public DIV_AB() {
            super(132, 1, 4, "DIV\tAB");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int a = MCS51.this.acc();
            int b = MCS51.this.b();
            MCS51.this.acc(a / b);
            MCS51.this.b(a % b);
            MCS51.this.cy(false);
            MCS51.this.ov(false);
            return this.times;
        }
    }

    class DEC_DIRECT
    extends AbstractOpcode {
        public DEC_DIRECT() {
            super(21, 2, 1, "DEC\t%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int direct = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(direct, MCS51.this.getDirect(direct) - 1);
            return this.times;
        }
    }

    class DEC_A
    extends AbstractOpcode {
        public DEC_A() {
            super(20, 1, 1, "DEC\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.acc() - 1);
            return this.times;
        }
    }

    class SWAP_A
    extends AbstractOpcode {
        public SWAP_A() {
            super(196, 1, 1, "SWAP\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int a = MCS51.this.acc();
            MCS51.this.acc(a >> 4 & 0xF | a << 4);
            return this.times;
        }
    }

    class XCH_A_DIRECT
    extends AbstractOpcode {
        public XCH_A_DIRECT() {
            super(197, 2, 1, "XCH\tA,%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            int tmp = MCS51.this.acc();
            MCS51.this.acc(MCS51.this.getDirect(add));
            MCS51.this.setDirect(add, tmp);
            return this.times;
        }
    }

    class DA_A
    extends AbstractOpcode {
        public DA_A() {
            super(212, 1, 1, "DA\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int a = MCS51.this.acc();
            if (((a & 0xF) > 9 || MCS51.this.ac()) && ((a += 6) & 0xF0) != (MCS51.this.acc() & 0xF0)) {
                MCS51.this.cy(true);
            }
            if (((a & 0xF0) > 144 || MCS51.this.cy()) && (a += 96) > 255) {
                MCS51.this.cy(true);
            }
            MCS51.this.acc(a);
            return this.times;
        }
    }

    class CPL_BIT
    extends AbstractOpcode {
        public CPL_BIT() {
            super(178, 2, 1, "CPL\t%bit");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int bit;
            MCS51.this.setBit(bit, !MCS51.this.getBit(bit = MCS51.this.code(pc + 1)));
            return this.times;
        }
    }

    class CPL_C
    extends AbstractOpcode {
        public CPL_C() {
            super(179, 1, 1, "CPL\tC");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.cy(!MCS51.this.cy());
            return this.times;
        }
    }

    class CPL_A
    extends AbstractOpcode {
        public CPL_A() {
            super(244, 1, 1, "CPL\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(~MCS51.this.acc());
            return this.times;
        }
    }

    class CLR_BIT
    extends AbstractOpcode {
        public CLR_BIT() {
            super(194, 2, 1, "CLR\t%bit");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.setBit(MCS51.this.code(pc + 1), false);
            return this.times;
        }
    }

    class CLR_C
    extends AbstractOpcode {
        public CLR_C() {
            super(195, 1, 1, "CLR\tC");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.cy(false);
            return this.times;
        }
    }

    class CLR_A
    extends AbstractOpcode {
        public CLR_A() {
            super(228, 1, 1, "CLR\tA");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(0);
            return this.times;
        }
    }

    class ORL_DIRECT_DATA
    extends AbstractOpcode {
        ORL_DIRECT_DATA() {
            super(67, 3, 2, "ORL\t%direct,#%byte");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.getDirect(add) | MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    class ORL_DIRECT_A
    extends AbstractOpcode {
        ORL_DIRECT_A() {
            super(66, 2, 1, "ORL\t%direct,A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.getDirect(add) | MCS51.this.acc());
            return this.times;
        }
    }

    class XRL_DIRECT_DATA
    extends AbstractOpcode {
        XRL_DIRECT_DATA() {
            super(99, 3, 2, "XRL\t%direct,#%byte");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.getDirect(add) ^ MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    class XRL_DIRECT_A
    extends AbstractOpcode {
        XRL_DIRECT_A() {
            super(98, 2, 1, "XRL\t%direct,A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.getDirect(add) ^ MCS51.this.acc());
            return this.times;
        }
    }

    class XCHD_A_RI
    extends AbstractOpcode {
        public XCHD_A_RI(int r) {
            super(0xD6 | r, 1, 1, "XCHD\tA,%ri");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int r = MCS51.this.r(this.opcode & 1);
            int tmp = MCS51.this.acc();
            MCS51.this.acc(MCS51.this.acc() & 0xF0 | MCS51.this.data(r) & 0xF);
            MCS51.this.data(r, MCS51.this.data(r) & 0xF0 | tmp & 0xF);
            return this.times;
        }
    }

    class XCH_A_RI
    extends AbstractOpcode {
        public XCH_A_RI(int r) {
            super(0xC6 | r, 1, 1, "XCH\tA,%ri");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int r = MCS51.this.r(this.opcode & 1);
            int tmp = MCS51.this.acc();
            MCS51.this.acc(MCS51.this.data(r));
            MCS51.this.data(r, tmp);
            return this.times;
        }
    }

    class MOVX_RI_A
    extends AbstractOpcode {
        public MOVX_RI_A(int r) {
            super(0xF2 | r, 1, 2, "MOVX\t%ri,A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int offset = MCS51.this.getXdataHi() << 8;
            MCS51.this.xdata(offset += MCS51.this.r(this.opcode & 1), MCS51.this.acc());
            return this.times;
        }
    }

    class MOVX_A_RI
    extends AbstractOpcode {
        public MOVX_A_RI(int r) {
            super(0xE2 | r, 1, 2, "MOVX\tA,%ri");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int offset = MCS51.this.getXdataHi() << 8;
            MCS51.this.acc(MCS51.this.xdata(offset += MCS51.this.r(this.opcode & 1)));
            return this.times;
        }
    }

    class MOV_RI_DIRECT
    extends AbstractOpcode {
        public MOV_RI_DIRECT(int r) {
            super(0xA6 | r, 2, 2, "MOV\t%ri,%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.r(this.opcode & 1);
            MCS51.this.data(add, MCS51.this.getDirectCode(pc + 1));
            return this.times;
        }
    }

    class MOV_RI_DATA
    extends AbstractOpcode {
        public MOV_RI_DATA(int r) {
            super(0x76 | r, 2, 1, "MOV\t%ri,%byte");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.r(this.opcode & 1);
            MCS51.this.data(add, MCS51.this.code(pc + 1));
            return this.times;
        }
    }

    class MOV_DIRECT_RI
    extends AbstractOpcode {
        public MOV_DIRECT_RI(int r) {
            super(0x86 | r, 2, 2, "MOV\t%direct,%ri");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.data(MCS51.this.r(this.opcode & 1)));
            return this.times;
        }
    }

    class MOV_RI_A
    extends AbstractOpcode {
        public MOV_RI_A(int r) {
            super(0xF6 | r, 1, 1, "MOV\t%ri,A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.r(this.opcode & 1);
            MCS51.this.data(add, MCS51.this.acc());
            return this.times;
        }
    }

    class MOV_A_RI
    extends AbstractOpcode {
        public MOV_A_RI(int r) {
            super(0xE6 | r, 1, 1, "MOV\tA,%ri");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.data(MCS51.this.r(this.opcode & 1)));
            return this.times;
        }
    }

    class INC_RI
    extends AbstractOpcode {
        INC_RI(int r) {
            super(6 | r, 1, 1, "INC\t%ri");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int i = MCS51.this.r(this.opcode & 1);
            MCS51.this.setDirect(i, MCS51.this.getDirect(i) + 1);
            return this.times;
        }
    }

    class DEC_RI
    extends AbstractOpcode {
        public DEC_RI(int r) {
            super(0x16 | r, 1, 1, "DEC\t%ri");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int address = MCS51.this.r(this.opcode & 1);
            MCS51.this.data(address, MCS51.this.data(address) - 1);
            return this.times;
        }
    }

    class CJNE_RI_DATA
    extends CJNE {
        CJNE_RI_DATA(int r) {
            super(182 + r, 3, 2, "CJNE\t%ri,%byte,%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            this.cjne(pc, MCS51.this.data(MCS51.this.r(this.opcode & 1)), MCS51.this.code(pc + 1), MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    class XCH_A_R
    extends AbstractOpcode {
        public XCH_A_R(int r) {
            super(0xC8 | r, 1, 1, "XCH\tA,%reg");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int r = this.opcode & 7;
            int tmp = MCS51.this.acc();
            MCS51.this.acc(MCS51.this.r(r));
            MCS51.this.r(r, tmp);
            return this.times;
        }
    }

    class MOV_DIRECT_R
    extends AbstractOpcode {
        public MOV_DIRECT_R(int r) {
            super(0x88 | r, 2, 2, "MOV\t%direct,%reg");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.r(this.opcode & 7));
            return this.times;
        }
    }

    class MOV_R_DATA
    extends AbstractOpcode {
        public MOV_R_DATA(int r) {
            super(0x78 | r, 2, 1, "MOV\t%reg,%byte");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.r(this.opcode & 7, MCS51.this.code(pc + 1));
            return this.times;
        }
    }

    class MOV_R_DIRECT
    extends AbstractOpcode {
        public MOV_R_DIRECT(int r) {
            super(0xA8 | r, 2, 2, "MOV\t%reg,%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.r(this.opcode & 7, MCS51.this.getDirectCode(pc + 1));
            return this.times;
        }
    }

    class MOV_R_A
    extends AbstractOpcode {
        public MOV_R_A(int r) {
            super(0xF8 | r, 1, 1, "MOV\t%reg,A");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.r(this.opcode & 7, MCS51.this.acc());
            return this.times;
        }
    }

    class MOV_A_R
    extends AbstractOpcode {
        public MOV_A_R(int r) {
            super(0xE8 | r, 1, 1, "MOV\tA,%reg");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.acc(MCS51.this.r(this.opcode & 7));
            return this.times;
        }
    }

    class INC_R
    extends AbstractOpcode {
        INC_R(int r) {
            super(8 | r, 1, 1, "INC\t%reg");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int r = this.opcode & 7;
            MCS51.this.r(r, MCS51.this.r(r) + 1);
            return this.times;
        }
    }

    class DJNZ_R
    extends DJNZ {
        DJNZ_R(int r) {
            super(0xD8 | r, 2, 2, "DJNZ\t%reg");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int r = this.opcode & 7;
            int value = MCS51.this.r(r) - 1;
            MCS51.this.r(r, value);
            this.jnz(pc, value);
            return this.times;
        }
    }

    abstract class DJNZ
    extends JR {
        DJNZ(int opcode, int len, int cycle, String desc) {
            super(opcode, len, cycle, desc);
        }

        protected void jnz(int pc, int value) throws SIMException {
            if ((value &= 0xFF) != 0) {
                this.jr(pc, MCS51.this.code(pc + this.getLength() - 1));
            }
        }
    }

    class DEC_R
    extends AbstractOpcode {
        public DEC_R(int r) {
            super(0x18 | r, 1, 1, "DEC\t%reg");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int r = this.opcode & 7;
            MCS51.this.r(r, MCS51.this.r(r) - 1);
            return this.times;
        }
    }

    class CJNE_R_DATA
    extends CJNE {
        CJNE_R_DATA(int r) {
            super(184 + r, 3, 2, "CJNE\t%reg,#%byte,%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            this.cjne(pc, MCS51.this.r(this.opcode & 7), MCS51.this.code(pc + 1), MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    class CJNE_A_DATA
    extends CJNE {
        CJNE_A_DATA() {
            super(180, 3, 2, "CJNE\tA,#%byte,%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            this.cjne(pc, MCS51.this.acc(), MCS51.this.code(pc + 1), MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    class CJNE_A_DIRECT
    extends CJNE {
        CJNE_A_DIRECT() {
            super(181, 3, 2, "CJNE\tA,%direct,%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            this.cjne(pc, MCS51.this.acc(), MCS51.this.getDirectCode(pc + 1), MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    abstract class CJNE
    extends JR {
        CJNE(int opcode, int len, int cycle, String desc) {
            super(opcode, len, cycle, desc);
        }

        protected void cjne(int pc, int op1, int op2, int offset) throws SIMException {
            if (op1 < op2) {
                MCS51.this.cy(true);
            } else {
                MCS51.this.cy(false);
            }
            if (op1 != op2) {
                this.jr(pc, offset);
            }
        }
    }

    class SJMP
    extends JR {
        SJMP() {
            super(128, 2, 2, "SJMP\t%offset");
        }

        @Override
        public int exec(int pc) throws SIMException {
            this.jr(pc, MCS51.this.code(pc + 1));
            return this.times;
        }
    }

    abstract class JR
    extends AbstractOpcode {
        JR(int opcode, int len, int cycle, String desc) {
            super(opcode, len, cycle, desc);
        }

        protected final void jr(int pc, int offset) throws SIMException {
            MCS51.this.pc(pc + this.length + (offset - ((offset & 0x80) << 1)));
        }
    }

    class ANL_C_NOT_DIRECT
    extends AbstractOpcode {
        ANL_C_NOT_DIRECT() {
            super(176, 2, 2, "ANL\tC,NOT %bit");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.cy(!(MCS51.this.getBit(MCS51.this.code(pc + 1)) & MCS51.this.cy()));
            return this.times;
        }
    }

    class ANL_C_DIRECT
    extends AbstractOpcode {
        ANL_C_DIRECT() {
            super(130, 2, 2, "ANL\tC,%bit");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.cy(MCS51.this.getBit(MCS51.this.code(pc + 1)) & MCS51.this.cy());
            return this.times;
        }
    }

    class ANL_DIRECT_DATA
    extends AbstractOpcode {
        ANL_DIRECT_DATA() {
            super(83, 3, 2, "ANL\t%direct,#%byte");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.getDirect(add) & MCS51.this.code(pc + 2));
            return this.times;
        }
    }

    class ANL_DIRECT_A
    extends AbstractOpcode {
        ANL_DIRECT_A() {
            super(82, 2, 1, "ANL\tA,%direct");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1);
            MCS51.this.setDirect(add, MCS51.this.getDirect(add) & MCS51.this.acc());
            return this.times;
        }
    }

    class ArithmeticSUBB
    extends ArithmeticADDC {
        ArithmeticSUBB() {
        }

        @Override
        protected boolean op(int acc, int value, int c, int mask) {
            this.result = (acc & mask) - (value & mask) - c;
            return (this.result & mask + 1) != 0;
        }
    }

    class ArithmeticXRL
    implements ArithmeticOperation {
        ArithmeticXRL() {
        }

        @Override
        public void calc(int value) throws SIMException {
            MCS51.this.acc(MCS51.this.acc() ^ value);
        }
    }

    class ArithmeticORL
    implements ArithmeticOperation {
        ArithmeticORL() {
        }

        @Override
        public void calc(int value) throws SIMException {
            MCS51.this.acc(MCS51.this.acc() | value);
        }
    }

    class ArithmeticANL
    implements ArithmeticOperation {
        ArithmeticANL() {
        }

        @Override
        public void calc(int value) throws SIMException {
            MCS51.this.acc(MCS51.this.acc() & value);
        }
    }

    class ArithmeticADDC
    extends ArithmeticADD {
        ArithmeticADDC() {
        }

        @Override
        public void calc(int value) throws SIMException {
            int c = MCS51.this.cy() ? 1 : 0;
            this.add(value, c);
        }
    }

    class ArithmeticADD
    implements ArithmeticOperation {
        protected int result;

        ArithmeticADD() {
        }

        protected boolean op(int acc, int value, int c, int mask) {
            this.result = (acc & mask) + (value & mask) + c;
            return (this.result & mask + 1) != 0;
        }

        protected void add(int value, int c) throws SIMException {
            int acc = MCS51.this.acc();
            MCS51.this.ac(this.op(acc, value, c, 15));
            boolean cy7 = this.op(acc, value, c, 127);
            MCS51.this.cy(this.op(acc, value, c, 255));
            MCS51.this.ov(MCS51.this.cy() != cy7);
            MCS51.this.acc(this.result);
        }

        @Override
        public void calc(int value) throws SIMException {
            this.add(value, 0);
        }
    }

    abstract class Arithmetic
    extends AbstractOpcode {
        ArithmeticOperation operation;

        public Arithmetic(int opcode, int length, ArithmeticOperation op, String name) {
            super(opcode, length, 1, name);
            this.operation = op;
        }

        @Override
        public int exec(int pc) throws SIMException {
            this.operation.calc(this.getValue(pc));
            return this.times;
        }

        abstract int getValue(int var1) throws SIMException;
    }

    static interface ArithmeticOperation {
        public void calc(int var1) throws SIMException;
    }

    class AJMP
    extends ACALL {
        public AJMP(int opcode) {
            super(opcode, "AJMP\t%data12");
        }

        @Override
        public int exec(int pc) throws SIMException {
            MCS51.this.pc(this.getAddress(pc));
            return this.times;
        }
    }

    class ACALL
    extends AbstractOpcode {
        public ACALL(int opcode) {
            super(opcode, 2, 2, "ACALL\t%data12");
        }

        protected ACALL(int opcode, String name) {
            super(opcode, 2, 2, name);
        }

        protected int getAddress(int pc) throws SIMException {
            int add = MCS51.this.code(pc + 1) | this.opcode << 3 & 0x700;
            return add |= pc + 2 & 0xF800;
        }

        @Override
        public int exec(int pc) throws SIMException {
            int address = this.getAddress(pc);
            CallListener l = MCS51.this.getCallListener(address);
            if (l != null) {
                return l.call(MCS51.this, address);
            }
            MCS51.this.pushw(pc + 2);
            MCS51.this.pc(this.getAddress(pc));
            return this.times;
        }
    }

    class Register8051
    extends MemoryRegister {
        private int r;

        Register8051(int n) {
            super(MCS51.this.data, n, "R" + n, 10, 8);
            this.r = n;
        }

        @Override
        public final void setRegister(int value) throws SIMException {
            this.setIndex((MCS51.this.sfr.getMemory(208) & 0x18) + this.r);
            super.setRegister(value);
        }

        @Override
        public final int getRegister() throws SIMException {
            this.setIndex((MCS51.this.sfr.getMemory(208) & 0x18) + this.r);
            return super.getRegister();
        }
    }
}

