/*
 * Decompiled with CFR 0.152.
 */
package jmce.mos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JComponent;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.CycleListener;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.SwingHardware;
import jmce.swing.Repaintable;
import jmce.swing.Util;
import jmce.util.Hex;
import jmce.util.Logger;

public class VIC6561
extends AbstractPeripheral
implements MemoryWriteListener,
MemoryReadListener,
SwingHardware,
CycleListener {
    private static Logger log = Logger.getLogger(VIC6561.class);
    public static int sample = 44100;
    int ncycle;
    protected int scaleWidth = 1;
    protected int scaleHeight = 1;
    protected int sizeWidth = 176;
    protected int sizeHeight = 184;
    public static final int[] noisepattern = new int[]{7, 30, 30, 28, 28, 62, 60, 56, 120, 248, 124, 30, 31, 143, 7, 7, 193, 192, 224, 241, 224, 240, 227, 225, 192, 224, 120, 126, 60, 56, 224, 225, 195, 195, 135, 199, 7, 30, 28, 31, 14, 14, 30, 14, 15, 15, 195, 195, 241, 225, 227, 193, 227, 195, 195, 252, 60, 30, 15, 131, 195, 193, 193, 195, 195, 199, 135, 135, 199, 15, 14, 60, 124, 120, 60, 60, 60, 56, 62, 28, 124, 30, 60, 15, 14, 62, 120, 240, 240, 224, 225, 241, 193, 195, 199, 195, 225, 241, 224, 225, 240, 241, 227, 192, 240, 224, 248, 112, 227, 135, 135, 192, 240, 224, 241, 225, 225, 199, 131, 135, 131, 143, 135, 135, 199, 131, 195, 131, 195, 241, 225, 195, 199, 129, 207, 135, 3, 135, 199, 199, 135, 131, 225, 195, 7, 195, 135, 135, 7, 135, 195, 135, 131, 225, 195, 199, 195, 135, 135, 143, 15, 135, 135, 15, 207, 31, 135, 142, 14, 7, 129, 195, 227, 193, 224, 240, 224, 227, 131, 135, 7, 135, 142, 30, 15, 7, 135, 143, 31, 7, 135, 193, 240, 225, 225, 227, 199, 15, 3, 143, 135, 14, 30, 30, 15, 135, 135, 15, 135, 31, 15, 195, 195, 240, 248, 240, 112, 241, 240, 240, 225, 240, 224, 120, 124, 120, 124, 112, 113, 225, 225, 195, 195, 199, 135, 28, 60, 60, 28, 60, 124, 30, 30, 30, 28, 60, 120, 248, 248, 225, 195, 135, 30, 30, 60, 62, 15, 15, 135, 31, 142, 15, 15, 142, 30, 30, 30, 30, 15, 15, 143, 135, 135, 195, 131, 193, 225, 195, 193, 195, 199, 143, 15, 15, 15, 15, 131, 199, 195, 193, 225, 224, 248, 62, 60, 60, 60, 60, 60, 120, 62, 30, 30, 30, 15, 15, 15, 30, 14, 30, 30, 15, 15, 135, 31, 135, 135, 28, 62, 31, 15, 15, 142, 62, 14, 62, 30, 28, 60, 124, 252, 56, 120, 120, 56, 120, 112, 248, 124, 30, 60, 60, 48, 241, 240, 112, 112, 224, 248, 240, 248, 120, 120, 113, 225, 240, 227, 193, 240, 113, 227, 199, 135, 142, 62, 14, 30, 62, 15, 7, 135, 12, 62, 15, 135, 15, 30, 60, 60, 56, 120, 241, 231, 195, 195, 199, 142, 60, 56, 240, 224, 126, 30, 62, 14, 15, 15, 15, 3, 195, 195, 199, 135, 31, 14, 30, 28, 60, 60, 15, 7, 7, 199, 199, 135, 135, 143, 15, 192, 240, 248, 96, 240, 240, 225, 227, 227, 195, 195, 195, 135, 15, 135, 142, 30, 30, 63, 30, 14, 28, 60, 126, 30, 60, 56, 120, 120, 120, 56, 120, 60, 225, 227, 143, 31, 28, 120, 112, 126, 15, 135, 7, 195, 199, 15, 30, 60, 14, 15, 14, 30, 3, 240, 240, 241, 227, 193, 199, 192, 225, 225, 225, 225, 224, 112, 225, 240, 120, 112, 227, 199, 15, 193, 225, 227, 195, 192, 240, 252, 28, 60, 112, 248, 112, 248, 120, 60, 112, 240, 120, 112, 124, 124, 60, 56, 30, 62, 60, 126, 7, 131, 199, 193, 193, 225, 195, 195, 195, 225, 225, 240, 120, 124, 62, 15, 31, 7, 143, 15, 131, 135, 193, 227, 227, 195, 195, 225, 240, 248, 240, 60, 124, 60, 15, 142, 14, 31, 31, 14, 60, 56, 120, 112, 112, 240, 240, 248, 112, 112, 120, 56, 60, 112, 224, 240, 120, 241, 240, 120, 62, 60, 15, 7, 14, 62, 30, 63, 30, 14, 15, 135, 135, 7, 15, 7, 199, 143, 15, 135, 30, 30, 31, 30, 30, 60, 30, 28, 62, 15, 3, 195, 129, 224, 240, 252, 56, 60, 62, 14, 30, 28, 124, 30, 31, 14, 62, 28, 120, 120, 124, 30, 62, 30, 60, 31, 15, 31, 15, 15, 143, 28, 60, 120, 248, 240, 248, 112, 240, 120, 120, 60, 60, 120, 60, 31, 15, 7, 134, 28, 30, 28, 30, 30, 31, 3, 195, 199, 142, 60, 60, 28, 24, 240, 225, 195, 225, 193, 225, 227, 195, 195, 227, 195, 131, 135, 131, 135, 15, 7, 7, 225, 225, 224, 124, 120, 56, 120, 120, 60, 31, 15, 143, 14, 7, 15, 7, 131, 195, 195, 129, 240, 248, 241, 224, 227, 199, 28, 62, 30, 15, 15, 195, 240, 240, 227, 131, 195, 199, 7, 15, 15, 15, 15, 15, 7, 135, 15, 15, 14, 15, 15, 30, 15, 15, 135, 135, 135, 143, 199, 199, 131, 131, 195, 199, 143, 135, 7, 195, 142, 30, 56, 62, 60, 56, 124, 31, 28, 56, 60, 120, 124, 30, 28, 60, 63, 30, 14, 62, 28, 60, 31, 15, 7, 195, 227, 131, 135, 129, 193, 227, 207, 14, 15, 30, 62, 30, 31, 15, 143, 195, 135, 14, 3, 240, 240, 112, 224, 225, 225, 199, 142, 15, 15, 30, 14, 30, 31, 28, 120, 240, 241, 241, 224, 241, 225, 225, 224, 224, 241, 193, 240, 113, 225, 195, 131, 199, 131, 225, 225, 248, 112, 240, 240, 240, 240, 240, 112, 248, 112, 112, 97, 224, 240, 225, 224, 120, 113, 224, 240, 248, 56, 30, 28, 56, 112, 248, 96, 120, 56, 60, 63, 31, 15, 31, 15, 31, 135, 135, 131, 135, 131, 225, 225, 240, 120, 241, 240, 112, 56, 56, 112, 224, 227, 192, 224, 248, 120, 120, 248, 56, 241, 225, 225, 195, 135, 135, 14, 30, 31, 14, 14, 15, 15, 135, 195, 135, 7, 131, 192, 240, 56, 60, 60, 56, 240, 252, 62, 30, 28, 28, 56, 112, 240, 241, 224, 240, 224, 224, 241, 227, 224, 225, 240, 240, 120, 124, 120, 60, 120, 120, 56, 120, 120, 120, 120, 112, 227, 131, 131, 224, 195, 193, 225, 193, 193, 193, 227, 195, 199, 30, 14, 31, 30, 30, 15, 15, 14, 14, 14, 7, 131, 135, 135, 14, 7, 143, 15, 15, 15, 14, 28, 112, 225, 224, 113, 193, 131, 131, 135, 15, 30, 24, 120, 120, 124, 62, 28, 56, 240, 225, 224, 120, 112, 56, 60, 62, 30, 60, 30, 28, 112, 60, 56, 63};
    private static Color[] colors = new Color[]{new Color(0), new Color(0xFFFFFF), new Color(0xF00000), new Color(61680), new Color(0x600060), new Color(40960), new Color(240), new Color(0xD0D000), new Color(0xC0A000), new Color(0xFFA000), new Color(0xF08080), new Color(65535), new Color(0xFF00FF), new Color(65280), new Color(41215), new Color(0xFFFF00)};
    private int[] cr = new int[16];
    private Color[] multiColors = new Color[4];
    private VIC6561Oscillator[] channels = new VIC6561Oscillator[4];
    public static final int CR2 = 2;
    public static final int CR3 = 3;
    public static final int CR5 = 5;
    public static final int CRE = 14;
    public static final int CRF = 15;
    private int base = 0;
    private int videoRam = 0;
    private int charRam = 0;
    private int colourRam = 0;
    private int numColumns = 22;
    private int numRows = 23;
    private VIC6561Component comp = new VIC6561Component();
    private SourceDataLine line;
    int cyclePerSample;
    int cycle;
    int bufferPtr;
    byte[] buffer = new byte[0];

    public VIC6561() {
        this.setName("VIC6561");
        this.channels[0] = new VIC6561Oscillator(10, 4);
        this.channels[1] = new VIC6561Oscillator(11, 3);
        this.channels[2] = new VIC6561Oscillator(12, 2);
        this.channels[3] = new VIC6561Oscillator(13, 4);
        try {
            AudioFormat fmt = new AudioFormat(sample, 8, 1, false, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, fmt);
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(fmt);
            this.line.start();
            log.info("Line installed at " + sample + " sample rate");
        }
        catch (Exception ex) {
            System.out.println(ex);
            this.line = null;
        }
    }

    public void setSizeWidth(int n) {
        this.sizeWidth = n;
    }

    public void setSizeHeight(int n) {
        this.sizeHeight = n;
    }

    public void setScaleWidth(int n) {
        this.scaleWidth = n;
    }

    public void setScaleHeight(int n) {
        this.scaleHeight = n;
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public int convertAddress(int add) {
        return add;
    }

    protected int getVideoByte(int add) throws SIMException {
        int target = this.convertAddress(add);
        int b = this.cpu.getByte(target);
        return b;
    }

    private boolean checkRange(int video, int size, int add) {
        int target = this.convertAddress(video);
        return add >= target && add <= target + size;
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        for (int i = 0; i < 16; ++i) {
            cpu.addIOWriteListener(this.base + i, this);
            cpu.addIOReadListener(this.base + i, this);
        }
        cpu.addMemoryWriteListener(new MemoryWriteListener(){

            @Override
            public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
                if (VIC6561.this.checkRange(VIC6561.this.videoRam, 512, address)) {
                    VIC6561.this.updateComponent();
                }
                if (VIC6561.this.checkRange(VIC6561.this.colourRam, 512, address)) {
                    VIC6561.this.updateComponent();
                }
            }
        });
        this.setClock(cpu.getClock());
        cpu.addCycleListener(this);
    }

    void setClock(long clock) {
        int n = (int)(clock / (long)sample);
        if (n != this.cyclePerSample) {
            this.cyclePerSample = n;
            this.buffer = new byte[sample / 50];
            this.bufferPtr = 0;
            log.info("CyclePerSample=" + this.cyclePerSample);
        }
    }

    @Override
    public int readMemory(Memory memory, int address, int value) throws SIMException {
        return this.cr[address &= 0xF];
    }

    @Override
    public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
        if (this.cr[address &= 0xF] != value) {
            log.info("Changed CR" + address + " from " + Hex.formatByte(this.cr[address]) + " to " + Hex.formatByte(value));
            this.cr[address] = value;
            this.updateRegister();
        }
    }

    private void updateComponent() {
        Util.repaintLater(this.comp);
    }

    private void updateRegister() {
        this.numColumns = this.cr[2] & 0x7F;
        this.numRows = this.cr[3] >> 1 & 0x3F;
        this.videoRam = (this.cr[2] & 0x80) << 2 | (this.cr[5] & 0xF0) << 6;
        this.charRam = (this.cr[5] & 0xF) << 10;
        this.colourRam = 5120 + 4 * (this.cr[2] & 0x80);
        this.multiColors[0] = colors[this.cr[15] >> 4];
        this.multiColors[1] = colors[this.cr[15] & 7];
        this.multiColors[3] = colors[this.cr[14] >> 4];
        this.updateComponent();
        log.info("VIC VRAM=" + Hex.formatWord(this.videoRam) + " CGRAM=" + Hex.formatWord(this.charRam) + " CRAM=" + Hex.formatWord(this.colourRam));
        log.info("CPU VRAM=" + Hex.formatWord(this.convertAddress(this.videoRam)) + " CGRAM=" + Hex.formatWord(this.convertAddress(this.charRam)) + " CRAM=" + Hex.formatWord(this.convertAddress(this.colourRam)));
    }

    @Override
    public Component getComponent() {
        return this.comp;
    }

    @Override
    public void cycle(int n) throws SIMException {
        if (this.line == null) {
            return;
        }
        while (n-- > 0) {
            boolean value = false;
            for (int i = 0; i < this.channels.length; ++i) {
                value |= this.channels[i].cycle();
            }
            if (this.bufferPtr >= this.buffer.length) {
                if (this.line.available() >= this.buffer.length) {
                    this.line.write(this.buffer, 0, this.buffer.length);
                }
                this.bufferPtr = 0;
            }
            if (++this.cycle < this.cyclePerSample) continue;
            int v = 0;
            if (value) {
                v = 255;
            }
            v *= this.cr[14] & 0xF;
            this.buffer[this.bufferPtr++] = (byte)(v /= 15);
            this.cycle = 0;
        }
    }

    @Override
    public String toString() {
        return this.getName() + " at 0x" + Hex.formatWord(this.base);
    }

    class VIC6561Component
    extends JComponent
    implements Repaintable {
        private static final long serialVersionUID = 1L;
        private Dimension size = null;

        VIC6561Component() {
        }

        @Override
        public void updateComponent() {
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.size == null) {
                this.size = new Dimension(VIC6561.this.scaleWidth * VIC6561.this.sizeWidth, VIC6561.this.scaleHeight * VIC6561.this.sizeHeight);
                log.info(VIC6561.this + " SIZE=" + this.size);
            }
            return this.size;
        }

        @Override
        public void paintComponent(Graphics g) {
            Insets insets = this.getInsets();
            g.translate(insets.left, insets.top);
            g.setColor(VIC6561.this.multiColors[1]);
            g.fillRect(0, 0, this.size.width, this.size.height);
            for (int r = 0; r < VIC6561.this.numRows; ++r) {
                for (int c = 0; c < VIC6561.this.numColumns; ++c) {
                    try {
                        this.paintChar(g, r, c);
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }

        void paintChar(Graphics g, int r, int c) throws SIMException {
            int ch = VIC6561.this.getVideoByte(r * VIC6561.this.numColumns + c + VIC6561.this.videoRam);
            int color = VIC6561.this.getVideoByte(r * VIC6561.this.numColumns + c + VIC6561.this.colourRam);
            Point origin = new Point((VIC6561.this.cr[0] & 0x7F) * VIC6561.this.scaleWidth, VIC6561.this.cr[1] * VIC6561.this.scaleHeight);
            if ((color & 8) != 0) {
                ((VIC6561)VIC6561.this).multiColors[2] = colors[color & 7];
                for (int y = 0; y < 8; ++y) {
                    int mask = VIC6561.this.getVideoByte(VIC6561.this.charRam + ch * 8 + y);
                    for (int x = 0; x < 4; ++x) {
                        int cl = (mask & 0xC0) >> 6;
                        mask <<= 2;
                        g.setColor(VIC6561.this.multiColors[cl & 3]);
                        g.fillRect(origin.x + (c * 8 + x * 2) * VIC6561.this.scaleWidth, origin.y + (r * 8 + y) * VIC6561.this.scaleHeight, VIC6561.this.scaleWidth * 2, VIC6561.this.scaleHeight);
                    }
                }
            } else {
                Color bg = VIC6561.this.multiColors[0];
                Color fg = colors[color & 7];
                if ((VIC6561.this.cr[15] & 8) == 0) {
                    Color tmp = fg;
                    fg = bg;
                    bg = tmp;
                }
                for (int y = 0; y < 8; ++y) {
                    int mask = VIC6561.this.getVideoByte(VIC6561.this.charRam + ch * 8 + y);
                    for (int x = 0; x < 8; ++x) {
                        if ((mask & 0x80) != 0) {
                            g.setColor(fg);
                        } else {
                            g.setColor(bg);
                        }
                        mask <<= 1;
                        g.fillRect(origin.x + (c * 8 + x) * VIC6561.this.scaleWidth, origin.y + (r * 8 + y) * VIC6561.this.scaleHeight, VIC6561.this.scaleWidth, VIC6561.this.scaleHeight);
                    }
                }
            }
        }
    }

    class VIC6561Oscillator {
        int reg;
        int shift;
        boolean value;
        int counter;
        int noisectr;
        int osc;

        VIC6561Oscillator(int reg, int shift) {
            this.reg = reg;
            this.shift = shift;
        }

        boolean cycle() {
            if ((VIC6561.this.cr[this.reg] & 0x80) == 0) {
                return false;
            }
            if (this.counter == 0) {
                if (this.reg == 13) {
                    boolean bl = this.value = (noisepattern[this.noisectr >> 3 & 0x3FF] >> (this.noisectr & 7) & 1) != 0;
                    if (++this.noisectr > 1024) {
                        this.noisectr -= 1024;
                    }
                } else {
                    this.osc = (this.osc << 1 | (this.osc & 0x80) >>> 7) ^ 1;
                    this.osc &= 0xFF;
                    this.value = (this.osc & 1) != 0;
                }
                this.counter = ~VIC6561.this.cr[this.reg] & 0x7F;
                if (this.counter == 0) {
                    this.counter = 128;
                }
                this.counter <<= this.shift;
            }
            --this.counter;
            return this.value;
        }
    }
}

