/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.BreakPointListener;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.util.Hex;

public abstract class BreakPoint {
    protected int address;
    protected boolean enabled;
    protected boolean enabled1;
    protected Memory memory;
    protected int fireCounter;
    protected BreakPointListener listener;
    protected String name;
    protected CPU cpu;

    BreakPoint(CPU cpu, String name, BreakPointListener l, Memory memory, int address) {
        this.cpu = cpu;
        this.name = name;
        this.memory = memory;
        this.address = address;
        this.enabled = true;
        this.fireCounter = 0;
        this.listener = l;
    }

    public final int getAddress() {
        return this.address;
    }

    public final Memory getMemory() {
        return this.memory;
    }

    public final void setEnabled(boolean mode) {
        this.enabled = mode;
    }

    public final void setEnabled1(boolean mode) {
        this.enabled1 = mode;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    protected String formatMsg(int address, int value) {
        return this.name + " Memory=" + this.memory.getName() + " at " + Hex.formatWord(address) + " Value=" + Hex.formatByte(value);
    }

    public int getFireCount() {
        return this.fireCounter;
    }

    public void fireBreakPoint(String msg) {
        ++this.fireCounter;
        this.listener.breakPointEvent(this, msg);
    }

    public abstract void destroy();

    public String toString() {
        return "BP " + this.name + " Memory=" + this.memory.getName() + "  at " + Hex.formatWord(this.address);
    }
}

