/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.LoadInfo;
import jmce.sim.LoadableListener;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.util.FastArray;
import jmce.util.Hex;
import jmce.util.Logger;

public class Loadable
extends AbstractPeripheral
implements ResetListener {
    private static Logger log = Logger.getLogger(Loadable.class);
    private String filename = "";
    private int address = 0;
    private FastArray<LoadableListener> listeners = new FastArray();

    public Loadable(String filename, int address) {
        this.setFileName(filename);
        this.setAddress(address);
    }

    public Loadable(String filename) {
        this(filename, 0);
    }

    public Loadable() {
        this("", 0);
    }

    public void setFileName(String s) {
        this.filename = s;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setAddress(int n) {
        this.address = n;
    }

    public int getAddress() {
        return this.address;
    }

    @Override
    public void registerCPU(CPU cpu) {
        cpu.addResetListener(this);
    }

    public void addLoadableListener(LoadableListener l) {
        this.listeners.add(l);
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        int i;
        LoadInfo info = new LoadInfo();
        for (i = 0; i < this.listeners.getSize(); ++i) {
            this.listeners.get(i).startLoad(cpu);
        }
        cpu.load(this.filename, this.address, info);
        for (i = 0; i < this.listeners.getSize(); ++i) {
            this.listeners.get(i).endLoad(cpu, info);
        }
        log.info(this.filename + " loaded at 0x" + Hex.formatWord(info.start) + "-0x" + Hex.formatWord(info.end));
    }

    @Override
    public String toString() {
        return "Loadable " + this.filename + " at 0x" + Hex.formatWord(this.address);
    }
}

