/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.cpu;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import jmce.Jmce;
import jmce.sim.AbstractHardware;
import jmce.sim.BreakPoint;
import jmce.sim.BreakPointExec;
import jmce.sim.BreakPointListener;
import jmce.sim.BreakPointRead;
import jmce.sim.BreakPointWrite;
import jmce.sim.CPU;
import jmce.sim.CPUAbortException;
import jmce.sim.CPUException;
import jmce.sim.CallListener;
import jmce.sim.CpuRuntime;
import jmce.sim.CycleListener;
import jmce.sim.Decoder;
import jmce.sim.ExceptionEvent;
import jmce.sim.ExceptionListener;
import jmce.sim.Hardware;
import jmce.sim.Interrupt;
import jmce.sim.LoadInfo;
import jmce.sim.Loader;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.Opcode;
import jmce.sim.Register;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.SIMInterrupted;
import jmce.sim.Serial;
import jmce.sim.TraceListener;
import jmce.sim.cpu.AbstractDecoder;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.BinaryLoader;
import jmce.sim.cpu.IntelLoader;
import jmce.sim.cpu.MotorolaLoader;
import jmce.sim.cpu.MultiOpcode;
import jmce.sim.cpu.RuntimeOpcode;
import jmce.sim.cpu.SortedVector;
import jmce.sim.terminal.Terminal;
import jmce.util.FastArray;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.util.Timeout;
import jmce.util.Timer;
import jmce.util.TimerListener;
import jmce.util.TimerManager;

public abstract class AbstractCPU
extends AbstractHardware
implements CPU,
BreakPointListener {
    private static final Logger log = Logger.getLogger(AbstractCPU.class);
    public static final long NS1MS = 1000000L;
    public static final long NS100MS = 100000000L;
    private CallListener[] callListeners = null;
    private FastArray<ResetListener> resets = new FastArray();
    private FastArray<Loader> loaders = new FastArray();
    private FastArray<CycleListener> cycleListeners = new FastArray();
    private CycleListener[] cycleListenersVector = new CycleListener[0];
    private FastArray<Decoder> decoders = new FastArray();
    private FastArray<ExceptionListener> exceptionListeners = new FastArray();
    private FastArray<Register> regs = new FastArray();
    protected FastArray<Interrupt> interrupts = new FastArray();
    private Terminal terminal = null;
    private Timeout timeoutUsage = new Timeout(5000L);
    private long oldCycle;
    private MultiOpcode opcodes = new MultiOpcode(0);
    private Thread thread = null;
    private boolean running = false;
    private volatile boolean checkInterrupt = true;
    private int maxOpcodeLen = -1;
    private long clock;
    private int clockPerCycle = 1;
    private long cycle;
    private int endian = 0;
    private long sleepTime;
    private int resetAddress = 0;
    private volatile String abort = null;
    private CpuRuntime runtimeExec;
    private boolean realTime = false;
    protected Memory memory = null;
    protected Memory io = null;
    private volatile double cpuUsage = 0.0;
    private volatile long realClock;
    private int till = -1;
    private TimerManager cycleTimer = new TimerManager("Cycle timer");
    private TimerManager msTimer = new TimerManager("Sec/1000 timer");
    private Timer msTimerFeed = null;
    private Timer timerStatus = null;
    private int cycleMs;
    private FastArray<BreakPoint> bps = new FastArray();
    private boolean bpReceived = false;
    private String bpText = null;
    private boolean trace = false;
    private FastArray<TraceListener> traces = new FastArray();

    public AbstractCPU(String name) {
        super(name);
        this.addDecoder(new AbstractDecoder("%byte", 1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return Hex.formatByte(AbstractCPU.this.fetch(currentPc + 1));
            }
        });
        this.addDecoder(new AbstractDecoder("%word", 2){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return Hex.formatWord(AbstractCPU.this.getWord(currentPc + 1));
            }
        });
        this.addDecoder(new AbstractDecoder("%1", 1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return "";
            }
        });
        this.addDecoder(new AbstractDecoder("%2", 1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return "";
            }
        });
        this.addDecoder(new AbstractDecoder("%3", 1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return "";
            }
        });
        this.addDecoder(new AbstractDecoder("%-1", -1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return "";
            }
        });
        this.addDecoder(new AbstractDecoder("%-2", -2){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return "";
            }
        });
        this.addDecoder(new AbstractDecoder("%-3", -3){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                return "";
            }
        });
        this.addDecoder(new AbstractDecoder("%offset", 1){

            @Override
            protected String implDecode(CPU cpu, CpuRuntime r, int startPc, int len, int currentPc) throws SIMException {
                int offset = AbstractCPU.this.fetch(currentPc + 1);
                String s = Hex.formatByte(offset);
                int pc = startPc + len;
                pc = AbstractCPU.this.addOffset(pc, offset);
                s = s + " [" + AbstractCPU.this.memory.getMemoryName(pc) + "]";
                return s;
            }
        });
        this.addLoader(new MotorolaLoader(".s19"));
        this.addLoader(new IntelLoader(".hex"));
        this.addLoader(new BinaryLoader(".bin"));
        this.addLoader(new BinaryLoader(".rom"));
        this.addLoader(new BinaryLoader(".sys"));
        this.addLoader(new IntelLoader(".ihx"));
        this.msTimerFeed = new Timer(this.cycleMs, false, new TimerListener(){

            @Override
            public void timerExpired() throws SIMException {
                AbstractCPU.this.msTimer.elapsed(1);
                if (AbstractCPU.this.msTimer.getSize() > 0) {
                    AbstractCPU.this.msTimerFeed.setRepeat(true);
                    AbstractCPU.this.msTimerFeed.setTime(AbstractCPU.this.cycleMs);
                } else {
                    log.info("Removed msTimerFeed " + this.toString());
                    AbstractCPU.this.msTimerFeed.setRepeat(false);
                }
            }
        });
    }

    public final int addOffset(int word, int offset) {
        return word + (offset - ((offset & 0x80) << 1)) & 0xFFFF;
    }

    @Override
    public long getCycle() {
        return this.cycle;
    }

    @Override
    public long getClock() {
        return this.clock;
    }

    @Override
    public void setClock(long clock) {
        this.clock = clock;
        if (this.getClockPerCycle() > 0) {
            this.cycleMs = (int)(clock / 1000L / (long)this.clockPerCycle);
        }
    }

    @Override
    public void setClockPerCycle(int n) {
        this.clockPerCycle = n;
        this.cycleMs = (int)(this.clock / 1000L / (long)this.clockPerCycle);
    }

    @Override
    public int getClockPerCycle() {
        return this.clockPerCycle;
    }

    @Override
    public int getDecoderCount() {
        return this.decoders.getSize();
    }

    @Override
    public Decoder addDecoder(Decoder d) {
        this.decoders.add(d);
        return d;
    }

    @Override
    public Decoder getDecoderAt(int i) {
        return this.decoders.get(i);
    }

    @Override
    public int getRegisterCount() {
        return this.regs.getSize();
    }

    @Override
    public Register getRegisterForName(String name) {
        for (int i = 0; i < this.regs.getSize(); ++i) {
            Register r = this.getRegisterAt(i);
            if (!r.getName().equalsIgnoreCase(name)) continue;
            return r;
        }
        return null;
    }

    @Override
    public Register addRegister(Register r) {
        this.regs.add(r);
        return r;
    }

    @Override
    public Register getRegisterAt(int i) {
        return this.regs.get(i);
    }

    @Override
    public void setEndian(int n) {
        this.endian = n;
    }

    @Override
    public final int getEndian() {
        return this.endian;
    }

    @Override
    public final boolean isLittleEndian() {
        return this.endian == 0;
    }

    @Override
    public final boolean isBigEndian() {
        return this.endian == 1;
    }

    @Override
    public void addMemoryWriteListener(MemoryWriteListener l) {
        this.memory.addMemoryWriteListener(l);
    }

    @Override
    public final Memory getMemory() {
        return this.memory;
    }

    protected final void setMemory(Memory m) {
        this.memory = m;
    }

    @Override
    public void addCycleListener(CycleListener l) {
        this.cycleListeners.add(l);
        this.cycleListenersVector = this.cycleListeners.toArray((CycleListener[])this.cycleListenersVector);
    }

    public void setOpcode(AbstractOpcode o) {
        this.opcodes.setOpcode(o);
    }

    public final AbstractOpcode getOpcodeAt(int pc) throws SIMException {
        AbstractOpcode o;
        AbstractOpcode base = this.opcodes;
        while (true) {
            if ((o = base.getOpcode(this.fetch(pc))) == null) {
                return null;
            }
            if (!o.isMultiOpcode()) break;
            base = o;
            ++pc;
        }
        return o;
    }

    @Override
    public final int getLenghtAt(int pc) throws SIMException {
        AbstractOpcode o = this.getOpcodeAt(pc);
        if (o == null) {
            return 1;
        }
        if (o.runtimeOpcode) {
            CpuRuntime rt = this.createRuntime();
            rt.clear();
            rt.pc = pc;
            RuntimeOpcode ro = (RuntimeOpcode)o;
            ro.decode(this, rt);
            return rt.length + o.getLength();
        }
        return o.getLength();
    }

    @Override
    public String decodeAt(int pc) throws SIMException {
        StringBuffer sb = new StringBuffer();
        AbstractOpcode o = this.getOpcodeAt(pc);
        CpuRuntime rt = null;
        sb.append(this.memory.getMemoryName(pc));
        if (o == null) {
            sb.append(" ");
            for (int i = 0; i < this.maxOpcodeLen; ++i) {
                if (i > 0 && this.maxOpcodeLen < 5) {
                    sb.append(" ");
                }
                sb.append(Hex.formatByte(this.fetch(pc + i)));
            }
            sb.append(" Invalid Opcode " + Hex.formatByte(this.fetch(pc)));
        } else {
            int i;
            int length;
            if (o.runtimeOpcode) {
                if (rt == null) {
                    rt = this.createRuntime();
                    rt.clear();
                }
                rt.pc = pc;
                RuntimeOpcode ro = (RuntimeOpcode)o;
                ro.decode(this, rt);
                length = rt.length + ro.getLength();
            } else {
                length = o.getLength();
            }
            if (length > this.maxOpcodeLen) {
                this.maxOpcodeLen = length;
            }
            sb.append(" ");
            for (i = 0; i < length; ++i) {
                if (i > 0 && this.maxOpcodeLen < 5) {
                    sb.append(" ");
                }
                sb.append(Hex.formatByte(this.fetch(pc + i)));
            }
            for (i = length; i < this.maxOpcodeLen; ++i) {
                if (this.maxOpcodeLen < 5) {
                    sb.append(" ");
                }
                sb.append("  ");
            }
            sb.append(" " + o.getDescription());
            int currentPc = pc;
            while (true) {
                Decoder d;
                int index = -1;
                int pos = -1;
                int p = -1;
                for (i = 0; i < this.decoders.getSize(); ++i) {
                    d = this.decoders.get(i);
                    p = sb.indexOf(d.getPattern());
                    if (p == -1) continue;
                    if (pos == -1) {
                        pos = p;
                        index = i;
                        continue;
                    }
                    if (p >= pos) continue;
                    pos = p;
                    index = i;
                }
                if (index == -1) break;
                d = this.decoders.get(index);
                currentPc += d.decode(this, rt, pc, o.getLength(), currentPc, sb);
            }
        }
        return sb.toString();
    }

    @Override
    public final void setByte(int a, int value) throws SIMException {
        this.memory.setMemory(a, value);
    }

    @Override
    public final int fetch(int a) throws SIMException {
        return this.memory.getMemory(a);
    }

    @Override
    public final int getByte(int a) throws SIMException {
        return this.memory.getMemory(a);
    }

    public final int getWordLittle(int a) throws SIMException {
        return this.memory.getMemory(a + 0) | this.memory.getMemory(a + 1) << 8;
    }

    public final int getWordBig(int a) throws SIMException {
        return this.memory.getMemory(a + 1) | this.memory.getMemory(a + 0) << 8;
    }

    protected void resetRegisters() throws SIMException {
        for (int i = 0; i < this.getRegisterCount(); ++i) {
            this.getRegisterAt(i).reset();
        }
    }

    @Override
    public void reset() throws SIMException {
        int i;
        this.resetRegisters();
        this.cycle = 0L;
        this.till = -1;
        for (i = 0; i < this.interrupts.getSize(); ++i) {
            Interrupt isr = this.interrupts.get(i);
            isr.setActive(false);
            isr.resetCounter();
        }
        super.reset();
        i = this.resets.getSize();
        while (--i >= 0) {
            this.resets.get(i).reset(this);
        }
        this.pc(this.getResetAddress());
        if (this.terminal != null) {
            Jmce.showConfig(this, this.terminal);
        }
    }

    @Override
    public void setTill(int till) {
        this.till = till;
    }

    @Override
    public long getCycleMillis() {
        return this.cycleMs;
    }

    @Override
    public void addTimerMs(Timer t) {
        this.msTimer.add(t);
        if (this.msTimerFeed.getStatus() != 1) {
            log.fine("Add msTimerFeed " + this.msTimerFeed.toString());
            this.addTimerCycle(this.msTimerFeed);
        }
    }

    @Override
    public void addTimerCycle(Timer t) {
        this.cycleTimer.add(t);
    }

    @Override
    public int step() throws SIMException {
        return this.stepNoBreak();
    }

    public final int stepNoBreak() throws SIMException {
        this.disableBreakPoints();
        return this.step0();
    }

    private final void checkInterrupt() throws SIMException {
        if (this.checkInterrupt && this.isInterruptEnabled()) {
            int i = this.interrupts.getSize();
            while (--i >= 0) {
                Interrupt irq = this.interrupts.get(i);
                if (!irq.isReady()) continue;
                irq.startISR();
                this.fireISR(irq);
                if (irq.isAutoReset()) {
                    irq.setActive(false);
                }
                return;
            }
            this.checkInterrupt = false;
        }
    }

    public final int step0() throws SIMException {
        int t;
        this.checkBreakPoint();
        this.checkInterrupt();
        int pc = this.pc();
        if (pc == this.till) {
            this.till = -1;
            throw new CPUException(this, "Till break");
        }
        AbstractOpcode o = this.getOpcodeAt(pc);
        if (o == null) {
            throw new CPUException(this, this.decodeAt(pc));
        }
        this.checkBreakPoint();
        if (this.trace) {
            this.trace(this.decodeAt(pc));
        }
        int oldPC = pc;
        CpuRuntime rt = null;
        try {
            if (o.runtimeOpcode) {
                if (rt == null) {
                    rt = this.runtimeExec;
                    rt.clear();
                }
                rt.pc = pc;
                RuntimeOpcode ro = (RuntimeOpcode)o;
                t = ro.exec(rt);
                this.pc(pc + rt.length + ro.getLength());
            } else {
                this.pc(pc + o.getLength());
                t = o.exec(pc);
            }
            o.incCounter();
        }
        catch (SIMInterrupted ie) {
            log.fine(ie.toString() + " AT " + Hex.formatWord(this.pc()) + " ==> " + Hex.formatWord(oldPC));
            this.pc(oldPC);
            return 0;
        }
        catch (SIMException e) {
            this.pc(oldPC);
            throw e;
        }
        if (this.trace) {
            String s = "";
            for (int i = 0; i < this.getRegisterCount(); ++i) {
                Register r = this.getRegisterAt(i);
                s = s + r.getName() + "=" + r.descValue() + " ";
            }
            this.trace(s);
        }
        this.elapsedCycle(t);
        return t;
    }

    private final void elapsedCycle(int t) throws SIMException {
        this.cycle += (long)t;
        this.cycleTimer.elapsed(t);
        int i = this.cycleListenersVector.length;
        while (--i >= 0) {
            this.cycleListenersVector[i].cycle(t);
        }
    }

    private final void checkBreakPoint() throws SIMException {
        if (this.bpReceived) {
            CPUException ex = new CPUException(this, this.bpText);
            this.bpReceived = false;
            this.bpText = null;
            throw ex;
        }
    }

    private final void checkAbort() throws CPUAbortException {
        if (this.abort != null) {
            String s = this.abort;
            this.abort = null;
            throw new CPUAbortException(this, s);
        }
    }

    public final void run0() throws SIMException {
        Timeout timeoutNice = new Timeout(1000L);
        Timeout timeoutSleep = new Timeout(0L, true);
        long count = 0L;
        this.sleepTime = 0L;
        this.abort = null;
        this.stepNoBreak();
        this.enableBreakPoints();
        while (this.running) {
            int n = this.cycleMs;
            while ((n -= this.step0()) > 0) {
            }
            if ((count += 1000000L) < 100000000L) continue;
            this.checkAbort();
            if (!this.realTime) {
                count = 0L;
                if (timeoutNice.isExpired()) {
                    this.sleepTime += this.idle0();
                    timeoutNice.restart();
                }
            } else {
                count = timeoutSleep.getElapsedEx();
                while (count < 100000000L) {
                    long tmp = this.idle0();
                    count += tmp;
                    this.sleepTime += tmp;
                }
                count -= 100000000L;
                timeoutSleep.restart();
            }
            this.calculateUsage();
        }
    }

    private void calculateUsage() {
        if (this.timeoutUsage.isExpired()) {
            int delta = this.timeoutUsage.getElapsed();
            this.sleepTime /= 1000000L;
            this.realClock = (this.cycle - this.oldCycle) * (long)this.clockPerCycle * 1000L / (long)delta;
            this.oldCycle = this.cycle;
            if (this.sleepTime > (long)delta) {
                this.sleepTime = delta;
            }
            log.fine("Calc cpu usage: Delta=" + delta + " Sleep=" + this.sleepTime);
            this.cpuUsage = (int)(10000L * ((long)delta - this.sleepTime) / (long)delta);
            this.cpuUsage /= 100.0;
            this.sleepTime = 0L;
            this.timeoutUsage.restart();
        }
    }

    @Override
    public final void run() {
        while (this.thread != null) {
            try {
                if (!this.running) {
                    Thread.yield();
                    continue;
                }
                this.run0();
            }
            catch (Throwable e) {
                this.stop();
                this.disableBreakPoints();
                this.fireException(e);
                try {
                    PrintStream ps = new PrintStream(new FileOutputStream("ex.txt"));
                    e.printStackTrace(ps);
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setName(this.getName());
            this.thread.start();
        }
        this.running = true;
        this.setStatusLine('W');
    }

    @Override
    public void stop() {
        this.setStatusLine('H');
        this.running = false;
    }

    protected void dumpValue(PrintStream ps, String s1, String s2) {
        while (s1.length() < 10) {
            s1 = " " + s1;
        }
        ps.println(s1 + " " + s2);
    }

    protected void dumpTitle(PrintStream ps, String s1, String s2) {
        ps.println();
        ps.println("===============================================");
        this.dumpValue(ps, s1, s2);
        ps.println("===============================================");
    }

    protected void dumpValue(PrintStream ps, long n, String s) {
        this.dumpValue(ps, "" + n, s);
    }

    @Override
    public void dumpStatistics(String file) throws SIMException {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(file));
            this.dumpStatistics(ps);
            ps.close();
        }
        catch (IOException e) {
            throw new SIMIOException(file, " Writing");
        }
    }

    public void dumpStatistics(PrintStream ps) {
        int i;
        SortedVector<Opcode> v = this.getExecStatistics();
        for (i = 0; i < this.interrupts.getSize(); ++i) {
            if (i == 0) {
                this.dumpTitle(ps, "Execution#", "Interrupt");
            }
            if (this.getInterruptCounter(i) <= 0) continue;
            this.dumpValue(ps, this.getInterruptCounter(i), this.getInterruptName(i));
        }
        this.dumpTitle(ps, "Execution#", "Opcode");
        for (i = 0; i < v.size(); ++i) {
            long l = v.getCounterAt(i);
            for (int j = 0; j < v.getVectorSizeAt(i); ++j) {
                this.dumpValue(ps, l, v.getAt(i, j).getDescription());
            }
        }
    }

    @Override
    public void destroy() throws SIMException {
        this.dumpStatistics("cpu.txt");
        this.running = false;
        this.thread = null;
        super.destroy();
    }

    private void fireException(Throwable e) {
        ExceptionEvent ev = new ExceptionEvent(e);
        for (int i = 0; i < this.exceptionListeners.getSize(); ++i) {
            this.exceptionListeners.get(i).exceptionEvent(ev);
        }
        if (this.terminal != null && this.terminal.getNumStatus() > 0) {
            String s = e.getMessage();
            if (s == null || s.length() < 10) {
                s = e.toString();
            }
            this.terminal.printStatusLine(0, s);
        }
    }

    @Override
    public ExceptionListener getExceptionListenerAt(int i) {
        return this.exceptionListeners.get(i);
    }

    @Override
    public void addExceptionListener(ExceptionListener l) {
        this.exceptionListeners.add(l);
    }

    @Override
    public int getExceptionListenerCount() {
        return this.exceptionListeners.getSize();
    }

    @Override
    public void removeExceptionListener(ExceptionListener l) {
        this.exceptionListeners.remove(l);
    }

    private final long idle0() throws SIMException {
        long elapsed;
        Timeout t = new Timeout(true);
        do {
            Thread.yield();
        } while ((elapsed = t.getElapsedEx()) < 1000000L);
        return elapsed;
    }

    @Override
    public final int idle() throws SIMException {
        long n = this.idle0();
        if (Thread.currentThread() != this.thread) {
            return (int)(n / 1000000L);
        }
        this.sleepTime += n;
        this.checkAbort();
        this.elapsedCycle((int)((long)this.cycleMs * (n / 1000000L)));
        if (this.checkInterrupt && this.isInterruptEnabled()) {
            throw new SIMInterrupted("Interrupt ready");
        }
        this.setStatusLine('*');
        this.calculateUsage();
        return (int)(n / 1000000L);
    }

    @Override
    public Memory getMemoryForName(String name) {
        Object[] memories = this.getHardwareInstances(Memory.class);
        for (int i = 0; i < memories.length; ++i) {
            Memory m = (Memory)memories[i];
            if (!m.getName().equalsIgnoreCase(name)) continue;
            return m;
        }
        return null;
    }

    public void addLoader(Loader loader) {
        this.loaders.add(loader);
    }

    @Override
    public void load(String name, int base, LoadInfo info) throws SIMException {
        this.load(this.getMemory(), name, base, info);
    }

    @Override
    public void load(Memory m, String name, int base, LoadInfo info) throws SIMException {
        for (int i = 0; i < this.loaders.getSize(); ++i) {
            Loader l = this.loaders.get(i);
            if (!l.isFileSupported(name)) continue;
            l.setCPU(this);
            l.load(m, name, base, info);
            return;
        }
        throw new SIMIOException(name, " Unsupported extension");
    }

    @Override
    public int fireISR(Interrupt i) throws SIMException {
        throw new SIMException("ISR not supported");
    }

    public static final String formatFrequence(long hz) {
        if (hz < 1000000L) {
            return hz + "Hz";
        }
        long n1 = hz / 1000000L;
        long n2 = hz % 1000000L / 1000L;
        String s = "" + n2;
        while (s.length() < 3) {
            s = "0" + s;
        }
        return n1 + "." + s + "MHz";
    }

    @Override
    public String getUsageDesc() {
        StringBuffer s = new StringBuffer(this.getName());
        if (this.realTime) {
            s.append("-R");
        }
        s.append(" CLK=" + AbstractCPU.formatFrequence(this.clock));
        s.append(" REAL=" + AbstractCPU.formatFrequence(this.realClock));
        if (this.realTime) {
            s.append(" (" + AbstractCPU.formatFrequence(this.realClock - this.clock) + ")");
        }
        s.append(" VM=" + this.cpuUsage + "%");
        return s.toString();
    }

    @Override
    public double getUsage() {
        return this.cpuUsage;
    }

    public final MultiOpcode getOpcodes() {
        return this.opcodes;
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.maxOpcodeLen = this.opcodes.getMaxLength();
        log.info("Number of opcodes = " + this.opcodes.getOpcodeCount() + ", Max opcode length = " + this.maxOpcodeLen);
        super.init(parent);
        this.terminal = (Terminal)this.getHardwareTree(Serial.class, Terminal.class);
        Timer t = new Timer(10000, true, new TimerListener(){

            @Override
            public void timerExpired() {
                if (AbstractCPU.this.isRunning()) {
                    String s = AbstractCPU.this.getUsageDesc();
                    if (AbstractCPU.this.terminal != null && AbstractCPU.this.terminal.getNumStatus() > 0) {
                        AbstractCPU.this.terminal.printStatusLine(0, s);
                    }
                }
            }
        });
        TimerManager.addTimer(t);
        this.runtimeExec = this.createRuntime();
    }

    @Override
    public void addResetListener(ResetListener l) {
        this.resets.add(l);
    }

    @Override
    public int getMemoryCount() {
        Object[] memories = this.getHardwareInstances(Memory.class);
        return memories.length;
    }

    @Override
    public Memory getMemoryAt(int i) {
        Object[] memories = this.getHardwareInstances(Memory.class);
        return (Memory)memories[i];
    }

    @Override
    public int getBreakPointCount() {
        return this.bps.getSize();
    }

    @Override
    public BreakPoint getBreakPointAt(int i) {
        return this.bps.get(i);
    }

    @Override
    public void removeBreakPoint(BreakPoint b) {
        this.bps.remove(b);
    }

    @Override
    public void removeBreakPoint(int i) {
        this.bps.remove(i);
    }

    @Override
    public BreakPoint addExecBreakPoint(int m, int a) {
        BreakPointExec bp = new BreakPointExec(this, this, this.getMemoryAt(m), a);
        this.bps.add(bp);
        return bp;
    }

    @Override
    public BreakPoint addReadBreakPoint(int m, int a) {
        BreakPointRead bp = new BreakPointRead(this, this, this.getMemoryAt(m), a);
        this.bps.add(bp);
        return bp;
    }

    @Override
    public BreakPoint addWriteBreakPoint(int m, int a) {
        BreakPointWrite bp = new BreakPointWrite(this, this, this.getMemoryAt(m), a);
        this.bps.add(bp);
        return bp;
    }

    @Override
    public void breakPointEvent(BreakPoint bp, String msg) {
        if (this.bpText == null) {
            this.bpText = "";
        }
        this.bpText = this.bpText + msg;
        try {
            this.bpText = this.bpText + " PC " + Hex.formatWord(this.pc());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bpText = this.bpText + "\n";
        this.bpReceived = true;
    }

    void disableBreakPoints() {
        int i = this.bps.getSize();
        while (--i >= 0) {
            this.bps.get(i).setEnabled1(false);
        }
        this.bpReceived = false;
        this.bpText = null;
    }

    void enableBreakPoints() {
        this.bpReceived = false;
        this.bpText = null;
        int i = this.bps.getSize();
        while (--i >= 0) {
            this.bps.get(i).setEnabled1(true);
        }
    }

    @Override
    public void addTraceListener(TraceListener t) {
        this.traces.add(t);
        this.trace = true;
    }

    @Override
    public void removeTraceListener(TraceListener t) {
        this.traces.remove(t);
        this.trace = this.traces.getSize() > 0;
    }

    private void trace(String s) throws SIMException {
        int i = this.traces.getSize();
        while (--i >= 0) {
            this.traces.get(i).trace(s);
        }
    }

    public void setIO(Memory io) {
        this.io = io;
    }

    @Override
    public void addIOReadListener(MemoryReadListener l) {
        this.io.addMemoryReadListener(l);
    }

    @Override
    public void addIOReadListener(int a, MemoryReadListener l) {
        this.io.addMemoryReadListener(a, l);
    }

    @Override
    public void addIOWriteListener(int a, MemoryWriteListener l) {
        this.io.addMemoryWriteListener(a, l);
    }

    @Override
    public void addIOWriteListener(MemoryWriteListener l) {
        this.io.addMemoryWriteListener(l);
    }

    @Override
    public final void setIOByte(int a, int v) throws SIMException {
        this.io.setMemory(a, v);
    }

    @Override
    public final int getIOByte(int a) throws SIMException {
        int v = this.io.getMemory(a);
        return v;
    }

    @Override
    public void setResetAddress(int value) {
        this.resetAddress = value;
    }

    @Override
    public int getResetAddress() {
        return this.resetAddress;
    }

    public int getInterruptCount() {
        return this.interrupts.getSize();
    }

    public String getInterruptName(int n) {
        return this.interrupts.get(n).toString();
    }

    public int getInterruptCounter(int n) {
        return this.interrupts.get(n).getCounter();
    }

    @Override
    public void setRealTime(boolean mode) {
        this.realTime = mode;
    }

    @Override
    public boolean getRealTime() {
        return this.realTime;
    }

    @Override
    public void abort(String s) {
        this.abort = s;
    }

    void updateExecStatistics(SortedVector<Opcode> s, AbstractOpcode o) {
        if (o == null) {
            return;
        }
        if (o.isMultiOpcode()) {
            MultiOpcode mo = (MultiOpcode)o;
            for (int i = 0; i < 256; ++i) {
                this.updateExecStatistics(s, mo.getOpcode(i));
            }
        } else if (o.getCounter() > 0L) {
            s.put(o.getCounter(), o);
        }
    }

    public SortedVector<Opcode> getExecStatistics() {
        SortedVector<Opcode> s = new SortedVector<Opcode>();
        this.updateExecStatistics(s, this.opcodes);
        s.createArray();
        return s;
    }

    protected void halt() throws SIMException {
        if (!this.isInterruptEnabled()) {
            throw new CPUException(this, "HALT with Interrupt disabled");
        }
        while (true) {
            this.idle();
        }
    }

    protected CpuRuntime createRuntime() throws SIMException {
        return null;
    }

    public void setCallListener(int a, CallListener l) {
        if (this.callListeners == null) {
            this.callListeners = new CallListener[this.memory.getSize()];
        }
        this.callListeners[a] = l;
    }

    public CallListener getCallListener(int a) {
        return this.callListeners == null ? null : this.callListeners[a];
    }

    @Override
    public void setStatusLine(char c) {
        if (c != ' ' && this.timerStatus == null) {
            this.timerStatus = new Timer(100, false, new TimerListener(){

                @Override
                public void timerExpired() throws SIMException {
                    AbstractCPU.this.setStatusLine(' ');
                }
            });
        }
        if (this.terminal != null && this.terminal.getNumStatus() > 0) {
            this.terminal.setStatusLine(0, this.terminal.getNumCol() - 1, Character.valueOf(c));
        }
    }

    @Override
    public final void addInterrupt(Interrupt irq) {
        this.interrupts.add(irq);
    }

    @Override
    public final void notifyInterrupt(Interrupt irq) {
        this.checkInterrupt = true;
    }

    public static final boolean bit7(int value) {
        return (value & 0x80) != 0;
    }

    public static final boolean bit0(int value) {
        return (value & 1) != 0;
    }
}

