/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jmce.sim.DiskCPM;
import jmce.sim.Hardware;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.cpm.CpmDisk;
import jmce.sim.cpm.CpmFile;
import jmce.sim.cpm.DPB;
import jmce.sim.cpm.DPB3740;
import jmce.sim.disk.MemoryDisk;
import jmce.util.Logger;

public class DirDiskCPM
extends MemoryDisk
implements DiskCPM {
    private static Logger log = Logger.getLogger(DirDiskCPM.class);
    private static final String bootloader = "BOOTLOADER.BIN";
    private DPB dpb;
    private String directory;
    private boolean vol = false;
    private CpmDisk disk = null;

    public DirDiskCPM() {
        this.setDPB(new DPB3740());
        this.setDirectory("data");
    }

    private boolean isValidCpmFile(String name) {
        int dot = name.indexOf(46);
        if (dot == -1) {
            return name.length() <= 8;
        }
        int dot2 = name.indexOf(dot + 1, 46);
        if (dot2 != -1) {
            return false;
        }
        if (dot == 0) {
            return false;
        }
        if (dot > 8) {
            return false;
        }
        return name.length() - dot <= 4;
    }

    @Override
    public void setDPB(DPB dpb) {
        this.dpb = dpb;
    }

    public void setDirectory(String s) {
        this.directory = s;
    }

    @Override
    public DPB getDPB() {
        return this.dpb;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean getVolatile() {
        return this.vol;
    }

    public void setVolatile(boolean mode) {
        this.vol = mode;
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.setNumSector(this.dpb.getSPT());
        this.setNumHead(1);
        this.setNumTrack(this.dpb.getTRK());
        this.setSectorSize(128);
        super.init(parent);
        this.mount();
    }

    @Override
    public void destroy() throws SIMException {
        super.destroy();
        if (this.disk == null) {
            return;
        }
        if (this.vol) {
            log.info("Directory R/O");
            return;
        }
        this.disk = new CpmDisk(this.dpb, this);
        try {
            this.disk.mount();
        }
        catch (Exception e) {
            throw new SIMIOException(this.directory, e.getMessage());
        }
        log.fine("Process " + this.disk + " Files=" + this.disk.getFileCount());
        for (int i = 0; i < this.disk.getFileCount(); ++i) {
            CpmFile f = this.disk.getFileAt(i);
            String to = this.directory + "/";
            if (f.getUser() != 0) {
                to = to + f.getUser() + "/";
            }
            to = to + f.getName();
            log.fine("Write " + f + " as " + to);
            try {
                this.disk.getFile(f, to);
                continue;
            }
            catch (Exception e) {
                throw new SIMIOException(f.getName(), e.toString());
            }
        }
    }

    public void mountDir(String s, int u) throws Exception {
        File file = new File(s);
        if (!file.isDirectory()) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            log.fine("Process FILE=" + file);
            if (file.isDirectory()) continue;
            String name = file.getName().toUpperCase();
            if (name.equals(bootloader)) {
                this.writeBootLoader(this.directory + "/" + bootloader);
                continue;
            }
            if (this.isValidCpmFile(name)) {
                FileInputStream is = new FileInputStream(file);
                log.finer("Writing FILE=" + file);
                this.disk.putFile(u, name, is);
                is.close();
                continue;
            }
            log.info(name + " is not a valid CP/M file");
        }
    }

    @Override
    public boolean mount() throws SIMException {
        if (this.isMounted()) {
            return true;
        }
        super.mount();
        this.disk = new CpmDisk(this.dpb, this);
        try {
            this.disk.format();
            this.disk.mount();
            this.mountDir(this.directory, 0);
            for (int u = 1; u < 16; ++u) {
                this.mountDir(this.directory + "/" + u, u);
            }
            return true;
        }
        catch (Exception e) {
            throw new SIMIOException(this.directory, e.toString());
        }
    }

    private void writeBootLoader(String name) throws SIMException {
        log.fine("Write bootloader from " + name);
        byte[] sector = this.getBuffer();
        int t = 0;
        int h = 0;
        int s = 1;
        try {
            FileInputStream is = new FileInputStream(name);
            while (is.read(sector) > 0) {
                log.fine("Write T=" + t + " H=" + h + " S=" + s);
                this.write(t, h, s);
                if (++s <= this.getNumSector()) continue;
                s = 1;
                if (++h < this.getNumHead()) continue;
                h = 0;
                ++t;
            }
            is.close();
        }
        catch (IOException e) {
            throw new SIMIOException(this.directory, e.toString());
        }
    }

    @Override
    public String toString() {
        return "Dir=" + this.directory + " " + this.getNumTrack() + "/" + this.getNumHead() + "/" + this.getNumSector() + "/" + this.getSectorSize() + " " + this.getDiskSizeString() + " R/O=" + this.vol;
    }
}

