/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.disk;

import jmce.sim.SIMException;
import jmce.sim.disk.AbstractDisk;

public class MemoryDisk
extends AbstractDisk {
    private byte[] disk = null;

    public MemoryDisk() {
    }

    public MemoryDisk(int track, int head, int sector, int ssize) {
        super(track, head, sector, ssize);
    }

    @Override
    public boolean mount() throws SIMException {
        if (this.isMounted()) {
            return true;
        }
        if (this.disk == null) {
            this.disk = new byte[this.getNumTrack() * this.getNumHead() * this.getNumSector() * this.getSectorSize()];
        }
        return this.setMounted(true);
    }

    @Override
    protected final int write(int pos) throws SIMException {
        int s = this.getSectorSize();
        System.arraycopy(this.buffer, 0, this.disk, pos, s);
        return s;
    }

    @Override
    protected final int read(int pos) throws SIMException {
        int s = this.getSectorSize();
        System.arraycopy(this.disk, pos, this.buffer, 0, s);
        return s;
    }

    @Override
    public String toString() {
        return "Memory " + this.getNumTrack() + "/" + this.getNumHead() + "/" + this.getNumSector() + "/" + this.getSectorSize() + " " + this.getDiskSizeString();
    }
}

