/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.memory;

import java.util.logging.Logger;
import jmce.sim.SIMException;
import jmce.sim.memory.PlainMemory;
import jmce.util.Hex;

public class BankedMemory
extends PlainMemory {
    private static final Logger log = Logger.getLogger(BankedMemory.class.getName());
    private int bank = 0;
    private int numBank = 0;
    private int pageSize = 0;
    private int pageShift = 0;
    private int pageMask = 0;
    private int numPage = 0;
    private int[][] pages;
    private int sharedStart = 0;
    private int sharedSize = 0;
    private boolean mmuInit = false;

    public BankedMemory() {
    }

    public BankedMemory(String name, int bankSize, int numBank, int numPage, int pageSize) {
        super(name, bankSize);
        this.setNumPage(numPage);
        this.setPageSize(pageSize);
        this.setNumBank(numBank);
    }

    public final void setPageSize(int n) {
        this.pageSize = n;
        this.pageShift = 0;
        n >>>= 1;
        while (n != 0) {
            ++this.pageShift;
            n >>>= 1;
        }
        this.pageMask = (1 << this.pageShift) - 1;
        log.info("PageSize=" + this.pageSize + " Shift=" + this.pageShift + " mask=" + this.pageMask);
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final void setNumPage(int n) {
        this.numPage = n;
    }

    public final int getNumPage() {
        return this.numPage;
    }

    public final void setNumBank(int n) {
        this.numBank = n;
    }

    public final int getNumBank() {
        return this.numBank;
    }

    protected final void initMmu() {
        int bank;
        log.info("InitMMU NumBank=" + this.numBank + " PageSize=" + this.pageSize + " NumPage=" + this.numPage + " Size=" + this.getSize() + " SharedStart=" + this.sharedStart + " Shared size=" + this.sharedSize);
        this.mmuInit = true;
        this.pages = new int[this.numBank][this.numPage];
        this.tmpMemory = BankedMemory.allocMemory(this.getSize());
        BankedMemory.copyMemory(this.memory, 0, this.tmpMemory, 0, this.size);
        this.memory = BankedMemory.allocMemory(this.getSize() * this.numBank);
        for (bank = 0; bank < this.numBank; ++bank) {
            BankedMemory.copyMemory(this.tmpMemory, 0, this.memory, bank * this.size, this.size);
            for (int page = 0; page < this.numPage; ++page) {
                this.setPageMap(bank, page, bank * this.numPage + page);
            }
        }
        for (bank = 1; bank < this.numBank; ++bank) {
            for (int i = 0; i < this.sharedSize; ++i) {
                this.setPageMap(bank, this.sharedStart + i, this.sharedStart + i);
            }
        }
        this.setBank(0);
        this.showMemory();
    }

    public final void setSharedStart(int n) {
        this.sharedStart = n;
    }

    public final void setSharedSize(int n) {
        this.sharedSize = n;
    }

    public final int getSharedSize() {
        return this.sharedSize;
    }

    public final int getSharedStart() {
        return this.sharedStart;
    }

    public final int getBank() {
        return this.bank;
    }

    public final void setBank(int n) {
        this.bank = n;
    }

    private final int mmuLookup(int a) {
        return this.pages[this.bank][a >>> this.pageShift] + (a & this.pageMask);
    }

    @Override
    protected final int get(int a) {
        if (this.mmuInit) {
            return this.memory[this.mmuLookup(a)] & 0xFF;
        }
        return super.get(a);
    }

    @Override
    protected final void set(int a, int v) {
        if (this.mmuInit) {
            this.memory[this.mmuLookup((int)a)] = (byte)v;
            return;
        }
        super.set(a, v);
    }

    @Override
    public void reset() throws SIMException {
        this.memory = BankedMemory.allocMemory(this.getSize());
        this.mmuInit = false;
        super.reset();
    }

    public boolean isMmuInitialized() {
        return this.mmuInit;
    }

    public void showMemory() {
        String s = this.getSize() / 1024 + "KB " + "Bank=" + this.numBank + " " + "Size=" + this.getSize() * this.numBank / 1024 + "KB " + "Page=" + this.pageSize + " " + "Pbank=" + this.numPage + " ";
        if (this.sharedSize > 0) {
            s = s + "Segment=0000-" + Hex.formatWord(this.sharedStart * this.pageSize - 1) + " " + "Ssize=" + this.sharedSize * this.pageSize / 1024 + "KB";
        }
        log.info(s);
        for (int i = 0; i < this.numBank; ++i) {
            s = "BANK #" + i + " ";
            for (int j = 0; j < this.numPage; ++j) {
                if (j > 0) {
                    s = s + ",";
                }
                s = s + Hex.formatDword(this.getPageMap(i, j) * this.pageSize);
            }
            log.fine(s);
        }
    }

    public final void setPageMap(int bank, int page, int p) {
        this.pages[bank][page] = p << this.pageShift;
    }

    public final int getPageMap(int bank, int page) {
        return this.pages[bank][page] >>> this.pageShift;
    }

    @Override
    public String toString() {
        String s = "MMU " + this.numBank + "x" + this.getSize() / 1024 + " KB";
        if (this.sharedSize > 0) {
            s = s + " Shared " + Hex.formatWord(this.sharedStart * this.pageSize) + "-" + Hex.formatWord((this.sharedStart + this.sharedSize) * this.pageSize - 1);
        }
        s = s + " MMU=" + this.mmuInit;
        return s;
    }
}

