/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.memory;

import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.memory.PlainMemory;

public class MappedMemory
extends PlainMemory {
    protected int page = 1024;
    protected Page[] pages = null;

    public MappedMemory(String name, int size, int page) {
        super(name, size);
        this.setPage(page);
    }

    public MappedMemory(String name, int size) {
        this(name, size, 1024);
    }

    public MappedMemory() {
        this("MapMemory", 0x100000, 4096);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void mapMemory(Memory m, int address, int offset, int size) throws SIMException {
        if (size % this.page != 0) {
            throw new SIMException("MapMemory size must be multiple of " + this.page);
        }
        if (address % this.page != 0) {
            throw new SIMException("MapMemory address must be multiple of " + this.page);
        }
        if (this.pages == null) {
            if (this.getSize() % this.page != 0) {
                throw new SIMException("Memory size " + this.getSize() + " not compatible with page size " + this.page);
            }
            this.pages = new Page[this.getSize() / this.page];
        }
        int i = address / this.page;
        while (size > 0) {
            Page p;
            this.pages[i] = p = new Page(m, offset);
            ++i;
            offset += this.page;
            size -= this.page;
        }
    }

    @Override
    protected Memory mapMemory(int a) {
        if (this.pages == null) {
            return this;
        }
        Page p = this.pages[a / this.page];
        if (p == null) {
            return this;
        }
        if (p.m == null) {
            return this;
        }
        return p.m;
    }

    @Override
    protected int mapAddress(int a) {
        if (this.pages == null) {
            return a;
        }
        Page p = this.pages[a / this.page];
        if (p == null) {
            return a;
        }
        if (p.m == null) {
            return a;
        }
        return a % this.page + p.offset;
    }

    @Override
    public String toString() {
        return "Map PAGE=" + this.page + " " + super.toString();
    }

    class Page {
        Memory m;
        int offset;

        Page(Memory m, int offset) {
            this.m = m;
            this.offset = offset;
        }
    }
}

