/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.serial;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.serial.RXTX;

public class SerialRXTX
extends RXTX {
    public SerialRXTX() {
        this("COM1");
    }

    public SerialRXTX(String port) {
        this.setName("RXTXSerial");
        this.setPortName(port);
    }

    @Override
    protected void registerPort(CommPort port) throws SIMException {
        super.registerPort(port);
        this.connected = true;
    }

    @Override
    protected void connect() throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.getPortName());
        if (portIdentifier.isCurrentlyOwned()) {
            throw new SIMIOException(this.getPortName(), " is Busy");
        }
        CommPort p = portIdentifier.open(this.getClass().getName(), 2000);
        if (!(p instanceof SerialPort)) {
            try {
                p.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SIMIOException(this.getPortName(), " not a serial port!");
        }
        this.registerPort(p);
    }

    @Override
    public String toString() {
        return "SerialRXTX on " + this.getPortName();
    }
}

